/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.genesis.step;

import com.aeontronix.commons.StringUtils;
import com.aeontronix.genesis.InvalidVariableException;
import com.aeontronix.genesis.TemplateExecutionException;
import com.aeontronix.genesis.TemplateExecutor;
import com.aeontronix.genesis.VariableMissingException;
import com.aeontronix.genesis.step.InputOption;
import com.aeontronix.genesis.step.Step;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Input
extends Step {
    private static final Logger logger = LoggerFactory.getLogger(Input.class);
    @JsonProperty(required=true)
    protected String var;
    @JsonProperty(required=true)
    protected String message;
    @JsonProperty
    protected String description;
    @JsonProperty(value="default")
    protected String defaultValue;
    @JsonProperty
    protected boolean blankAllowed;
    @JsonProperty
    protected List<InputOption> options;
    @JsonProperty
    protected boolean advanced;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(TemplateExecutor exec) throws TemplateExecutionException {
        this.var = exec.filter(this.var);
        this.message = exec.filter(this.message);
        this.description = exec.filter(this.description);
        this.defaultValue = exec.filter(this.defaultValue);
        if (this.options != null) {
            for (InputOption option : this.options) {
                option.setId(exec.filter(option.getId()));
                option.setText(exec.filter(option.getText()));
            }
        }
        this.updateDefaults(exec);
        if (!exec.containsVariable(this.var)) {
            boolean v;
            String val = null;
            String df = this.defaultValue;
            String dfOverride = exec.getDefaultValue(this.var);
            if (StringUtils.isNotBlank((String)dfOverride)) {
                df = dfOverride;
            }
            boolean bl = v = exec.isNonInteractive() || df != null && this.advanced && !exec.isAdvanced();
            if (v) {
                if (df == null) throw new VariableMissingException("Variable " + this.var + " is missing", this);
                val = df;
            } else {
                while (val == null) {
                    val = exec.getUi().requestString(this.message, df, this.options);
                }
            }
            if (!this.checkValid(val)) {
                throw new InvalidVariableException("Invalid variable " + this.var + " value: " + val);
            }
            exec.setVariable(this.var, val);
            return;
        } else {
            String value = exec.getVariable(this.var);
            if (this.checkValid(value)) return;
            throw new InvalidVariableException("Invalid variable " + this.var + " value: " + value);
        }
    }

    private void updateDefaults(TemplateExecutor exec) throws TemplateExecutionException {
        if (this.defaultValue != null && exec.resolveVariable(this.var) == null) {
            exec.getDefaults().put(this.var, this.defaultValue);
        }
    }

    private boolean checkValid(String val) {
        if (this.options != null && !this.options.isEmpty()) {
            for (InputOption option : this.options) {
                if (!option.getId().equalsIgnoreCase(val)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static enum InputType {
        STRING,
        BOOLEAN;

    }
}

