/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.genesis.step;

import com.aeontronix.genesis.step.ConditionalSteps;
import com.aeontronix.genesis.step.FilesStep;
import com.aeontronix.genesis.step.Input;
import com.aeontronix.genesis.step.Step;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class StepTypeIdResolver
implements TypeIdResolver {
    private final Map<String, Class<? extends Step>> mappings = new HashMap<String, Class<? extends Step>>();
    private final Map<Class<? extends Step>, String> rev = new HashMap<Class<? extends Step>, String>();
    private JavaType mBaseType;
    private static HashMap<String, Class<? extends Step>> additionalSteps = new HashMap();

    public static void registerStep(String name, Class<? extends Step> stepClass) {
        additionalSteps.put(name, stepClass);
    }

    public StepTypeIdResolver() {
        this.mappings.put("input", Input.class);
        this.mappings.put("conditional", ConditionalSteps.class);
        this.mappings.put("files", FilesStep.class);
        this.mappings.putAll(additionalSteps);
    }

    public void init(JavaType baseType) {
        this.mBaseType = baseType;
    }

    public String idFromValue(Object o) {
        return this.rev.get(o.getClass());
    }

    public String idFromValueAndType(Object o, Class<?> aClass) {
        return this.idFromValue(o);
    }

    public String idFromBaseType() {
        return this.idFromValueAndType(null, this.mBaseType.getRawClass());
    }

    public String getDescForKnownTypeIds() {
        return null;
    }

    public JavaType typeFromId(DatabindContext context, String id) throws IOException {
        Class<? extends Step> cl = this.mappings.get(id);
        if (cl != null) {
            return TypeFactory.defaultInstance().constructSpecializedType(this.mBaseType, cl);
        }
        return TypeFactory.unknownType();
    }

    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.CUSTOM;
    }
}

