package com.aeontronix.restclient.http.apache;

import com.aeontronix.restclient.http.HTTPRequest;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.InputStreamEntity;

import java.io.InputStream;
import java.net.URI;

public class HTTPRequestApacheImpl implements HTTPRequest {
    HttpRequestBase request;

    public HTTPRequestApacheImpl(HttpRequestBase request) {
        this.request = request;
    }

    @Override
    public URI getURI() {
        return request.getURI();
    }

    @Override
    public void setURI(URI uri) {
        request.setURI(uri);
    }

    @Override
    public boolean isBodyAllowed() {
        return request instanceof HttpEntityEnclosingRequestBase;
    }

    @Override
    public void setBody(InputStream is) {
        ((HttpEntityEnclosingRequestBase) request).setEntity(new InputStreamEntity(is));
    }

    @Override
    public void setBody(byte[] data) {
        ((HttpEntityEnclosingRequestBase) request).setEntity(new ByteArrayEntity(data));
    }

    @Override
    public void setHeader(String key, String value) {
        request.setHeader(key, value);
    }

    @Override
    public boolean isRepeatable() {
        if (request instanceof HttpEntityEnclosingRequestBase) {
            final HttpEntity entity = ((HttpEntityEnclosingRequestBase) request).getEntity();
            if (entity != null) {
                return entity.isRepeatable();
            }
        }
        return true;
    }

    @Override
    public String getMethod() {
        return request.getMethod();
    }
}
