/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.restclient.http.apache;

import com.aeontronix.commons.exception.UnexpectedException;
import com.aeontronix.restclient.ProxySettings;
import com.aeontronix.restclient.RESTClient;
import com.aeontronix.restclient.RequestParameters;
import com.aeontronix.restclient.http.HTTPClient;
import com.aeontronix.restclient.http.HTTPRequest;
import com.aeontronix.restclient.http.HTTPResponse;
import com.aeontronix.restclient.http.apache.HTTPRequestApacheImpl;
import com.aeontronix.restclient.http.apache.HTTPResponseApacheImpl;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.jetbrains.annotations.NotNull;

public class HTTPClientApacheImpl
implements HTTPClient {
    private final CloseableHttpClient httpClient;

    public HTTPClientApacheImpl(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public HTTPClientApacheImpl(RESTClient.Builder rb, boolean insecure, Integer connectionTimeout) {
        try {
            ProxySettings proxySettings;
            RequestConfig.Builder customCfg = RequestConfig.custom();
            RequestParameters rp = rb.getRequestParameters();
            if (connectionTimeout != null) {
                customCfg = customCfg.setConnectionRequestTimeout(connectionTimeout.intValue());
            }
            if (rp.getSocketTimeout() != null) {
                customCfg = customCfg.setSocketTimeout(rp.getSocketTimeout().intValue());
            }
            if (rp.getConnectionPoolTimeout() != null) {
                customCfg = customCfg.setConnectionRequestTimeout(rp.getConnectionPoolTimeout().intValue());
            }
            HttpClientBuilder builder = HttpClientBuilder.create().useSystemProperties().setDefaultRequestConfig(customCfg.build()).setMaxConnTotal(rb.getMaxConnTotal()).setMaxConnPerRoute(rb.getMaxConnPerRoute());
            if (insecure) {
                SSLContextBuilder sslContextBuilder = new SSLContextBuilder();
                sslContextBuilder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
                SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContextBuilder.build(), (HostnameVerifier)new NoopHostnameVerifier());
                builder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf);
            }
            if (!rb.isCookies()) {
                builder.disableCookieManagement();
            }
            if ((proxySettings = rb.getProxySettings()) != null) {
                HttpHost proxyHost = new HttpHost(proxySettings.getProxyUri().toString());
                DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxyHost){

                    public HttpRoute determineRoute(HttpHost host, HttpRequest request, HttpContext context) throws HttpException {
                        String hostname = host.getHostName();
                        if (proxySettings.getNonProxyHosts().contains(hostname.toLowerCase())) {
                            return new HttpRoute(host);
                        }
                        return super.determineRoute(host, request, context);
                    }
                };
                if (proxySettings.getProxyUsername() != null || proxySettings.getProxyPassword() != null) {
                    BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                    credsProvider.setCredentials(new AuthScope(proxyHost), (Credentials)new UsernamePasswordCredentials(proxySettings.getProxyUsername(), proxySettings.getProxyPassword()));
                    builder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
                }
                builder.setRoutePlanner((HttpRoutePlanner)routePlanner);
            }
            this.httpClient = builder.build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    @NotNull
    public HTTPResponse execute(HTTPRequest request, RequestParameters requestParameters) throws IOException {
        HttpRequestBase httpClientRequest = ((HTTPRequestApacheImpl)request).request;
        RequestConfig.Builder config = RequestConfig.custom();
        if (requestParameters.getConnectionTimeout() != null) {
            config.setConnectTimeout(requestParameters.getConnectionTimeout().intValue());
        }
        if (requestParameters.getSocketTimeout() != null) {
            config.setSocketTimeout(requestParameters.getSocketTimeout().intValue());
        }
        if (requestParameters.getConnectionPoolTimeout() != null) {
            config.setConnectionRequestTimeout(requestParameters.getConnectionPoolTimeout().intValue());
        }
        httpClientRequest.setConfig(config.build());
        CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpClientRequest);
        return new HTTPResponseApacheImpl(response);
    }

    @NotNull
    public HTTPRequest createGetRequest() {
        return new HTTPRequestApacheImpl((HttpRequestBase)new HttpGet());
    }

    @NotNull
    public HTTPRequest createPostRequest() {
        return new HTTPRequestApacheImpl((HttpRequestBase)new HttpPost());
    }

    @NotNull
    public HTTPRequest createPutRequest() {
        return new HTTPRequestApacheImpl((HttpRequestBase)new HttpPut());
    }

    @NotNull
    public HTTPRequest createHeadRequest() {
        return new HTTPRequestApacheImpl((HttpRequestBase)new HttpHead());
    }

    @NotNull
    public HTTPRequest createDeleteRequest() {
        return new HTTPRequestApacheImpl((HttpRequestBase)new HttpDelete());
    }

    @NotNull
    public HTTPRequest createPatchRequest() {
        return new HTTPRequestApacheImpl((HttpRequestBase)new HttpPatch());
    }

    @NotNull
    public HTTPRequest createOptionsRequest() {
        return new HTTPRequestApacheImpl((HttpRequestBase)new HttpOptions());
    }

    @NotNull
    public HTTPRequest createTraceRequest() {
        return new HTTPRequestApacheImpl((HttpRequestBase)new HttpTrace());
    }

    @NotNull
    public HTTPRequest createRequest(final @NotNull String method) {
        return new HTTPRequestApacheImpl((HttpRequestBase)new HttpEntityEnclosingRequestBase(){

            public String getMethod() {
                return method;
            }
        });
    }
}

