/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.restclient.http.apache;

import com.aeontronix.restclient.RESTException;
import com.aeontronix.restclient.http.HTTPResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.entity.ContentType;

public class HTTPResponseApacheImpl
implements HTTPResponse {
    private final CloseableHttpResponse response;

    public HTTPResponseApacheImpl(CloseableHttpResponse response) {
        this.response = response;
    }

    public int getStatusCode() {
        return this.response.getStatusLine().getStatusCode();
    }

    public String getStatusReasons() {
        return this.response.getStatusLine().getReasonPhrase();
    }

    public String getStatusProtocolVersion() {
        return this.response.getStatusLine().getProtocolVersion().toString();
    }

    public boolean hasContent() {
        return this.response.getEntity() != null;
    }

    public InputStream getContentStream() throws RESTException {
        try {
            return this.response.getEntity().getContent();
        }
        catch (IOException e) {
            throw new RESTException(e.getMessage(), (Throwable)e);
        }
    }

    public long getContentLength() {
        HttpEntity entity = this.response.getEntity();
        return entity != null ? entity.getContentLength() : -1L;
    }

    public String getContentEncoding() {
        Header contentEncoding;
        HttpEntity entity = this.response.getEntity();
        if (entity != null && (contentEncoding = entity.getContentEncoding()) != null) {
            return contentEncoding.getValue();
        }
        return null;
    }

    public String getHeader(String name) {
        Header header = this.response.getFirstHeader(name);
        return header != null ? header.getValue() : null;
    }

    public List<String> getHeaders(String name) {
        Header[] headers = this.response.getHeaders(name);
        if (headers != null) {
            return Arrays.stream(headers).map(NameValuePair::getValue).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public Map<String, List<String>> getAllHeaders() {
        HashMap<String, List<String>> results = new HashMap<String, List<String>>();
        for (Header header : this.response.getAllHeaders()) {
            results.computeIfAbsent(header.getName(), s -> new ArrayList()).add(header.getValue());
        }
        return results;
    }

    public boolean isJson() {
        return "application/json".equalsIgnoreCase(this.getContentMimeType());
    }

    public String getContentMimeType() {
        ContentType contentType;
        HttpEntity entity = this.response.getEntity();
        if (entity != null && (contentType = ContentType.get((HttpEntity)entity)) != null) {
            return contentType.getMimeType();
        }
        return null;
    }

    public void close() throws IOException {
        this.response.close();
    }
}

