/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.restclient.http.apache;

import com.aeontronix.restclient.http.HTTPRequest;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.InputStreamEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HTTPRequestApacheImpl
implements HTTPRequest {
    HttpRequestBase request;

    public HTTPRequestApacheImpl(HttpRequestBase request) {
        this.request = request;
    }

    public URI getURI() {
        return this.request.getURI();
    }

    public void setURI(URI uri) {
        this.request.setURI(uri);
    }

    public boolean isBodyAllowed() {
        return this.request instanceof HttpEntityEnclosingRequestBase;
    }

    public void setBody(InputStream is) {
        ((HttpEntityEnclosingRequestBase)this.request).setEntity((HttpEntity)new InputStreamEntity(is));
    }

    public void setBody(byte[] data) {
        ((HttpEntityEnclosingRequestBase)this.request).setEntity((HttpEntity)new ByteArrayEntity(data));
    }

    public boolean hasBody() {
        if (this.request instanceof HttpEntityEnclosingRequestBase) {
            return ((HttpEntityEnclosingRequestBase)this.request).getEntity() != null;
        }
        return false;
    }

    @Nullable
    public InputStream getContent() throws IOException {
        HttpEntity entity = this.getEntity();
        if (entity != null) {
            return entity.getContent();
        }
        return null;
    }

    public long getContentSize() {
        HttpEntity entity = this.getEntity();
        if (entity != null) {
            return entity.getContentLength();
        }
        return -1L;
    }

    private HttpEntity getEntity() {
        HttpEntity entity;
        if (this.request instanceof HttpEntityEnclosingRequestBase && (entity = ((HttpEntityEnclosingRequestBase)this.request).getEntity()) != null) {
            return entity;
        }
        return null;
    }

    public void setHeader(String key, String value) {
        this.request.setHeader(key, value);
    }

    @NotNull
    public Map<String, List<String>> getAllHeaders() {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        Header[] allHeaders = this.request.getAllHeaders();
        if (allHeaders != null) {
            for (Header header : allHeaders) {
                headers.computeIfAbsent(header.getName(), s -> new ArrayList()).add(header.getValue());
            }
        }
        return headers;
    }

    public boolean isRepeatable() {
        HttpEntity entity;
        if (this.request instanceof HttpEntityEnclosingRequestBase && (entity = ((HttpEntityEnclosingRequestBase)this.request).getEntity()) != null) {
            return entity.isRepeatable();
        }
        return true;
    }

    public String getMethod() {
        return this.request.getMethod();
    }
}

