/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.restclient.json;

import com.aeontronix.restclient.RESTException;
import com.aeontronix.restclient.RESTResponse;
import com.aeontronix.restclient.ResponseConversionException;
import com.aeontronix.restclient.ResponseType;
import com.aeontronix.restclient.ResultsPage;
import com.aeontronix.restclient.json.JsonConverter;
import com.aeontronix.restclient.json.JsonConvertionException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DatabindException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class JsonConverterJacksonImpl
implements JsonConverter {
    public ObjectMapper objectMapper;

    public JsonConverterJacksonImpl(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public byte[] convertToJson(Object object) throws JsonConvertionException {
        try {
            return this.objectMapper.writeValueAsBytes(object);
        }
        catch (JsonProcessingException e) {
            throw new JsonConvertionException((Throwable)e);
        }
    }

    public String convertToJsonString(Object object) throws JsonConvertionException {
        try {
            return this.objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new JsonConvertionException((Throwable)e);
        }
    }

    public <X> X convertFromJson(ResponseType<X> responseType, InputStream is, String jsonPointerPath) throws RESTException, ResponseConversionException {
        try {
            if (jsonPointerPath != null) {
                JsonNode rootNode = this.objectMapper.readTree(is);
                JsonNode dataPath = rootNode.at(jsonPointerPath);
                switch (responseType.getType()) {
                    case OBJECT: {
                        return (X)this.objectMapper.readerFor(responseType.getClassType()).readValue(dataPath);
                    }
                    case LIST: {
                        return (X)this.objectMapper.readerForListOf(responseType.getClassType()).readValue(dataPath);
                    }
                }
                throw new IllegalArgumentException("Invalid ResponseType type: " + responseType.getType());
            }
            switch (responseType.getType()) {
                case OBJECT: {
                    return (X)this.objectMapper.readValue(is, responseType.getClassType());
                }
                case LIST: {
                    return (X)this.objectMapper.readerForListOf(responseType.getClassType()).readValue(is);
                }
            }
            throw new IllegalArgumentException("Invalid ResponseType type: " + responseType.getType());
        }
        catch (DatabindException e) {
            throw new ResponseConversionException((Throwable)e);
        }
        catch (IOException e) {
            throw new RESTException(e.getMessage(), (Throwable)e);
        }
    }

    public <X> ResultsPage toPage(Class<X> classType, RESTResponse response) throws RESTException, ResponseConversionException {
        try {
            JsonNode root = this.objectMapper.readTree(response.getContentStream());
            JsonNode values = root.at(response.getRequest().getPageValuesPath());
            return new ResultsPage((List)this.objectMapper.readerForListOf(classType).treeToValue((TreeNode)values, (JavaType)this.objectMapper.getTypeFactory().constructCollectionType(List.class, classType)));
        }
        catch (DatabindException e) {
            throw new ResponseConversionException((Throwable)e);
        }
        catch (IOException e) {
            throw new RESTException(e.getMessage(), (Throwable)e);
        }
    }
}

