/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.cdt;

import com.aerospike.client.Operation;
import com.aerospike.client.Value;
import com.aerospike.client.cdt.CDT;
import com.aerospike.client.cdt.CTX;
import com.aerospike.client.cdt.MapOrder;
import com.aerospike.client.cdt.MapPolicy;
import com.aerospike.client.util.Packer;
import java.util.List;
import java.util.Map;

public class MapOperation {
    private static final int SET_TYPE = 64;
    protected static final int ADD = 65;
    protected static final int ADD_ITEMS = 66;
    protected static final int PUT = 67;
    protected static final int PUT_ITEMS = 68;
    protected static final int REPLACE = 69;
    protected static final int REPLACE_ITEMS = 70;
    private static final int INCREMENT = 73;
    private static final int DECREMENT = 74;
    private static final int CLEAR = 75;
    private static final int REMOVE_BY_KEY = 76;
    private static final int REMOVE_BY_INDEX = 77;
    private static final int REMOVE_BY_RANK = 79;
    private static final int REMOVE_BY_KEY_LIST = 81;
    private static final int REMOVE_BY_VALUE = 82;
    private static final int REMOVE_BY_VALUE_LIST = 83;
    private static final int REMOVE_BY_KEY_INTERVAL = 84;
    private static final int REMOVE_BY_INDEX_RANGE = 85;
    private static final int REMOVE_BY_VALUE_INTERVAL = 86;
    private static final int REMOVE_BY_RANK_RANGE = 87;
    private static final int REMOVE_BY_KEY_REL_INDEX_RANGE = 88;
    private static final int REMOVE_BY_VALUE_REL_RANK_RANGE = 89;
    private static final int SIZE = 96;
    private static final int GET_BY_KEY = 97;
    private static final int GET_BY_INDEX = 98;
    private static final int GET_BY_RANK = 100;
    private static final int GET_BY_VALUE = 102;
    private static final int GET_BY_KEY_INTERVAL = 103;
    private static final int GET_BY_INDEX_RANGE = 104;
    private static final int GET_BY_VALUE_INTERVAL = 105;
    private static final int GET_BY_RANK_RANGE = 106;
    private static final int GET_BY_KEY_LIST = 107;
    private static final int GET_BY_VALUE_LIST = 108;
    private static final int GET_BY_KEY_REL_INDEX_RANGE = 109;
    private static final int GET_BY_VALUE_REL_RANK_RANGE = 110;

    public static Operation create(String binName, MapOrder order, CTX ... ctx) {
        if (ctx == null || ctx.length == 0) {
            return MapOperation.setMapPolicy(new MapPolicy(order, 0), binName, new CTX[0]);
        }
        Packer packer = new Packer();
        CDT.init(packer, ctx, 64, 1, order.flag);
        packer.packInt(order.attributes);
        return new Operation(Operation.Type.MAP_MODIFY, binName, Value.get(packer.toByteArray()));
    }

    public static Operation setMapPolicy(MapPolicy policy, String binName, CTX ... ctx) {
        return CDT.createOperation(64, Operation.Type.MAP_MODIFY, binName, ctx, policy.attributes);
    }

    public static Operation put(MapPolicy policy, String binName, Value key, Value value, CTX ... ctx) {
        Packer packer = new Packer();
        if (policy.flags != 0) {
            CDT.init(packer, ctx, 67, 4);
            key.pack(packer);
            value.pack(packer);
            packer.packInt(policy.attributes);
            packer.packInt(policy.flags);
        } else if (policy.itemCommand == 69) {
            CDT.init(packer, ctx, policy.itemCommand, 2);
            key.pack(packer);
            value.pack(packer);
        } else {
            CDT.init(packer, ctx, policy.itemCommand, 3);
            key.pack(packer);
            value.pack(packer);
            packer.packInt(policy.attributes);
        }
        return new Operation(Operation.Type.MAP_MODIFY, binName, Value.get(packer.toByteArray()));
    }

    public static Operation putItems(MapPolicy policy, String binName, Map<Value, Value> map, CTX ... ctx) {
        Packer packer = new Packer();
        if (policy.flags != 0) {
            CDT.init(packer, ctx, 68, 3);
            packer.packValueMap(map);
            packer.packInt(policy.attributes);
            packer.packInt(policy.flags);
        } else if (policy.itemsCommand == 70) {
            CDT.init(packer, ctx, policy.itemsCommand, 1);
            packer.packValueMap(map);
        } else {
            CDT.init(packer, ctx, policy.itemsCommand, 2);
            packer.packValueMap(map);
            packer.packInt(policy.attributes);
        }
        return new Operation(Operation.Type.MAP_MODIFY, binName, Value.get(packer.toByteArray()));
    }

    public static Operation increment(MapPolicy policy, String binName, Value key, Value incr, CTX ... ctx) {
        return CDT.createOperation(73, Operation.Type.MAP_MODIFY, binName, ctx, key, incr, policy.attributes);
    }

    public static Operation decrement(MapPolicy policy, String binName, Value key, Value decr, CTX ... ctx) {
        return CDT.createOperation(74, Operation.Type.MAP_MODIFY, binName, ctx, key, decr, policy.attributes);
    }

    public static Operation clear(String binName, CTX ... ctx) {
        return CDT.createOperation(75, Operation.Type.MAP_MODIFY, binName, ctx);
    }

    public static Operation removeByKey(String binName, Value key, int returnType, CTX ... ctx) {
        return CDT.createOperation(76, Operation.Type.MAP_MODIFY, binName, ctx, returnType, key);
    }

    public static Operation removeByKeyList(String binName, List<Value> keys, int returnType, CTX ... ctx) {
        return CDT.createOperation(81, Operation.Type.MAP_MODIFY, binName, ctx, returnType, keys);
    }

    public static Operation removeByKeyRange(String binName, Value keyBegin, Value keyEnd, int returnType, CTX ... ctx) {
        return CDT.createRangeOperation(84, Operation.Type.MAP_MODIFY, binName, ctx, keyBegin, keyEnd, returnType);
    }

    public static Operation removeByKeyRelativeIndexRange(String binName, Value key, int index2, int returnType, CTX ... ctx) {
        return CDT.createOperation(88, Operation.Type.MAP_MODIFY, binName, ctx, returnType, key, index2);
    }

    public static Operation removeByKeyRelativeIndexRange(String binName, Value key, int index2, int count, int returnType, CTX ... ctx) {
        return CDT.createOperation(88, Operation.Type.MAP_MODIFY, binName, ctx, returnType, key, index2, count);
    }

    public static Operation removeByValue(String binName, Value value, int returnType, CTX ... ctx) {
        return CDT.createOperation(82, Operation.Type.MAP_MODIFY, binName, ctx, returnType, value);
    }

    public static Operation removeByValueList(String binName, List<Value> values, int returnType, CTX ... ctx) {
        return CDT.createOperation(83, Operation.Type.MAP_MODIFY, binName, ctx, returnType, values);
    }

    public static Operation removeByValueRange(String binName, Value valueBegin, Value valueEnd, int returnType, CTX ... ctx) {
        return CDT.createRangeOperation(86, Operation.Type.MAP_MODIFY, binName, ctx, valueBegin, valueEnd, returnType);
    }

    public static Operation removeByValueRelativeRankRange(String binName, Value value, int rank, int returnType, CTX ... ctx) {
        return CDT.createOperation(89, Operation.Type.MAP_MODIFY, binName, ctx, returnType, value, rank);
    }

    public static Operation removeByValueRelativeRankRange(String binName, Value value, int rank, int count, int returnType, CTX ... ctx) {
        return CDT.createOperation(89, Operation.Type.MAP_MODIFY, binName, ctx, returnType, value, rank, count);
    }

    public static Operation removeByIndex(String binName, int index2, int returnType, CTX ... ctx) {
        return CDT.createOperation(77, Operation.Type.MAP_MODIFY, binName, ctx, returnType, index2);
    }

    public static Operation removeByIndexRange(String binName, int index2, int returnType, CTX ... ctx) {
        return CDT.createOperation(85, Operation.Type.MAP_MODIFY, binName, ctx, returnType, index2);
    }

    public static Operation removeByIndexRange(String binName, int index2, int count, int returnType, CTX ... ctx) {
        return CDT.createOperation(85, Operation.Type.MAP_MODIFY, binName, ctx, returnType, index2, count);
    }

    public static Operation removeByRank(String binName, int rank, int returnType, CTX ... ctx) {
        return CDT.createOperation(79, Operation.Type.MAP_MODIFY, binName, ctx, returnType, rank);
    }

    public static Operation removeByRankRange(String binName, int rank, int returnType, CTX ... ctx) {
        return CDT.createOperation(87, Operation.Type.MAP_MODIFY, binName, ctx, returnType, rank);
    }

    public static Operation removeByRankRange(String binName, int rank, int count, int returnType, CTX ... ctx) {
        return CDT.createOperation(87, Operation.Type.MAP_MODIFY, binName, ctx, returnType, rank, count);
    }

    public static Operation size(String binName, CTX ... ctx) {
        return CDT.createOperation(96, Operation.Type.MAP_READ, binName, ctx);
    }

    public static Operation getByKey(String binName, Value key, int returnType, CTX ... ctx) {
        return CDT.createOperation(97, Operation.Type.MAP_READ, binName, ctx, returnType, key);
    }

    public static Operation getByKeyRange(String binName, Value keyBegin, Value keyEnd, int returnType, CTX ... ctx) {
        return CDT.createRangeOperation(103, Operation.Type.MAP_READ, binName, ctx, keyBegin, keyEnd, returnType);
    }

    public static Operation getByKeyList(String binName, List<Value> keys, int returnType, CTX ... ctx) {
        return CDT.createOperation(107, Operation.Type.MAP_READ, binName, ctx, returnType, keys);
    }

    public static Operation getByKeyRelativeIndexRange(String binName, Value key, int index2, int returnType, CTX ... ctx) {
        return CDT.createOperation(109, Operation.Type.MAP_READ, binName, ctx, returnType, key, index2);
    }

    public static Operation getByKeyRelativeIndexRange(String binName, Value key, int index2, int count, int returnType, CTX ... ctx) {
        return CDT.createOperation(109, Operation.Type.MAP_READ, binName, ctx, returnType, key, index2, count);
    }

    public static Operation getByValue(String binName, Value value, int returnType, CTX ... ctx) {
        return CDT.createOperation(102, Operation.Type.MAP_READ, binName, ctx, returnType, value);
    }

    public static Operation getByValueRange(String binName, Value valueBegin, Value valueEnd, int returnType, CTX ... ctx) {
        return CDT.createRangeOperation(105, Operation.Type.MAP_READ, binName, ctx, valueBegin, valueEnd, returnType);
    }

    public static Operation getByValueList(String binName, List<Value> values, int returnType, CTX ... ctx) {
        return CDT.createOperation(108, Operation.Type.MAP_READ, binName, ctx, returnType, values);
    }

    public static Operation getByValueRelativeRankRange(String binName, Value value, int rank, int returnType, CTX ... ctx) {
        return CDT.createOperation(110, Operation.Type.MAP_READ, binName, ctx, returnType, value, rank);
    }

    public static Operation getByValueRelativeRankRange(String binName, Value value, int rank, int count, int returnType, CTX ... ctx) {
        return CDT.createOperation(110, Operation.Type.MAP_READ, binName, ctx, returnType, value, rank, count);
    }

    public static Operation getByIndex(String binName, int index2, int returnType, CTX ... ctx) {
        return CDT.createOperation(98, Operation.Type.MAP_READ, binName, ctx, returnType, index2);
    }

    public static Operation getByIndexRange(String binName, int index2, int returnType, CTX ... ctx) {
        return CDT.createOperation(104, Operation.Type.MAP_READ, binName, ctx, returnType, index2);
    }

    public static Operation getByIndexRange(String binName, int index2, int count, int returnType, CTX ... ctx) {
        return CDT.createOperation(104, Operation.Type.MAP_READ, binName, ctx, returnType, index2, count);
    }

    public static Operation getByRank(String binName, int rank, int returnType, CTX ... ctx) {
        return CDT.createOperation(100, Operation.Type.MAP_READ, binName, ctx, returnType, rank);
    }

    public static Operation getByRankRange(String binName, int rank, int returnType, CTX ... ctx) {
        return CDT.createOperation(106, Operation.Type.MAP_READ, binName, ctx, returnType, rank);
    }

    public static Operation getByRankRange(String binName, int rank, int count, int returnType, CTX ... ctx) {
        return CDT.createOperation(106, Operation.Type.MAP_READ, binName, ctx, returnType, rank, count);
    }
}

