/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.ScanCallback;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.Executor;
import com.aerospike.client.command.ScanCommand;
import com.aerospike.client.command.ScanPartitionCommand;
import com.aerospike.client.policy.ScanPolicy;
import com.aerospike.client.query.PartitionTracker;
import com.aerospike.client.query.QueryValidate;
import com.aerospike.client.util.RandomShift;
import com.aerospike.client.util.Util;
import java.util.List;

public final class ScanExecutor {
    public static void scanPartitions(Cluster cluster, ScanPolicy policy, String namespace, String setName, String[] binNames, ScanCallback callback, PartitionTracker tracker) {
        policy.validate();
        while (true) {
            long taskId = RandomShift.instance().nextLong();
            try {
                List<PartitionTracker.NodePartitions> list = tracker.assignPartitionsToNodes(cluster, namespace);
                if (policy.concurrentNodes && list.size() > 1) {
                    Executor executor = new Executor(cluster, list.size());
                    for (PartitionTracker.NodePartitions nodePartitions : list) {
                        ScanPartitionCommand command = new ScanPartitionCommand(cluster, policy, namespace, setName, binNames, callback, taskId, tracker, nodePartitions);
                        executor.addCommand(command);
                    }
                    executor.execute(policy.maxConcurrentNodes);
                } else {
                    for (PartitionTracker.NodePartitions nodePartitions : list) {
                        ScanPartitionCommand command = new ScanPartitionCommand(cluster, policy, namespace, setName, binNames, callback, taskId, tracker, nodePartitions);
                        command.execute();
                    }
                }
            }
            catch (AerospikeException ae) {
                ae.setIteration(tracker.iteration);
                throw ae;
            }
            if (tracker.isComplete(policy)) {
                return;
            }
            if (policy.sleepBetweenRetries <= 0) continue;
            Util.sleep(policy.sleepBetweenRetries);
        }
    }

    public static void scanNodes(Cluster cluster, ScanPolicy policy, String namespace, String setName, String[] binNames, ScanCallback callback, Node[] nodes) {
        policy.validate();
        long taskId = RandomShift.instance().nextLong();
        long clusterKey = policy.failOnClusterChange ? QueryValidate.validateBegin(nodes[0], namespace) : 0L;
        boolean first = true;
        if (policy.concurrentNodes && nodes.length > 1) {
            Executor executor = new Executor(cluster, nodes.length);
            for (Node node : nodes) {
                ScanCommand command = new ScanCommand(cluster, node, policy, namespace, setName, binNames, callback, taskId, clusterKey, first);
                executor.addCommand(command);
                first = false;
            }
            executor.execute(policy.maxConcurrentNodes);
        } else {
            for (Node node : nodes) {
                ScanCommand command = new ScanCommand(cluster, node, policy, namespace, setName, binNames, callback, taskId, clusterKey, first);
                command.execute();
                first = false;
            }
        }
    }
}

