/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Record;
import com.aerospike.client.async.AsyncCommand;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.policy.Policy;

public abstract class AsyncMultiCommand
extends AsyncCommand {
    final Node node;
    int info3;
    int resultCode;
    int generation;
    int expiration;
    int batchIndex;
    int fieldCount;
    int opCount;
    protected final boolean isOperation;

    public AsyncMultiCommand(Node node, Policy policy, boolean isOperation) {
        super(policy, false);
        this.node = node;
        this.isOperation = isOperation;
    }

    public AsyncMultiCommand(Node node, Policy policy, int socketTimeout, int totalTimeout) {
        super(policy, socketTimeout, totalTimeout);
        this.node = node;
        this.isOperation = false;
    }

    @Override
    protected Node getNode(Cluster cluster) {
        return this.node;
    }

    @Override
    protected boolean prepareRetry(boolean timeout) {
        return true;
    }

    @Override
    final boolean parseResult() {
        while (this.dataOffset < this.receiveSize) {
            this.dataOffset += 3;
            this.info3 = this.dataBuffer[this.dataOffset] & 0xFF;
            this.dataOffset += 2;
            this.resultCode = this.dataBuffer[this.dataOffset] & 0xFF;
            if ((this.info3 & 1) != 0) {
                if (this.resultCode != 0) {
                    throw new AerospikeException(this.resultCode);
                }
                return true;
            }
            ++this.dataOffset;
            this.generation = Buffer.bytesToInt(this.dataBuffer, this.dataOffset);
            this.dataOffset += 4;
            this.expiration = Buffer.bytesToInt(this.dataBuffer, this.dataOffset);
            this.dataOffset += 4;
            this.batchIndex = Buffer.bytesToInt(this.dataBuffer, this.dataOffset);
            this.dataOffset += 4;
            this.fieldCount = Buffer.bytesToShort(this.dataBuffer, this.dataOffset);
            this.dataOffset += 2;
            this.opCount = Buffer.bytesToShort(this.dataBuffer, this.dataOffset);
            this.dataOffset += 2;
            this.parseRow();
        }
        return false;
    }

    protected abstract void parseRow();

    protected final Record parseRecord() {
        if (this.opCount <= 0) {
            return new Record(null, this.generation, this.expiration);
        }
        return this.parseRecord(this.opCount, this.generation, this.expiration, this.isOperation);
    }
}

