/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.query;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.cluster.Partition;
import com.aerospike.client.cluster.Partitions;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.QueryPolicy;
import com.aerospike.client.policy.Replica;
import com.aerospike.client.policy.ScanPolicy;
import com.aerospike.client.query.PartitionFilter;
import com.aerospike.client.query.PartitionStatus;
import com.aerospike.client.query.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public final class PartitionTracker {
    private final PartitionStatus[] partitions;
    private final int partitionsCapacity;
    private final int partitionBegin;
    private final int nodeCapacity;
    private final Node nodeFilter;
    private final PartitionFilter partitionFilter;
    private final Replica replica;
    private List<NodePartitions> nodePartitionsList;
    private List<AerospikeException> exceptions;
    private AtomicLong recordCount;
    private long maxRecords;
    private int sleepBetweenRetries;
    public int socketTimeout;
    public int totalTimeout;
    public int iteration = 1;
    private long deadline;

    public PartitionTracker(ScanPolicy policy, Node[] nodes) {
        this((Policy)policy, nodes);
        this.setMaxRecords(policy.maxRecords);
    }

    public PartitionTracker(QueryPolicy policy, Statement stmt, Node[] nodes) {
        this((Policy)policy, nodes);
        this.setMaxRecords(policy, stmt);
    }

    private PartitionTracker(Policy policy, Node[] nodes) {
        this.partitionBegin = 0;
        this.nodeCapacity = nodes.length;
        this.nodeFilter = null;
        this.partitionFilter = null;
        this.replica = policy.replica;
        int ppn = 4096 / nodes.length;
        ppn += ppn >>> 2;
        this.partitionsCapacity = ppn;
        this.partitions = this.initPartitions(4096, null);
        this.init(policy);
    }

    public PartitionTracker(ScanPolicy policy, Node nodeFilter) {
        this((Policy)policy, nodeFilter);
        this.setMaxRecords(policy.maxRecords);
    }

    public PartitionTracker(QueryPolicy policy, Statement stmt, Node nodeFilter) {
        this((Policy)policy, nodeFilter);
        this.setMaxRecords(policy, stmt);
    }

    private PartitionTracker(Policy policy, Node nodeFilter) {
        this.partitionBegin = 0;
        this.nodeCapacity = 1;
        this.nodeFilter = nodeFilter;
        this.partitionFilter = null;
        this.partitionsCapacity = 4096;
        this.replica = policy.replica;
        this.partitions = this.initPartitions(4096, null);
        this.init(policy);
    }

    public PartitionTracker(ScanPolicy policy, Node[] nodes, PartitionFilter filter) {
        this(policy, nodes, filter, policy.maxRecords);
    }

    public PartitionTracker(QueryPolicy policy, Statement stmt, Node[] nodes, PartitionFilter filter) {
        this((Policy)policy, nodes, filter, stmt.maxRecords > 0L ? stmt.maxRecords : policy.maxRecords);
    }

    private PartitionTracker(Policy policy, Node[] nodes, PartitionFilter filter, long maxRecords) {
        if (filter.begin < 0 || filter.begin >= 4096) {
            throw new AerospikeException(4, "Invalid partition begin " + filter.begin + ". Valid range: 0-" + 4095);
        }
        if (filter.count <= 0) {
            throw new AerospikeException(4, "Invalid partition count " + filter.count);
        }
        if (filter.begin + filter.count > 4096) {
            throw new AerospikeException(4, "Invalid partition range (" + filter.begin + ',' + filter.count + ')');
        }
        this.setMaxRecords(maxRecords);
        this.partitionBegin = filter.begin;
        this.nodeCapacity = nodes.length;
        this.nodeFilter = null;
        this.partitionsCapacity = filter.count;
        this.replica = policy.replica;
        if (filter.partitions == null) {
            filter.partitions = this.initPartitions(filter.count, filter.digest);
            filter.retry = true;
        } else {
            if (maxRecords == 0L) {
                filter.retry = true;
            }
            for (PartitionStatus part : filter.partitions) {
                part.sequence = 0;
                part.node = null;
            }
        }
        this.partitions = filter.partitions;
        this.partitionFilter = filter;
        this.init(policy);
    }

    private void setMaxRecords(QueryPolicy policy, Statement stmt) {
        this.setMaxRecords(stmt.maxRecords > 0L ? stmt.maxRecords : policy.maxRecords);
    }

    private void setMaxRecords(long maxRecords) {
        if (maxRecords < 0L) {
            throw new AerospikeException(4, "Invalid maxRecords: " + maxRecords);
        }
        this.maxRecords = maxRecords;
    }

    private PartitionStatus[] initPartitions(int partitionCount, byte[] digest) {
        PartitionStatus[] partsAll = new PartitionStatus[partitionCount];
        for (int i = 0; i < partitionCount; ++i) {
            partsAll[i] = new PartitionStatus(this.partitionBegin + i);
        }
        if (digest != null) {
            partsAll[0].digest = digest;
        }
        return partsAll;
    }

    private void init(Policy policy) {
        this.sleepBetweenRetries = policy.sleepBetweenRetries;
        this.socketTimeout = policy.socketTimeout;
        this.totalTimeout = policy.totalTimeout;
        if (this.totalTimeout > 0) {
            this.deadline = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(this.totalTimeout);
            if (this.socketTimeout == 0 || this.socketTimeout > this.totalTimeout) {
                this.socketTimeout = this.totalTimeout;
            }
        }
        if (this.replica == Replica.RANDOM) {
            throw new AerospikeException(4, "Invalid replica: " + this.replica.toString());
        }
    }

    public void setSleepBetweenRetries(int sleepBetweenRetries) {
        this.sleepBetweenRetries = sleepBetweenRetries;
    }

    public List<NodePartitions> assignPartitionsToNodes(Cluster cluster, String namespace) {
        NodePartitions np;
        ArrayList<NodePartitions> list = new ArrayList<NodePartitions>(this.nodeCapacity);
        HashMap<String, Partitions> map = cluster.partitionMap;
        Partitions parts = map.get(namespace);
        if (parts == null) {
            throw new AerospikeException.InvalidNamespace(namespace, map.size());
        }
        Partition p = new Partition(namespace, this.replica);
        boolean retry = (this.partitionFilter == null || this.partitionFilter.retry) && this.iteration == 1;
        for (PartitionStatus part : this.partitions) {
            if (!retry && !part.retry) continue;
            Node node = p.getNodeQuery(cluster, parts, part);
            if (this.nodeFilter != null && !this.nodeFilter.getName().equals(node.getName())) continue;
            np = this.findNode(list, node);
            if (np == null) {
                np = new NodePartitions(node, this.partitionsCapacity);
                list.add(np);
            }
            np.addPartition(part);
        }
        int nodeSize = list.size();
        if (nodeSize <= 0) {
            throw new AerospikeException.InvalidNode("No nodes were assigned");
        }
        if (this.partitionFilter != null) {
            this.partitionFilter.retry = true;
        }
        this.recordCount = null;
        if (this.maxRecords > 0L) {
            if (this.maxRecords >= (long)nodeSize) {
                long max = this.maxRecords / (long)nodeSize;
                int rem = (int)(this.maxRecords - max * (long)nodeSize);
                for (int i = 0; i < nodeSize; ++i) {
                    np = (NodePartitions)list.get(i);
                    np.recordMax = i < rem ? max + 1L : max;
                }
            } else {
                for (int i = 0; i < nodeSize; ++i) {
                    NodePartitions np2 = (NodePartitions)list.get(i);
                    np2.recordMax = 1L;
                }
                this.recordCount = new AtomicLong();
            }
        }
        this.nodePartitionsList = list;
        return list;
    }

    private NodePartitions findNode(List<NodePartitions> list, Node node) {
        for (NodePartitions nodePartition : list) {
            if (nodePartition.node != node) continue;
            return nodePartition;
        }
        return null;
    }

    public void partitionUnavailable(NodePartitions nodePartitions, int partitionId) {
        PartitionStatus ps = this.partitions[partitionId - this.partitionBegin];
        ps.retry = true;
        ++ps.sequence;
        ++nodePartitions.partsUnavailable;
    }

    public void setDigest(NodePartitions nodePartitions, Key key) {
        int partitionId = Partition.getPartitionId(key.digest);
        this.partitions[partitionId - this.partitionBegin].digest = key.digest;
        ++nodePartitions.recordCount;
    }

    public void setLast(NodePartitions nodePartitions, Key key, long bval) {
        int partitionId = Partition.getPartitionId(key.digest);
        PartitionStatus ps = this.partitions[partitionId - this.partitionBegin];
        ps.digest = key.digest;
        ps.bval = bval;
        ++nodePartitions.recordCount;
    }

    public boolean allowRecord() {
        return this.recordCount == null || this.recordCount.incrementAndGet() <= this.maxRecords;
    }

    public boolean isComplete(Cluster cluster, Policy policy) {
        long recCount = 0L;
        int partsUnavailable = 0;
        for (NodePartitions nodePartitions : this.nodePartitionsList) {
            recCount += nodePartitions.recordCount;
            partsUnavailable += nodePartitions.partsUnavailable;
        }
        if (partsUnavailable == 0) {
            if (this.maxRecords == 0L) {
                if (this.partitionFilter != null) {
                    this.partitionFilter.done = true;
                }
            } else if (this.iteration > 1) {
                if (this.partitionFilter != null) {
                    this.partitionFilter.retry = true;
                    this.partitionFilter.done = false;
                }
            } else if (cluster.hasPartitionQuery) {
                boolean done = true;
                for (NodePartitions np : this.nodePartitionsList) {
                    if (np.recordCount < np.recordMax) continue;
                    this.markRetry(np);
                    done = false;
                }
                if (this.partitionFilter != null) {
                    this.partitionFilter.retry = false;
                    this.partitionFilter.done = done;
                }
            } else {
                for (NodePartitions nodePartitions : this.nodePartitionsList) {
                    if (nodePartitions.recordCount <= 0L) continue;
                    this.markRetry(nodePartitions);
                }
                if (this.partitionFilter != null) {
                    this.partitionFilter.retry = false;
                    this.partitionFilter.done = recCount == 0L;
                }
            }
            return true;
        }
        if (this.maxRecords > 0L && recCount >= this.maxRecords) {
            return true;
        }
        if (this.iteration > policy.maxRetries) {
            if (this.exceptions == null || this.exceptions.size() <= 0) {
                AerospikeException ae = new AerospikeException(-11);
                ae.setPolicy(policy);
                ae.setIteration(this.iteration);
                throw ae;
            }
            AerospikeException last = this.exceptions.get(this.exceptions.size() - 1);
            StringBuilder stringBuilder = new StringBuilder(2048);
            stringBuilder.append(last.getBaseMessage());
            stringBuilder.append(System.lineSeparator());
            stringBuilder.append("sub-exceptions:");
            stringBuilder.append(System.lineSeparator());
            for (AerospikeException ae : this.exceptions) {
                stringBuilder.append(ae.getMessage());
                stringBuilder.append(System.lineSeparator());
            }
            AerospikeException ae = new AerospikeException(last.getResultCode(), stringBuilder.toString());
            ae.setNode(last.getNode());
            ae.setPolicy(policy);
            ae.setIteration(this.iteration);
            throw ae;
        }
        if (policy.totalTimeout > 0) {
            long remaining = this.deadline - System.nanoTime() - TimeUnit.MILLISECONDS.toNanos(this.sleepBetweenRetries);
            if (remaining <= 0L) {
                throw new AerospikeException.Timeout(policy, this.iteration);
            }
            if ((remaining = TimeUnit.NANOSECONDS.toMillis(remaining)) < (long)this.totalTimeout) {
                this.totalTimeout = (int)remaining;
                if (this.socketTimeout > this.totalTimeout) {
                    this.socketTimeout = this.totalTimeout;
                }
            }
        }
        if (this.maxRecords > 0L) {
            this.maxRecords -= recCount;
        }
        ++this.iteration;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldRetry(NodePartitions nodePartitions, AerospikeException ae) {
        ae.setIteration(this.iteration);
        switch (ae.getResultCode()) {
            case -8: 
            case 9: 
            case 201: 
            case 203: {
                PartitionTracker partitionTracker = this;
                synchronized (partitionTracker) {
                    if (this.exceptions == null) {
                        this.exceptions = new ArrayList<AerospikeException>();
                    }
                    this.exceptions.add(ae);
                }
                this.markRetrySequence(nodePartitions);
                nodePartitions.partsUnavailable = nodePartitions.partsFull.size() + nodePartitions.partsPartial.size();
                return true;
            }
        }
        return false;
    }

    private void markRetrySequence(NodePartitions nodePartitions) {
        for (PartitionStatus ps : nodePartitions.partsFull) {
            ps.retry = true;
            ++ps.sequence;
        }
        for (PartitionStatus ps : nodePartitions.partsPartial) {
            ps.retry = true;
            ++ps.sequence;
        }
    }

    private void markRetry(NodePartitions nodePartitions) {
        for (PartitionStatus ps : nodePartitions.partsFull) {
            ps.retry = true;
        }
        for (PartitionStatus ps : nodePartitions.partsPartial) {
            ps.retry = true;
        }
    }

    public void partitionError() {
        if (this.partitionFilter != null) {
            this.partitionFilter.retry = true;
        }
    }

    public static final class NodePartitions {
        public final Node node;
        public final List<PartitionStatus> partsFull;
        public final List<PartitionStatus> partsPartial;
        public long recordCount;
        public long recordMax;
        public int partsUnavailable;

        public NodePartitions(Node node, int capacity) {
            this.node = node;
            this.partsFull = new ArrayList<PartitionStatus>(capacity);
            this.partsPartial = new ArrayList<PartitionStatus>(capacity);
        }

        public void addPartition(PartitionStatus part) {
            if (part.digest == null) {
                this.partsFull.add(part);
            } else {
                this.partsPartial.add(part);
            }
        }
    }
}

