/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Value;
import com.aerospike.client.async.AsyncRead;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.cluster.Partition;
import com.aerospike.client.listener.ExecuteListener;
import com.aerospike.client.metrics.LatencyType;
import com.aerospike.client.policy.WritePolicy;
import java.util.Map;

public final class AsyncExecute
extends AsyncRead {
    private final ExecuteListener executeListener;
    private final WritePolicy writePolicy;
    private final String packageName;
    private final String functionName;
    private final Value[] args;

    public AsyncExecute(Cluster cluster, ExecuteListener listener, WritePolicy writePolicy, Key key, String packageName, String functionName, Value[] args) {
        super(cluster, null, writePolicy, key, Partition.write(cluster, writePolicy, key), false);
        this.executeListener = listener;
        this.writePolicy = writePolicy;
        this.packageName = packageName;
        this.functionName = functionName;
        this.args = args;
    }

    @Override
    boolean isWrite() {
        return true;
    }

    @Override
    protected Node getNode(Cluster cluster) {
        return this.partition.getNodeWrite(cluster);
    }

    @Override
    protected LatencyType getLatencyType() {
        return LatencyType.WRITE;
    }

    @Override
    protected void writeBuffer() throws AerospikeException {
        this.setUdf(this.writePolicy, this.key, this.packageName, this.functionName, this.args);
    }

    @Override
    protected void handleNotFound(int resultCode) {
        throw new AerospikeException(resultCode);
    }

    @Override
    protected boolean prepareRetry(boolean timeout) {
        this.partition.prepareRetryWrite(timeout);
        return true;
    }

    @Override
    protected void onSuccess() {
        if (this.executeListener != null) {
            Object obj = this.parseEndResult();
            this.executeListener.onSuccess(this.key, obj);
        }
    }

    @Override
    protected void onFailure(AerospikeException e) {
        if (this.executeListener != null) {
            this.executeListener.onFailure(e);
        }
    }

    private Object parseEndResult() {
        if (this.record == null || this.record.bins == null) {
            return null;
        }
        Map<String, Object> map = this.record.bins;
        Object obj = map.get("SUCCESS");
        if (obj != null) {
            return obj;
        }
        if (map.containsKey("SUCCESS")) {
            return null;
        }
        obj = map.get("FAILURE");
        if (obj != null) {
            throw new AerospikeException(obj.toString());
        }
        throw new AerospikeException("Invalid UDF return value");
    }
}

