/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.async.AsyncMultiCommand;
import com.aerospike.client.async.AsyncMultiExecutor;
import com.aerospike.client.async.AsyncScanPartition;
import com.aerospike.client.async.EventLoop;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.listener.RecordSequenceListener;
import com.aerospike.client.policy.ScanPolicy;
import com.aerospike.client.query.PartitionTracker;
import com.aerospike.client.util.RandomShift;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class AsyncScanPartitionExecutor
extends AsyncMultiExecutor {
    private final ScanPolicy policy;
    private final RecordSequenceListener listener;
    private final String namespace;
    private final String setName;
    private final String[] binNames;
    private final PartitionTracker tracker;
    private final RandomShift random;

    public AsyncScanPartitionExecutor(EventLoop eventLoop, Cluster cluster, ScanPolicy policy, RecordSequenceListener listener, String namespace, String setName, String[] binNames, PartitionTracker tracker) throws AerospikeException {
        super(eventLoop, cluster, 0);
        this.policy = policy;
        this.listener = listener;
        this.namespace = namespace;
        this.setName = setName;
        this.binNames = binNames;
        this.tracker = tracker;
        this.random = new RandomShift();
        cluster.addTran();
        tracker.setSleepBetweenRetries(0);
        this.scanPartitions();
    }

    private void scanPartitions() {
        long taskId = this.random.nextLong();
        List<PartitionTracker.NodePartitions> nodePartitionsList = this.tracker.assignPartitionsToNodes(this.cluster, this.namespace);
        AsyncMultiCommand[] tasks = new AsyncScanPartition[nodePartitionsList.size()];
        int count = 0;
        for (PartitionTracker.NodePartitions nodePartitions : nodePartitionsList) {
            tasks[count++] = new AsyncScanPartition(this, this.policy, this.listener, this.namespace, this.setName, this.binNames, taskId, this.tracker, nodePartitions);
        }
        this.execute(tasks, this.policy.maxConcurrentNodes);
    }

    @Override
    protected void onSuccess() {
        try {
            if (this.tracker.isComplete(this.cluster, this.policy)) {
                this.listener.onSuccess();
                return;
            }
            if (this.policy.sleepBetweenRetries > 0) {
                this.eventLoop.schedule(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            AsyncScanPartitionExecutor.this.reset();
                            AsyncScanPartitionExecutor.this.scanPartitions();
                        }
                        catch (AerospikeException ae) {
                            AsyncScanPartitionExecutor.this.onFailure(ae);
                        }
                        catch (Throwable e) {
                            AsyncScanPartitionExecutor.this.onFailure(new AerospikeException(e));
                        }
                    }
                }, (long)this.policy.sleepBetweenRetries, TimeUnit.MILLISECONDS);
            } else {
                this.reset();
                this.scanPartitions();
            }
        }
        catch (AerospikeException ae) {
            this.onFailure(ae);
        }
        catch (Throwable e) {
            this.onFailure(new AerospikeException(e));
        }
    }

    @Override
    protected void onFailure(AerospikeException ae) {
        this.tracker.partitionError();
        ae.setIteration(this.tracker.iteration);
        this.listener.onFailure(ae);
    }
}

