/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.cluster.Partition;
import com.aerospike.client.command.RecordParser;
import com.aerospike.client.command.SyncCommand;
import com.aerospike.client.metrics.LatencyType;
import com.aerospike.client.policy.Policy;
import java.io.IOException;

public class ReadCommand
extends SyncCommand {
    protected final Key key;
    protected final Partition partition;
    private final String[] binNames;
    private final boolean isOperation;
    private Record record;

    public ReadCommand(Cluster cluster, Policy policy, Key key) {
        super(cluster, policy);
        this.key = key;
        this.binNames = null;
        this.partition = Partition.read(cluster, policy, key);
        this.isOperation = false;
        cluster.addTran();
    }

    public ReadCommand(Cluster cluster, Policy policy, Key key, String[] binNames) {
        super(cluster, policy);
        this.key = key;
        this.binNames = binNames;
        this.partition = Partition.read(cluster, policy, key);
        this.isOperation = false;
        cluster.addTran();
    }

    public ReadCommand(Cluster cluster, Policy policy, Key key, Partition partition, boolean isOperation) {
        super(cluster, policy);
        this.key = key;
        this.binNames = null;
        this.partition = partition;
        this.isOperation = isOperation;
        cluster.addTran();
    }

    @Override
    protected Node getNode() {
        return this.partition.getNodeRead(this.cluster);
    }

    @Override
    protected LatencyType getLatencyType() {
        return LatencyType.READ;
    }

    @Override
    protected void writeBuffer() {
        this.setRead(this.policy, this.key, this.binNames);
    }

    @Override
    protected void parseResult(Connection conn) throws IOException {
        RecordParser rp = new RecordParser(conn, this.dataBuffer);
        if (rp.resultCode == 0) {
            this.record = rp.parseRecord(this.isOperation);
            return;
        }
        if (rp.resultCode == 2) {
            this.handleNotFound(rp.resultCode);
            return;
        }
        if (rp.resultCode == 27) {
            if (this.policy.failOnFilteredOut) {
                throw new AerospikeException(rp.resultCode);
            }
            return;
        }
        if (rp.resultCode == 100) {
            this.record = rp.parseRecord(this.isOperation);
            this.handleUdfError(rp.resultCode);
            return;
        }
        throw new AerospikeException(rp.resultCode);
    }

    @Override
    protected boolean prepareRetry(boolean timeout) {
        this.partition.prepareRetryRead(timeout);
        return true;
    }

    protected void handleNotFound(int resultCode) {
    }

    private void handleUdfError(int resultCode) {
        String message;
        int code;
        String ret = (String)this.record.bins.get("FAILURE");
        if (ret == null) {
            throw new AerospikeException(resultCode);
        }
        try {
            String[] list = ret.split(":");
            code = Integer.parseInt(list[2].trim());
            message = list[0] + ":" + list[1] + " " + list[3];
        }
        catch (Throwable e) {
            throw new AerospikeException(resultCode, ret);
        }
        throw new AerospikeException(code, message);
    }

    public Record getRecord() {
        return this.record;
    }
}

