/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.ScanCallback;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.command.Executor;
import com.aerospike.client.command.ScanPartitionCommand;
import com.aerospike.client.policy.ScanPolicy;
import com.aerospike.client.query.PartitionTracker;
import com.aerospike.client.util.RandomShift;
import com.aerospike.client.util.Util;
import java.util.List;

public final class ScanExecutor {
    public static void scanPartitions(Cluster cluster, ScanPolicy policy, String namespace, String setName, String[] binNames, ScanCallback callback, PartitionTracker tracker) {
        cluster.addTran();
        RandomShift random = new RandomShift();
        while (true) {
            long taskId = random.nextLong();
            try {
                List<PartitionTracker.NodePartitions> list = tracker.assignPartitionsToNodes(cluster, namespace);
                if (policy.concurrentNodes && list.size() > 1) {
                    Executor executor = new Executor(cluster, list.size());
                    for (PartitionTracker.NodePartitions nodePartitions : list) {
                        ScanPartitionCommand command = new ScanPartitionCommand(cluster, policy, namespace, setName, binNames, callback, taskId, tracker, nodePartitions);
                        executor.addCommand(command);
                    }
                    executor.execute(policy.maxConcurrentNodes);
                } else {
                    for (PartitionTracker.NodePartitions nodePartitions : list) {
                        ScanPartitionCommand command = new ScanPartitionCommand(cluster, policy, namespace, setName, binNames, callback, taskId, tracker, nodePartitions);
                        command.execute();
                    }
                }
            }
            catch (AerospikeException ae) {
                tracker.partitionError();
                ae.setIteration(tracker.iteration);
                throw ae;
            }
            if (tracker.isComplete(cluster, policy)) {
                return;
            }
            if (policy.sleepBetweenRetries <= 0) continue;
            Util.sleep(policy.sleepBetweenRetries);
        }
    }
}

