/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.cluster.ConnectionRecover;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.Command;
import com.aerospike.client.metrics.LatencyType;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.util.Util;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public abstract class SyncCommand
extends Command {
    protected final Cluster cluster;
    protected final Policy policy;
    ArrayList<AerospikeException> subExceptions;
    int iteration = 1;
    int commandSentCounter;
    long deadline;

    public SyncCommand(Cluster cluster, Policy policy) {
        super(policy.socketTimeout, policy.totalTimeout, policy.maxRetries);
        this.cluster = cluster;
        this.policy = policy;
    }

    public SyncCommand(Cluster cluster, Policy policy, int socketTimeout, int totalTimeout) {
        super(socketTimeout, totalTimeout, 0);
        this.cluster = cluster;
        this.policy = policy;
    }

    public void execute() {
        if (this.totalTimeout > 0) {
            this.deadline = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(this.totalTimeout);
        }
        this.executeCommand();
    }

    public final void executeCommand() {
        Node node;
        AerospikeException exception = null;
        long begin = 0L;
        LatencyType latencyType = this.cluster.metricsEnabled ? this.getLatencyType() : LatencyType.NONE;
        while (true) {
            boolean isClientTimeout;
            block29: {
                try {
                    node = this.getNode();
                }
                catch (AerospikeException ae) {
                    if (this.cluster.isActive()) {
                        this.setExceptionData(null, ae, this.subExceptions);
                        throw ae;
                    }
                    throw new AerospikeException("Cluster has been closed");
                }
                try {
                    node.validateErrorCount();
                    if (latencyType != LatencyType.NONE) {
                        begin = System.nanoTime();
                    }
                    Connection conn = node.getConnection(this, this.policy.connectTimeout, this.socketTimeout, this.policy.timeoutDelay);
                    try {
                        this.writeBuffer();
                        conn.write(this.dataBuffer, this.dataOffset);
                        ++this.commandSentCounter;
                        this.parseResult(conn);
                        node.putConnection(conn);
                        if (latencyType != LatencyType.NONE) {
                            long elapsed = System.nanoTime() - begin;
                            node.addLatency(latencyType, elapsed);
                        }
                        return;
                    }
                    catch (AerospikeException ae) {
                        if (ae.keepConnection()) {
                            node.putConnection(conn);
                        } else {
                            node.closeConnection(conn);
                        }
                        if (ae.getResultCode() == 9) {
                            exception = new AerospikeException.Timeout(this.policy, false);
                            isClientTimeout = false;
                            node.incrErrorRate();
                            node.addTimeout();
                            break block29;
                        }
                        if (ae.getResultCode() == 18) {
                            exception = ae;
                            isClientTimeout = false;
                            node.incrErrorRate();
                            node.addError();
                            break block29;
                        }
                        node.addError();
                        this.setExceptionData(node, ae, this.subExceptions);
                        throw ae;
                    }
                    catch (Connection.ReadTimeout crt) {
                        if (this.policy.timeoutDelay > 0) {
                            this.cluster.recoverConnection(new ConnectionRecover(conn, node, this.policy.timeoutDelay, crt, this.isSingle()));
                        } else {
                            node.closeConnection(conn);
                        }
                        exception = new AerospikeException.Timeout(this.policy, true);
                        isClientTimeout = true;
                        node.addTimeout();
                    }
                    catch (SocketTimeoutException ste) {
                        node.closeConnection(conn);
                        exception = new AerospikeException.Timeout(this.policy, true);
                        isClientTimeout = true;
                        node.addTimeout();
                    }
                    catch (IOException ioe) {
                        node.closeConnection(conn);
                        exception = new AerospikeException.Connection(ioe);
                        isClientTimeout = false;
                        node.addError();
                    }
                    catch (Throwable t) {
                        node.closeConnection(conn);
                        node.addError();
                        AerospikeException ae = new AerospikeException(t);
                        this.setExceptionData(node, ae, this.subExceptions);
                        throw ae;
                    }
                }
                catch (Connection.ReadTimeout crt) {
                    exception = new AerospikeException.Timeout(this.policy, true);
                    isClientTimeout = true;
                    node.addTimeout();
                }
                catch (AerospikeException.Connection ce) {
                    exception = ce;
                    isClientTimeout = false;
                    node.addError();
                }
                catch (AerospikeException.Backoff be) {
                    exception = be;
                    isClientTimeout = false;
                    node.addError();
                }
                catch (AerospikeException ae) {
                    node.addError();
                    this.setExceptionData(node, ae, this.subExceptions);
                    throw ae;
                }
                catch (Throwable t) {
                    node.addError();
                    AerospikeException ae = new AerospikeException(t);
                    this.setExceptionData(node, ae, this.subExceptions);
                    throw ae;
                }
            }
            if (this.iteration > this.maxRetries) break;
            if (this.totalTimeout > 0) {
                long remaining = this.deadline - System.nanoTime() - TimeUnit.MILLISECONDS.toNanos(this.policy.sleepBetweenRetries);
                if (remaining <= 0L) break;
                if ((remaining = TimeUnit.NANOSECONDS.toMillis(remaining)) < (long)this.totalTimeout) {
                    this.totalTimeout = (int)remaining;
                    if (this.socketTimeout > this.totalTimeout) {
                        this.socketTimeout = this.totalTimeout;
                    }
                }
            }
            if (!isClientTimeout && this.policy.sleepBetweenRetries > 0) {
                Util.sleep(this.policy.sleepBetweenRetries);
            }
            this.setExceptionData(node, exception, null);
            this.addSubException(exception);
            ++this.iteration;
            if (!this.prepareRetry(isClientTimeout || exception.getResultCode() != -8) && this.retryBatch(this.cluster, this.socketTimeout, this.totalTimeout, this.deadline, this.iteration, this.commandSentCounter)) {
                return;
            }
            this.cluster.addRetry();
        }
        this.setExceptionData(node, exception, this.subExceptions);
        throw exception;
    }

    protected void addSubException(AerospikeException exception) {
        if (this.subExceptions == null) {
            this.subExceptions = new ArrayList(this.policy.maxRetries);
        }
        this.subExceptions.add(exception);
    }

    private void setExceptionData(Node node, AerospikeException exception, List<AerospikeException> subExceptions) {
        exception.setNode(node);
        exception.setPolicy(this.policy);
        exception.setIteration(this.iteration);
        exception.setInDoubt(this.isWrite(), this.commandSentCounter);
        exception.setSubExceptions(subExceptions);
    }

    public void resetDeadline(long startTime) {
        long elapsed = System.nanoTime() - startTime;
        this.deadline += elapsed;
    }

    @Override
    protected void sizeBuffer() {
        this.dataBuffer = new byte[this.dataOffset];
    }

    protected boolean retryBatch(Cluster cluster, int socketTimeout, int totalTimeout, long deadline, int iteration, int commandSentCounter) {
        return false;
    }

    protected boolean isSingle() {
        return true;
    }

    protected boolean isWrite() {
        return false;
    }

    protected abstract Node getNode();

    protected abstract LatencyType getLatencyType();

    protected abstract void writeBuffer();

    protected abstract void parseResult(Connection var1) throws AerospikeException, IOException;

    protected abstract boolean prepareRetry(boolean var1);
}

