/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client;

import com.aerospike.client.BatchRecord;
import com.aerospike.client.CommitError;
import com.aerospike.client.Record;
import com.aerospike.client.ResultCode;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.cluster.Partition;
import com.aerospike.client.policy.Policy;
import java.util.List;

public class AerospikeException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    protected transient Node node;
    protected transient Policy policy;
    protected List<AerospikeException> subExceptions;
    protected int resultCode = -1;
    protected int iteration = -1;
    protected boolean inDoubt;

    public AerospikeException(int resultCode, String message) {
        super(message);
        this.resultCode = resultCode;
    }

    public AerospikeException(int resultCode, Throwable e) {
        super(e);
        this.resultCode = resultCode;
    }

    public AerospikeException(int resultCode) {
        this.resultCode = resultCode;
    }

    public AerospikeException(int resultCode, boolean inDoubt) {
        this.resultCode = resultCode;
        this.inDoubt = inDoubt;
    }

    public AerospikeException(int resultCode, String message, Throwable e) {
        super(message, e);
        this.resultCode = resultCode;
    }

    public AerospikeException(String message, Throwable e) {
        super(message, e);
    }

    public AerospikeException(String message) {
        super(message);
    }

    public AerospikeException(Throwable e) {
        super(e);
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder(512);
        sb.append("Error ");
        sb.append(this.resultCode);
        if (this.iteration >= 0) {
            sb.append(',');
            sb.append(this.iteration);
        }
        if (this.policy != null) {
            sb.append(',');
            sb.append(this.policy.connectTimeout);
            sb.append(',');
            sb.append(this.policy.socketTimeout);
            sb.append(',');
            sb.append(this.policy.totalTimeout);
            sb.append(',');
            sb.append(this.policy.maxRetries);
        }
        if (this.inDoubt) {
            sb.append(",inDoubt");
        }
        if (this.node != null) {
            sb.append(',');
            sb.append(this.node.toString());
        }
        sb.append(": ");
        sb.append(this.getBaseMessage());
        if (this.subExceptions != null) {
            sb.append(System.lineSeparator());
            sb.append("sub-exceptions:");
            for (AerospikeException ae : this.subExceptions) {
                sb.append(System.lineSeparator());
                sb.append(ae.getMessage());
            }
        }
        return sb.toString();
    }

    public String getBaseMessage() {
        String message = super.getMessage();
        return message != null ? message : ResultCode.getResultString(this.resultCode);
    }

    public final boolean keepConnection() {
        return ResultCode.keepConnection(this.resultCode);
    }

    public final Node getNode() {
        return this.node;
    }

    public final void setNode(Node node) {
        this.node = node;
    }

    public final Policy getPolicy() {
        return this.policy;
    }

    public final void setPolicy(Policy policy) {
        this.policy = policy;
    }

    public final List<AerospikeException> getSubExceptions() {
        return this.subExceptions;
    }

    public final void setSubExceptions(List<AerospikeException> subExceptions) {
        this.subExceptions = subExceptions;
    }

    public final int getResultCode() {
        return this.resultCode;
    }

    public final int getIteration() {
        return this.iteration;
    }

    public final void setIteration(int iteration) {
        this.iteration = iteration;
    }

    public final boolean getInDoubt() {
        return this.inDoubt;
    }

    public final void setInDoubt(boolean isWrite, int commandSentCounter) {
        if (isWrite && (commandSentCounter > 1 || commandSentCounter == 1 && (this.resultCode == 9 || this.resultCode <= 0))) {
            this.inDoubt = true;
        }
    }

    public void setInDoubt(boolean inDoubt) {
        this.inDoubt = inDoubt;
    }

    private static void recordsToString(StringBuilder sb, String title, BatchRecord[] records) {
        if (records == null) {
            return;
        }
        int count = 0;
        for (BatchRecord br : records) {
            if (br.resultCode == 0 || br.resultCode == -15) continue;
            if (count >= 3) {
                sb.append(System.lineSeparator());
                sb.append("...");
                break;
            }
            if (count == 0) {
                sb.append(System.lineSeparator());
                sb.append(title);
            }
            sb.append(System.lineSeparator());
            sb.append(br.key);
            sb.append(',');
            sb.append(br.resultCode);
            sb.append(',');
            sb.append(br.inDoubt);
            ++count;
        }
    }

    public static final class Commit
    extends AerospikeException {
        private static final long serialVersionUID = 1L;
        public final CommitError error;
        public final BatchRecord[] verifyRecords;
        public final BatchRecord[] rollRecords;

        public Commit(CommitError error, BatchRecord[] verifyRecords, BatchRecord[] rollRecords) {
            super(-17, error.str);
            this.error = error;
            this.verifyRecords = verifyRecords;
            this.rollRecords = rollRecords;
        }

        public Commit(CommitError error, BatchRecord[] verifyRecords, BatchRecord[] rollRecords, Throwable cause) {
            super(-17, error.str, cause);
            this.error = error;
            this.verifyRecords = verifyRecords;
            this.rollRecords = rollRecords;
        }

        @Override
        public String getMessage() {
            String msg = super.getMessage();
            StringBuilder sb = new StringBuilder(1024);
            AerospikeException.recordsToString(sb, "verify errors:", this.verifyRecords);
            AerospikeException.recordsToString(sb, "roll errors:", this.rollRecords);
            return msg + sb.toString();
        }
    }

    public static class Backoff
    extends AerospikeException {
        private static final long serialVersionUID = 1L;

        public Backoff(int resultCode) {
            super(resultCode);
        }
    }

    public static final class AsyncQueueFull
    extends Backoff {
        private static final long serialVersionUID = 1L;

        public AsyncQueueFull() {
            super(-9);
        }
    }

    public static final class QueryTerminated
    extends AerospikeException {
        private static final long serialVersionUID = 1L;

        public QueryTerminated() {
            super(-5);
        }

        public QueryTerminated(Throwable e) {
            super(-5, "Query terminated", e);
        }
    }

    public static final class ScanTerminated
    extends AerospikeException {
        private static final long serialVersionUID = 1L;

        public ScanTerminated() {
            super(-4);
        }

        public ScanTerminated(Throwable e) {
            super(-4, "Scan terminated", e);
        }
    }

    public static final class BatchRecordArray
    extends AerospikeException {
        private static final long serialVersionUID = 1L;
        public final BatchRecord[] records;

        public BatchRecordArray(BatchRecord[] records, Throwable e) {
            super(-16, "Batch failed", e);
            this.records = records;
        }

        public BatchRecordArray(BatchRecord[] records, String message, Throwable e) {
            super(-16, message, e);
            this.records = records;
        }
    }

    public static final class BatchRecords
    extends AerospikeException {
        private static final long serialVersionUID = 1L;
        public final Record[] records;

        public BatchRecords(Record[] records, Throwable e) {
            super(-16, "Batch failed", e);
            this.records = records;
        }
    }

    public static final class BatchExists
    extends AerospikeException {
        private static final long serialVersionUID = 1L;
        public final boolean[] exists;

        public BatchExists(boolean[] exists, Throwable e) {
            super(-16, "Batch failed", e);
            this.exists = exists;
        }
    }

    public static final class InvalidNamespace
    extends AerospikeException {
        private static final long serialVersionUID = 1L;

        public InvalidNamespace(String ns, int mapSize) {
            super(20, (String)(mapSize == 0 ? "Partition map empty" : "Namespace not found in partition map: " + ns));
        }
    }

    public static final class InvalidNode
    extends AerospikeException {
        private static final long serialVersionUID = 1L;

        public InvalidNode(int clusterSize, Partition partition) {
            super(-3, (String)(clusterSize == 0 ? "Cluster is empty" : "Node not found for partition " + String.valueOf(partition)));
        }

        public InvalidNode(int partitionId) {
            super(-3, "Node not found for partition " + partitionId);
        }

        public InvalidNode(String message) {
            super(-3, message);
        }
    }

    public static final class Connection
    extends AerospikeException {
        private static final long serialVersionUID = 1L;

        public Connection(String message) {
            super(-8, message);
        }

        public Connection(Throwable e) {
            super(-8, "Connection failed", e);
        }

        public Connection(String message, Throwable e) {
            super(-8, message, e);
        }

        public Connection(int resultCode, String message) {
            super(resultCode, message);
        }
    }

    public static final class Parse
    extends AerospikeException {
        private static final long serialVersionUID = 1L;

        public Parse(String message) {
            super(-2, message);
        }
    }

    public static final class Serialize
    extends AerospikeException {
        private static final long serialVersionUID = 1L;

        public Serialize(Throwable e) {
            super(-10, "Serialize error", e);
        }

        public Serialize(String message) {
            super(-10, message);
        }
    }

    public static final class Timeout
    extends AerospikeException {
        private static final long serialVersionUID = 1L;
        public int connectTimeout;
        public int socketTimeout;
        public int timeout;
        public boolean client;

        public Timeout(String message, int iteration, int totalTimeout, boolean inDoubt) {
            super(9, message);
            this.iteration = iteration;
            this.inDoubt = inDoubt;
            Policy p = new Policy();
            p.connectTimeout = 0;
            p.socketTimeout = 0;
            p.totalTimeout = totalTimeout;
            p.maxRetries = -1;
            this.policy = p;
            this.connectTimeout = 0;
            this.socketTimeout = 0;
            this.timeout = totalTimeout;
            this.client = true;
        }

        public Timeout(Policy policy, boolean client) {
            super(9, (client ? "Client" : "Server") + " timeout");
            this.policy = policy;
            this.connectTimeout = policy.connectTimeout;
            this.socketTimeout = policy.socketTimeout;
            this.timeout = policy.totalTimeout;
            this.client = client;
        }

        public Timeout(Policy policy, int iteration) {
            super(9, "Client timeout");
            this.policy = policy;
            this.iteration = iteration;
            this.connectTimeout = policy.connectTimeout;
            this.socketTimeout = policy.socketTimeout;
            this.timeout = policy.totalTimeout;
            this.client = true;
        }

        public Timeout(Node node, int connectTimeout, int socketTimeout, int totalTimeout) {
            super(9, "Client timeout");
            this.node = node;
            this.iteration = 1;
            Policy p = new Policy();
            p.connectTimeout = connectTimeout;
            p.socketTimeout = socketTimeout;
            p.totalTimeout = totalTimeout;
            p.maxRetries = 0;
            this.policy = p;
            this.connectTimeout = connectTimeout;
            this.socketTimeout = socketTimeout;
            this.timeout = totalTimeout;
            this.client = true;
        }
    }
}

