/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.BatchRecord;
import com.aerospike.client.Key;
import com.aerospike.client.Operation;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.configuration.ConfigurationProvider;
import com.aerospike.client.configuration.serializers.Configuration;
import com.aerospike.client.policy.BatchWritePolicy;
import com.aerospike.client.policy.Policy;

public final class BatchWrite
extends BatchRecord {
    public final BatchWritePolicy policy;
    public final Operation[] ops;

    public BatchWrite(Key key, Operation[] ops) {
        super(key, true);
        this.ops = ops;
        this.policy = null;
    }

    public BatchWrite(BatchWritePolicy policy, Key key, Operation[] ops) {
        super(key, true);
        this.ops = ops;
        this.policy = policy;
    }

    @Override
    public BatchRecord.Type getType() {
        return BatchRecord.Type.BATCH_WRITE;
    }

    @Override
    public boolean equals(BatchRecord obj, ConfigurationProvider configProvider) {
        Configuration config;
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BatchWrite other = (BatchWrite)obj;
        if (this.ops != other.ops || this.policy != other.policy) {
            return false;
        }
        boolean sendkey = false;
        if (this.policy != null) {
            sendkey = this.policy.sendKey;
        }
        if (configProvider != null && (config = configProvider.fetchConfiguration()) != null && config.hasDBWCsendKey()) {
            sendkey = config.dynamicConfiguration.dynamicBatchWriteConfig.sendKey.value;
        }
        return !sendkey;
    }

    @Override
    public int size(Policy parentPolicy, ConfigurationProvider configProvider) {
        int size = 2;
        if (this.policy != null) {
            Configuration config;
            if (this.policy.filterExp != null) {
                size += this.policy.filterExp.size();
            }
            boolean sendkey = this.policy.sendKey;
            if (configProvider != null && (config = configProvider.fetchConfiguration()) != null && config.hasDBWCsendKey()) {
                sendkey = config.dynamicConfiguration.dynamicBatchWriteConfig.sendKey.value;
            }
            if (sendkey || parentPolicy.sendKey) {
                size += this.key.userKey.estimateSize() + 5 + 1;
            }
        } else if (parentPolicy.sendKey) {
            size += this.key.userKey.estimateSize() + 5 + 1;
        }
        boolean hasWrite = false;
        for (Operation op : this.ops) {
            if (op.type.isWrite) {
                hasWrite = true;
            }
            size += Buffer.estimateSizeUtf8(op.binName) + 8;
            size += op.value.estimateSize();
        }
        if (!hasWrite) {
            throw new AerospikeException(4, "Batch write operations do not contain a write");
        }
        return size;
    }
}

