/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeClient;
import com.aerospike.client.AerospikeException;
import com.aerospike.client.BatchRead;
import com.aerospike.client.BatchRecord;
import com.aerospike.client.Key;
import com.aerospike.client.Log;
import com.aerospike.client.Operation;
import com.aerospike.client.Record;
import com.aerospike.client.Txn;
import com.aerospike.client.async.AsyncBatchExecutor;
import com.aerospike.client.async.AsyncMultiCommand;
import com.aerospike.client.command.BatchAttr;
import com.aerospike.client.command.BatchNode;
import com.aerospike.client.command.BatchNodeList;
import com.aerospike.client.command.Command;
import com.aerospike.client.configuration.ConfigurationProvider;
import com.aerospike.client.listener.BatchRecordSequenceListener;
import com.aerospike.client.listener.BatchSequenceListener;
import com.aerospike.client.listener.ExistsSequenceListener;
import com.aerospike.client.listener.RecordSequenceListener;
import com.aerospike.client.metrics.LatencyType;
import com.aerospike.client.policy.BatchPolicy;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.ReadModeSC;
import com.aerospike.client.policy.Replica;
import com.aerospike.client.util.Util;
import java.util.List;

public final class AsyncBatch {
    public static void onRecord(RecordSequenceListener listener, Key key, Record record) {
        try {
            listener.onRecord(key, record);
        }
        catch (Throwable e) {
            Log.error("Unexpected exception from onRecord(): " + Util.getErrorMessage(e));
        }
    }

    public static void onRecord(BatchRecordSequenceListener listener, BatchRecord record, int index2) {
        try {
            listener.onRecord(record, index2);
        }
        catch (Throwable e) {
            Log.error("Unexpected exception from onRecord(): " + Util.getErrorMessage(e));
        }
    }

    static abstract class AsyncBatchCommand
    extends AsyncMultiCommand {
        final AsyncBatchExecutor parent;
        final BatchNode batch;
        final BatchPolicy batchPolicy;
        int sequenceAP;
        int sequenceSC;

        public AsyncBatchCommand(AsyncBatchExecutor parent, BatchNode batch, BatchPolicy batchPolicy, boolean isOperation) {
            super(batch.node, batchPolicy, isOperation);
            this.parent = parent;
            this.batch = batch;
            this.batchPolicy = batchPolicy;
        }

        @Override
        protected LatencyType getLatencyType() {
            return LatencyType.BATCH;
        }

        @Override
        void addSubException(AerospikeException ae) {
            this.parent.addSubException(ae);
        }

        final void parseFieldsRead(Key key) {
            if (this.policy.txn != null) {
                Long version = this.parseVersion(this.fieldCount);
                this.policy.txn.onRead(key, version);
            } else {
                this.skipKey(this.fieldCount);
            }
        }

        final void parseFields(Key key, boolean hasWrite) {
            if (this.policy.txn != null) {
                Long version = this.parseVersion(this.fieldCount);
                if (hasWrite) {
                    this.policy.txn.onWrite(key, version, this.resultCode);
                } else {
                    this.policy.txn.onRead(key, version);
                }
            } else {
                this.skipKey(this.fieldCount);
            }
        }

        @Override
        protected boolean prepareRetry(boolean timeout) {
            if (this.parent.done || this.policy.replica != Replica.SEQUENCE && this.policy.replica != Replica.PREFER_RACK) {
                return true;
            }
            ++this.sequenceAP;
            if (!timeout || this.policy.readModeSC != ReadModeSC.LINEARIZE) {
                ++this.sequenceSC;
            }
            return false;
        }

        @Override
        protected boolean retryBatch(Runnable other, long deadline) {
            List<BatchNode> batchNodes = this.generateBatchNodes();
            if (batchNodes.size() == 0 || batchNodes.size() == 1 && batchNodes.get((int)0).node == this.batch.node) {
                return false;
            }
            this.parent.cluster.addRetries(batchNodes.size());
            AsyncBatchCommand[] cmds = new AsyncBatchCommand[batchNodes.size()];
            int count = 0;
            for (BatchNode batchNode : batchNodes) {
                AsyncBatchCommand cmd = this.createCommand(batchNode);
                cmd.sequenceAP = this.sequenceAP;
                cmd.sequenceSC = this.sequenceSC;
                cmds[count++] = cmd;
            }
            this.parent.executeBatchRetry(cmds, this, other, deadline);
            return true;
        }

        @Override
        protected void onSuccess() {
            this.parent.childSuccess();
        }

        @Override
        protected void onFailure(AerospikeException e) {
            this.setInDoubt(e.getInDoubt());
            this.parent.childFailure(e);
        }

        protected void setInDoubt(boolean inDoubt) {
        }

        abstract AsyncBatchCommand createCommand(BatchNode var1);

        abstract List<BatchNode> generateBatchNodes();
    }

    public static final class TxnRoll
    extends AsyncBatchCommand {
        private final Txn txn;
        private final Key[] keys;
        private final BatchRecord[] records;
        private final BatchAttr attr;

        public TxnRoll(AsyncBatchExecutor parent, BatchNode batch, BatchPolicy batchPolicy, Txn txn, Key[] keys, BatchRecord[] records, BatchAttr attr) {
            super(parent, batch, batchPolicy, false);
            this.txn = txn;
            this.keys = keys;
            this.records = records;
            this.attr = attr;
        }

        @Override
        protected void writeBuffer() {
            this.setBatchTxnRoll(this.batchPolicy, this.txn, this.keys, this.batch, this.attr);
        }

        @Override
        protected void parseRow() {
            this.skipKey(this.fieldCount);
            BatchRecord record = this.records[this.batchIndex];
            if (this.resultCode == 0) {
                record.resultCode = this.resultCode;
            } else {
                record.setError(this.resultCode, Command.batchInDoubt(this.attr.hasWrite, this.commandSentCounter));
                this.parent.setRowError();
            }
        }

        @Override
        protected AsyncBatchCommand createCommand(BatchNode batchNode) {
            return new TxnRoll(this.parent, batchNode, this.batchPolicy, this.txn, this.keys, this.records, this.attr);
        }

        @Override
        protected List<BatchNode> generateBatchNodes() {
            return BatchNodeList.generate(this.parent.cluster, this.batchPolicy, this.keys, this.sequenceAP, this.sequenceSC, this.batch, true, this.parent);
        }
    }

    public static final class TxnVerify
    extends AsyncBatchCommand {
        private final Key[] keys;
        private final Long[] versions;
        private final BatchRecord[] records;

        public TxnVerify(AsyncBatchExecutor parent, BatchNode batch, BatchPolicy batchPolicy, Key[] keys, Long[] versions, BatchRecord[] records) {
            super(parent, batch, batchPolicy, false);
            this.keys = keys;
            this.versions = versions;
            this.records = records;
        }

        @Override
        protected void writeBuffer() {
            this.setBatchTxnVerify(this.batchPolicy, this.keys, this.versions, this.batch);
        }

        @Override
        protected void parseRow() {
            this.skipKey(this.fieldCount);
            BatchRecord record = this.records[this.batchIndex];
            if (this.resultCode == 0) {
                record.resultCode = this.resultCode;
            } else {
                record.setError(this.resultCode, false);
                this.parent.setRowError();
            }
        }

        @Override
        protected AsyncBatchCommand createCommand(BatchNode batchNode) {
            return new TxnVerify(this.parent, batchNode, this.batchPolicy, this.keys, this.versions, this.records);
        }

        @Override
        protected List<BatchNode> generateBatchNodes() {
            return BatchNodeList.generate(this.parent.cluster, this.batchPolicy, this.keys, this.sequenceAP, this.sequenceSC, this.batch, false, this.parent);
        }
    }

    public static final class UDFSequenceCommand
    extends AsyncBatchCommand {
        private final Key[] keys;
        private final String packageName;
        private final String functionName;
        private final byte[] argBytes;
        private final boolean[] sent;
        private final BatchRecordSequenceListener listener;
        private final BatchAttr attr;

        public UDFSequenceCommand(AsyncBatchExecutor parent, BatchNode batch, BatchPolicy batchPolicy, Key[] keys, String packageName, String functionName, byte[] argBytes, boolean[] sent, BatchRecordSequenceListener listener, BatchAttr attr) {
            super(parent, batch, batchPolicy, false);
            this.keys = keys;
            this.packageName = packageName;
            this.functionName = functionName;
            this.argBytes = argBytes;
            this.sent = sent;
            this.listener = listener;
            this.attr = attr;
        }

        @Override
        protected boolean isWrite() {
            return this.attr.hasWrite;
        }

        @Override
        protected void writeBuffer() {
            this.setBatchUDF(this.batchPolicy, this.keys, this.batch, this.packageName, this.functionName, this.argBytes, this.attr);
        }

        @Override
        protected void parseRow() {
            Record r;
            String m;
            Key keyOrig = this.keys[this.batchIndex];
            this.parseFields(keyOrig, this.attr.hasWrite);
            BatchRecord record = this.resultCode == 0 ? new BatchRecord(keyOrig, this.parseRecord(), this.attr.hasWrite) : (this.resultCode == 100 ? ((m = (r = this.parseRecord()).getString("FAILURE")) != null ? new BatchRecord(keyOrig, r, this.resultCode, Command.batchInDoubt(this.attr.hasWrite, this.commandSentCounter), this.attr.hasWrite) : new BatchRecord(keyOrig, null, this.resultCode, Command.batchInDoubt(this.attr.hasWrite, this.commandSentCounter), this.attr.hasWrite)) : new BatchRecord(keyOrig, null, this.resultCode, Command.batchInDoubt(this.attr.hasWrite, this.commandSentCounter), this.attr.hasWrite));
            this.sent[this.batchIndex] = true;
            AsyncBatch.onRecord(this.listener, record, this.batchIndex);
        }

        @Override
        protected void setInDoubt(boolean inDoubt) {
            for (int index2 : this.batch.offsets) {
                if (this.sent[index2]) continue;
                Key key = this.keys[index2];
                BatchRecord record = new BatchRecord(key, null, -15, this.attr.hasWrite && inDoubt, this.attr.hasWrite);
                this.sent[index2] = true;
                if (record.inDoubt && this.policy.txn != null) {
                    this.policy.txn.onWriteInDoubt(record.key);
                }
                AsyncBatch.onRecord(this.listener, record, index2);
            }
        }

        @Override
        protected AsyncBatchCommand createCommand(BatchNode batchNode) {
            return new UDFSequenceCommand(this.parent, batchNode, this.batchPolicy, this.keys, this.packageName, this.functionName, this.argBytes, this.sent, this.listener, this.attr);
        }

        @Override
        protected List<BatchNode> generateBatchNodes() {
            return BatchNodeList.generate(this.parent.cluster, this.batchPolicy, this.keys, this.sent, this.sequenceAP, this.sequenceSC, this.batch, this.attr.hasWrite, (BatchNodeList.IBatchStatus)this.parent);
        }
    }

    public static final class UDFArrayCommand
    extends AsyncBatchCommand {
        private final Key[] keys;
        private final String packageName;
        private final String functionName;
        private final byte[] argBytes;
        private final BatchRecord[] records;
        private final BatchAttr attr;

        public UDFArrayCommand(AsyncBatchExecutor parent, BatchNode batch, BatchPolicy batchPolicy, Key[] keys, String packageName, String functionName, byte[] argBytes, BatchRecord[] records, BatchAttr attr) {
            super(parent, batch, batchPolicy, false);
            this.keys = keys;
            this.packageName = packageName;
            this.functionName = functionName;
            this.argBytes = argBytes;
            this.records = records;
            this.attr = attr;
        }

        @Override
        protected boolean isWrite() {
            return this.attr.hasWrite;
        }

        @Override
        protected void writeBuffer() {
            this.setBatchUDF(this.batchPolicy, this.keys, this.batch, this.packageName, this.functionName, this.argBytes, this.attr);
        }

        @Override
        protected void parseRow() {
            Record r;
            String m;
            BatchRecord record = this.records[this.batchIndex];
            this.parseFields(record.key, record.hasWrite);
            if (this.resultCode == 0) {
                record.setRecord(this.parseRecord());
                return;
            }
            if (this.resultCode == 100 && (m = (r = this.parseRecord()).getString("FAILURE")) != null) {
                record.record = r;
                record.resultCode = this.resultCode;
                record.inDoubt = Command.batchInDoubt(this.attr.hasWrite, this.commandSentCounter);
                this.parent.setRowError();
                return;
            }
            record.setError(this.resultCode, Command.batchInDoubt(this.attr.hasWrite, this.commandSentCounter));
            this.parent.setRowError();
        }

        @Override
        protected void setInDoubt(boolean inDoubt) {
            if (!inDoubt || !this.attr.hasWrite) {
                return;
            }
            for (int index2 : this.batch.offsets) {
                BatchRecord record = this.records[index2];
                if (record.resultCode != -15) continue;
                record.inDoubt = true;
                if (this.policy.txn == null) continue;
                this.policy.txn.onWriteInDoubt(record.key);
            }
        }

        @Override
        protected AsyncBatchCommand createCommand(BatchNode batchNode) {
            return new UDFArrayCommand(this.parent, batchNode, this.batchPolicy, this.keys, this.packageName, this.functionName, this.argBytes, this.records, this.attr);
        }

        @Override
        protected List<BatchNode> generateBatchNodes() {
            return BatchNodeList.generate(this.parent.cluster, this.batchPolicy, this.keys, this.records, this.sequenceAP, this.sequenceSC, this.batch, this.attr.hasWrite, (BatchNodeList.IBatchStatus)this.parent);
        }
    }

    public static final class OperateRecordSequenceCommand
    extends AsyncBatchCommand {
        private final Key[] keys;
        private final Operation[] ops;
        private final boolean[] sent;
        private final BatchRecordSequenceListener listener;
        private final BatchAttr attr;

        public OperateRecordSequenceCommand(AsyncBatchExecutor parent, BatchNode batch, BatchPolicy batchPolicy, Key[] keys, Operation[] ops, boolean[] sent, BatchRecordSequenceListener listener, BatchAttr attr) {
            super(parent, batch, batchPolicy, ops != null);
            this.keys = keys;
            this.ops = ops;
            this.sent = sent;
            this.listener = listener;
            this.attr = attr;
        }

        @Override
        protected boolean isWrite() {
            return this.attr.hasWrite;
        }

        @Override
        protected void writeBuffer() {
            this.setBatchOperate(this.batchPolicy, this.keys, this.batch, null, this.ops, this.attr);
        }

        @Override
        protected void parseRow() {
            Key keyOrig = this.keys[this.batchIndex];
            this.parseFields(keyOrig, this.attr.hasWrite);
            BatchRecord record = this.resultCode == 0 ? new BatchRecord(keyOrig, this.parseRecord(), this.attr.hasWrite) : new BatchRecord(keyOrig, null, this.resultCode, Command.batchInDoubt(this.attr.hasWrite, this.commandSentCounter), this.attr.hasWrite);
            this.sent[this.batchIndex] = true;
            AsyncBatch.onRecord(this.listener, record, this.batchIndex);
        }

        @Override
        protected void setInDoubt(boolean inDoubt) {
            for (int index2 : this.batch.offsets) {
                if (this.sent[index2]) continue;
                Key key = this.keys[index2];
                BatchRecord record = new BatchRecord(key, null, -15, this.attr.hasWrite && inDoubt, this.attr.hasWrite);
                this.sent[index2] = true;
                if (record.inDoubt && this.policy.txn != null) {
                    this.policy.txn.onWriteInDoubt(key);
                }
                AsyncBatch.onRecord(this.listener, record, index2);
            }
        }

        @Override
        protected AsyncBatchCommand createCommand(BatchNode batchNode) {
            return new OperateRecordSequenceCommand(this.parent, batchNode, this.batchPolicy, this.keys, this.ops, this.sent, this.listener, this.attr);
        }

        @Override
        protected List<BatchNode> generateBatchNodes() {
            return BatchNodeList.generate(this.parent.cluster, this.batchPolicy, this.keys, this.sent, this.sequenceAP, this.sequenceSC, this.batch, this.attr.hasWrite, (BatchNodeList.IBatchStatus)this.parent);
        }
    }

    public static final class OperateRecordArrayCommand
    extends AsyncBatchCommand {
        private final Key[] keys;
        private final Operation[] ops;
        private final BatchRecord[] records;
        private final BatchAttr attr;

        public OperateRecordArrayCommand(AsyncBatchExecutor parent, BatchNode batch, BatchPolicy batchPolicy, Key[] keys, Operation[] ops, BatchRecord[] records, BatchAttr attr) {
            super(parent, batch, batchPolicy, ops != null);
            this.keys = keys;
            this.ops = ops;
            this.records = records;
            this.attr = attr;
        }

        @Override
        protected boolean isWrite() {
            return this.attr.hasWrite;
        }

        @Override
        protected void writeBuffer() {
            this.setBatchOperate(this.batchPolicy, this.keys, this.batch, null, this.ops, this.attr);
        }

        @Override
        protected void parseRow() {
            BatchRecord record = this.records[this.batchIndex];
            this.parseFields(record.key, record.hasWrite);
            if (this.resultCode == 0) {
                record.setRecord(this.parseRecord());
            } else {
                record.setError(this.resultCode, Command.batchInDoubt(this.attr.hasWrite, this.commandSentCounter));
                this.parent.setRowError();
            }
        }

        @Override
        protected void setInDoubt(boolean inDoubt) {
            if (!inDoubt || !this.attr.hasWrite) {
                return;
            }
            for (int index2 : this.batch.offsets) {
                BatchRecord record = this.records[index2];
                if (record.resultCode != -15) continue;
                record.inDoubt = true;
                if (this.policy.txn == null) continue;
                this.policy.txn.onWriteInDoubt(record.key);
            }
        }

        @Override
        protected AsyncBatchCommand createCommand(BatchNode batchNode) {
            return new OperateRecordArrayCommand(this.parent, batchNode, this.batchPolicy, this.keys, this.ops, this.records, this.attr);
        }

        @Override
        protected List<BatchNode> generateBatchNodes() {
            return BatchNodeList.generate(this.parent.cluster, this.batchPolicy, this.keys, this.records, this.sequenceAP, this.sequenceSC, this.batch, this.attr.hasWrite, (BatchNodeList.IBatchStatus)this.parent);
        }
    }

    public static final class OperateSequenceCommand
    extends AsyncBatchCommand {
        private final BatchRecordSequenceListener listener;
        private final List<BatchRecord> records;
        private final ConfigurationProvider configProvider;

        public OperateSequenceCommand(AsyncBatchExecutor parent, BatchNode batch, BatchPolicy batchPolicy, BatchRecordSequenceListener listener, List<BatchRecord> records, ConfigurationProvider cp) {
            super(parent, batch, batchPolicy, true);
            this.listener = listener;
            this.records = records;
            this.configProvider = cp;
        }

        @Override
        protected boolean isWrite() {
            return true;
        }

        @Override
        protected void writeBuffer() {
            AerospikeClient client = this.parent.cluster.client;
            this.setBatchOperate(this.batchPolicy, client.batchWritePolicyDefault, client.batchUDFPolicyDefault, client.batchDeletePolicyDefault, this.records, this.batch, this.configProvider);
        }

        @Override
        protected void parseRow() {
            BatchRecord record = this.records.get(this.batchIndex);
            this.parseFields(record.key, record.hasWrite);
            if (this.resultCode == 0) {
                record.setRecord(this.parseRecord());
            } else if (this.resultCode == 100) {
                Record r = this.parseRecord();
                String m = r.getString("FAILURE");
                if (m != null) {
                    record.record = r;
                    record.resultCode = this.resultCode;
                    record.inDoubt = Command.batchInDoubt(record.hasWrite, this.commandSentCounter);
                } else {
                    record.setError(this.resultCode, Command.batchInDoubt(record.hasWrite, this.commandSentCounter));
                }
            } else {
                record.setError(this.resultCode, Command.batchInDoubt(record.hasWrite, this.commandSentCounter));
            }
            AsyncBatch.onRecord(this.listener, record, this.batchIndex);
        }

        @Override
        protected void setInDoubt(boolean inDoubt) {
            if (!inDoubt) {
                return;
            }
            for (int index2 : this.batch.offsets) {
                BatchRecord record = this.records.get(index2);
                if (record.resultCode != -15) continue;
                record.inDoubt = record.hasWrite;
                if (!record.inDoubt || this.policy.txn == null) continue;
                this.policy.txn.onWriteInDoubt(record.key);
            }
        }

        @Override
        protected AsyncBatchCommand createCommand(BatchNode batchNode) {
            return new OperateSequenceCommand(this.parent, batchNode, this.batchPolicy, this.listener, this.records, this.configProvider);
        }

        @Override
        protected List<BatchNode> generateBatchNodes() {
            return BatchNodeList.generate(this.parent.cluster, this.batchPolicy, this.records, this.sequenceAP, this.sequenceSC, this.batch, this.parent);
        }
    }

    public static final class OperateListCommand
    extends AsyncBatchCommand {
        private final List<BatchRecord> records;
        private final ConfigurationProvider configProvider;

        public OperateListCommand(AsyncBatchExecutor parent, BatchNode batch, BatchPolicy batchPolicy, List<BatchRecord> records, ConfigurationProvider cp) {
            super(parent, batch, batchPolicy, true);
            this.records = records;
            this.configProvider = cp;
        }

        @Override
        protected boolean isWrite() {
            return true;
        }

        @Override
        protected void writeBuffer() {
            AerospikeClient client = this.parent.cluster.client;
            this.setBatchOperate(this.batchPolicy, client.batchWritePolicyDefault, client.batchUDFPolicyDefault, client.batchDeletePolicyDefault, this.records, this.batch, this.configProvider);
        }

        @Override
        protected void parseRow() {
            Record r;
            String m;
            BatchRecord record = this.records.get(this.batchIndex);
            this.parseFields(record.key, record.hasWrite);
            if (this.resultCode == 0) {
                record.setRecord(this.parseRecord());
                return;
            }
            if (this.resultCode == 100 && (m = (r = this.parseRecord()).getString("FAILURE")) != null) {
                record.record = r;
                record.resultCode = this.resultCode;
                record.inDoubt = Command.batchInDoubt(record.hasWrite, this.commandSentCounter);
                this.parent.setRowError();
                return;
            }
            record.setError(this.resultCode, Command.batchInDoubt(record.hasWrite, this.commandSentCounter));
            this.parent.setRowError();
        }

        @Override
        protected void setInDoubt(boolean inDoubt) {
            if (!inDoubt) {
                return;
            }
            for (int index2 : this.batch.offsets) {
                BatchRecord record = this.records.get(index2);
                if (record.resultCode != -15) continue;
                record.inDoubt = record.hasWrite;
                if (!record.inDoubt || this.policy.txn == null) continue;
                this.policy.txn.onWriteInDoubt(record.key);
            }
        }

        @Override
        protected AsyncBatchCommand createCommand(BatchNode batchNode) {
            return new OperateListCommand(this.parent, batchNode, this.batchPolicy, this.records, this.configProvider);
        }

        @Override
        protected List<BatchNode> generateBatchNodes() {
            return BatchNodeList.generate(this.parent.cluster, this.batchPolicy, this.records, this.sequenceAP, this.sequenceSC, this.batch, this.parent);
        }
    }

    public static final class ExistsSequenceCommand
    extends AsyncBatchCommand {
        private final Key[] keys;
        private final ExistsSequenceListener listener;

        public ExistsSequenceCommand(AsyncBatchExecutor parent, BatchNode batch, BatchPolicy batchPolicy, Key[] keys, ExistsSequenceListener listener) {
            super(parent, batch, batchPolicy, false);
            this.keys = keys;
            this.listener = listener;
        }

        @Override
        protected void writeBuffer() {
            if (this.batch.node.hasBatchAny()) {
                BatchAttr attr = new BatchAttr(this.batchPolicy, 33);
                this.setBatchOperate(this.batchPolicy, this.keys, this.batch, null, null, attr);
            } else {
                this.setBatchRead(this.batchPolicy, this.keys, this.batch, null, null, 33);
            }
        }

        @Override
        protected void parseRow() {
            Key keyOrig = this.keys[this.batchIndex];
            this.parseFieldsRead(keyOrig);
            this.listener.onExists(keyOrig, this.resultCode == 0);
        }

        @Override
        protected AsyncBatchCommand createCommand(BatchNode batchNode) {
            return new ExistsSequenceCommand(this.parent, batchNode, this.batchPolicy, this.keys, this.listener);
        }

        @Override
        protected List<BatchNode> generateBatchNodes() {
            return BatchNodeList.generate(this.parent.cluster, this.batchPolicy, this.keys, this.sequenceAP, this.sequenceSC, this.batch, false, this.parent);
        }
    }

    public static final class ExistsArrayCommand
    extends AsyncBatchCommand {
        private final Key[] keys;
        private final boolean[] existsArray;

        public ExistsArrayCommand(AsyncBatchExecutor parent, BatchNode batch, BatchPolicy batchPolicy, Key[] keys, boolean[] existsArray) {
            super(parent, batch, batchPolicy, false);
            this.keys = keys;
            this.existsArray = existsArray;
        }

        @Override
        protected void writeBuffer() {
            if (this.batch.node.hasBatchAny()) {
                BatchAttr attr = new BatchAttr(this.batchPolicy, 33);
                this.setBatchOperate(this.batchPolicy, this.keys, this.batch, null, null, attr);
            } else {
                this.setBatchRead(this.batchPolicy, this.keys, this.batch, null, null, 33);
            }
        }

        @Override
        protected void parseRow() {
            this.parseFieldsRead(this.keys[this.batchIndex]);
            this.existsArray[this.batchIndex] = this.resultCode == 0;
        }

        @Override
        protected AsyncBatchCommand createCommand(BatchNode batchNode) {
            return new ExistsArrayCommand(this.parent, batchNode, this.batchPolicy, this.keys, this.existsArray);
        }

        @Override
        protected List<BatchNode> generateBatchNodes() {
            return BatchNodeList.generate(this.parent.cluster, this.batchPolicy, this.keys, this.sequenceAP, this.sequenceSC, this.batch, false, this.parent);
        }
    }

    public static final class GetSequenceCommand
    extends AsyncBatchCommand {
        private final Key[] keys;
        private final String[] binNames;
        private final Operation[] ops;
        private final RecordSequenceListener listener;
        private final int readAttr;

        public GetSequenceCommand(AsyncBatchExecutor parent, BatchNode batch, BatchPolicy batchPolicy, Key[] keys, String[] binNames, Operation[] ops, RecordSequenceListener listener, int readAttr, boolean isOperation) {
            super(parent, batch, batchPolicy, isOperation);
            this.keys = keys;
            this.binNames = binNames;
            this.ops = ops;
            this.listener = listener;
            this.readAttr = readAttr;
        }

        @Override
        protected void writeBuffer() {
            if (this.batch.node.hasBatchAny()) {
                BatchAttr attr = new BatchAttr((Policy)this.batchPolicy, this.readAttr, this.ops);
                this.setBatchOperate(this.batchPolicy, this.keys, this.batch, this.binNames, this.ops, attr);
            } else {
                this.setBatchRead(this.batchPolicy, this.keys, this.batch, this.binNames, this.ops, this.readAttr);
            }
        }

        @Override
        protected void parseRow() {
            Key keyOrig = this.keys[this.batchIndex];
            this.parseFieldsRead(keyOrig);
            if (this.resultCode == 0) {
                Record record = this.parseRecord();
                this.listener.onRecord(keyOrig, record);
            } else {
                this.listener.onRecord(keyOrig, null);
            }
        }

        @Override
        protected AsyncBatchCommand createCommand(BatchNode batchNode) {
            return new GetSequenceCommand(this.parent, batchNode, this.batchPolicy, this.keys, this.binNames, this.ops, this.listener, this.readAttr, this.isOperation);
        }

        @Override
        protected List<BatchNode> generateBatchNodes() {
            return BatchNodeList.generate(this.parent.cluster, this.batchPolicy, this.keys, this.sequenceAP, this.sequenceSC, this.batch, false, this.parent);
        }
    }

    public static final class GetArrayCommand
    extends AsyncBatchCommand {
        private final Key[] keys;
        private final String[] binNames;
        private final Operation[] ops;
        private final Record[] records;
        private final int readAttr;

        public GetArrayCommand(AsyncBatchExecutor parent, BatchNode batch, BatchPolicy batchPolicy, Key[] keys, String[] binNames, Operation[] ops, Record[] records, int readAttr, boolean isOperation) {
            super(parent, batch, batchPolicy, isOperation);
            this.keys = keys;
            this.binNames = binNames;
            this.ops = ops;
            this.records = records;
            this.readAttr = readAttr;
        }

        @Override
        protected void writeBuffer() {
            if (this.batch.node.hasBatchAny()) {
                BatchAttr attr = new BatchAttr((Policy)this.batchPolicy, this.readAttr, this.ops);
                this.setBatchOperate(this.batchPolicy, this.keys, this.batch, this.binNames, this.ops, attr);
            } else {
                this.setBatchRead(this.batchPolicy, this.keys, this.batch, this.binNames, this.ops, this.readAttr);
            }
        }

        @Override
        protected void parseRow() {
            this.parseFieldsRead(this.keys[this.batchIndex]);
            if (this.resultCode == 0) {
                this.records[this.batchIndex] = this.parseRecord();
            }
        }

        @Override
        protected AsyncBatchCommand createCommand(BatchNode batchNode) {
            return new GetArrayCommand(this.parent, batchNode, this.batchPolicy, this.keys, this.binNames, this.ops, this.records, this.readAttr, this.isOperation);
        }

        @Override
        protected List<BatchNode> generateBatchNodes() {
            return BatchNodeList.generate(this.parent.cluster, this.batchPolicy, this.keys, this.sequenceAP, this.sequenceSC, this.batch, false, this.parent);
        }
    }

    public static final class ReadSequenceCommand
    extends AsyncBatchCommand {
        private final BatchSequenceListener listener;
        private final List<BatchRead> records;

        public ReadSequenceCommand(AsyncBatchExecutor parent, BatchNode batch, BatchPolicy batchPolicy, BatchSequenceListener listener, List<BatchRead> records) {
            super(parent, batch, batchPolicy, true);
            this.listener = listener;
            this.records = records;
        }

        @Override
        protected void writeBuffer() {
            if (this.batch.node.hasBatchAny()) {
                this.setBatchOperate(this.batchPolicy, null, null, null, this.records, this.batch, null);
            } else {
                this.setBatchRead(this.batchPolicy, this.records, this.batch);
            }
        }

        @Override
        protected void parseRow() {
            BatchRead record = this.records.get(this.batchIndex);
            this.parseFieldsRead(record.key);
            if (this.resultCode == 0) {
                record.setRecord(this.parseRecord());
            } else {
                record.setError(this.resultCode, false);
            }
            this.listener.onRecord(record);
        }

        @Override
        protected AsyncBatchCommand createCommand(BatchNode batchNode) {
            return new ReadSequenceCommand(this.parent, batchNode, this.batchPolicy, this.listener, this.records);
        }

        @Override
        protected List<BatchNode> generateBatchNodes() {
            return BatchNodeList.generate(this.parent.cluster, this.batchPolicy, this.records, this.sequenceAP, this.sequenceSC, this.batch, this.parent);
        }
    }

    public static final class ReadListCommand
    extends AsyncBatchCommand {
        private final List<BatchRead> records;

        public ReadListCommand(AsyncBatchExecutor parent, BatchNode batch, BatchPolicy batchPolicy, List<BatchRead> records) {
            super(parent, batch, batchPolicy, true);
            this.records = records;
        }

        @Override
        protected void writeBuffer() {
            if (this.batch.node.hasBatchAny()) {
                this.setBatchOperate(this.batchPolicy, null, null, null, this.records, this.batch, null);
            } else {
                this.setBatchRead(this.batchPolicy, this.records, this.batch);
            }
        }

        @Override
        protected void parseRow() {
            BatchRead record = this.records.get(this.batchIndex);
            this.parseFieldsRead(record.key);
            if (this.resultCode == 0) {
                record.setRecord(this.parseRecord());
            } else {
                record.setError(this.resultCode, false);
            }
        }

        @Override
        protected AsyncBatchCommand createCommand(BatchNode batchNode) {
            return new ReadListCommand(this.parent, batchNode, this.batchPolicy, this.records);
        }

        @Override
        protected List<BatchNode> generateBatchNodes() {
            return BatchNodeList.generate(this.parent.cluster, this.batchPolicy, this.records, this.sequenceAP, this.sequenceSC, this.batch, this.parent);
        }
    }
}

