/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.BatchRead;
import com.aerospike.client.BatchRecord;
import com.aerospike.client.BatchUDF;
import com.aerospike.client.BatchWrite;
import com.aerospike.client.Key;
import com.aerospike.client.Log;
import com.aerospike.client.Operation;
import com.aerospike.client.Record;
import com.aerospike.client.Txn;
import com.aerospike.client.async.AsyncBatch;
import com.aerospike.client.async.AsyncBatchExecutor;
import com.aerospike.client.async.AsyncCommand;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.cluster.Partition;
import com.aerospike.client.command.BatchAttr;
import com.aerospike.client.command.Command;
import com.aerospike.client.command.RecordParser;
import com.aerospike.client.listener.BatchRecordSequenceListener;
import com.aerospike.client.listener.BatchSequenceListener;
import com.aerospike.client.listener.ExistsSequenceListener;
import com.aerospike.client.listener.RecordSequenceListener;
import com.aerospike.client.metrics.LatencyType;
import com.aerospike.client.policy.BatchPolicy;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.util.Util;

public final class AsyncBatchSingle {

    static abstract class AsyncBaseCommand
    extends AsyncCommand {
        final AsyncBatchExecutor executor;
        final Cluster cluster;
        final Key key;
        Node node;
        int sequence;
        final boolean hasWrite;

        public AsyncBaseCommand(AsyncBatchExecutor executor, Cluster cluster, Policy policy, Key key, Node node, boolean hasWrite) {
            super(policy, true, key.namespace);
            this.executor = executor;
            this.cluster = cluster;
            this.key = key;
            this.node = node;
            this.hasWrite = hasWrite;
        }

        @Override
        boolean isWrite() {
            return this.hasWrite;
        }

        @Override
        protected Node getNode(Cluster cluster) {
            return this.node;
        }

        @Override
        protected LatencyType getLatencyType() {
            return LatencyType.BATCH;
        }

        @Override
        void addSubException(AerospikeException ae) {
            this.executor.addSubException(ae);
        }

        @Override
        protected boolean parseResult() {
            RecordParser rp = new RecordParser(this.dataBuffer, this.dataOffset, this.receiveSize);
            rp.parseFields(this.policy.txn, this.key, this.hasWrite);
            this.parseResult(rp);
            return true;
        }

        protected abstract void parseResult(RecordParser var1);

        @Override
        protected boolean prepareRetry(boolean timeout) {
            if (this.hasWrite) {
                Partition p = Partition.write(this.cluster, this.policy, this.key);
                p.sequence = this.sequence;
                p.prevNode = this.node;
                p.prepareRetryWrite(timeout);
                this.node = p.getNodeWrite(this.cluster);
                this.sequence = p.sequence;
            } else {
                Partition p = Partition.read(this.cluster, this.policy, this.key);
                p.sequence = this.sequence;
                p.prevNode = this.node;
                p.prepareRetryRead(timeout);
                this.node = p.getNodeRead(this.cluster);
                this.sequence = p.sequence;
            }
            return true;
        }

        @Override
        protected void onSuccess() {
            this.executor.childSuccess();
        }

        @Override
        protected void onFailure(AerospikeException e) {
            if (e.getInDoubt()) {
                this.setInDoubt();
            }
            this.executor.childFailure(e);
        }

        public void setInDoubt() {
        }
    }

    public static class TxnRoll
    extends AsyncBaseCommand {
        private final Txn txn;
        private final BatchRecord record;
        private final int attr;

        public TxnRoll(AsyncBatchExecutor executor, Cluster cluster, BatchPolicy policy, Txn txn, BatchRecord record, Node node, int attr) {
            super(executor, cluster, policy, record.key, node, true);
            this.txn = txn;
            this.record = record;
            this.attr = attr;
        }

        @Override
        protected void writeBuffer() {
            this.setTxnRoll(this.record.key, this.txn, this.attr);
        }

        @Override
        protected boolean parseResult() {
            RecordParser rp = new RecordParser(this.dataBuffer, this.dataOffset, this.receiveSize);
            if (rp.resultCode == 0) {
                this.record.resultCode = rp.resultCode;
            } else {
                this.record.setError(rp.resultCode, Command.batchInDoubt(true, this.commandSentCounter));
                this.executor.setRowError();
            }
            return true;
        }

        @Override
        protected void parseResult(RecordParser rp) {
        }
    }

    public static class TxnVerify
    extends AsyncBaseCommand {
        private final long version;
        private final BatchRecord record;

        public TxnVerify(AsyncBatchExecutor executor, Cluster cluster, BatchPolicy policy, long version, BatchRecord record, Node node) {
            super(executor, cluster, policy, record.key, node, false);
            this.version = version;
            this.record = record;
        }

        @Override
        protected void writeBuffer() {
            this.setTxnVerify(this.record.key, this.version);
        }

        @Override
        protected boolean parseResult() {
            RecordParser rp = new RecordParser(this.dataBuffer, this.dataOffset, this.receiveSize);
            if (rp.resultCode == 0) {
                this.record.resultCode = rp.resultCode;
            } else {
                this.record.setError(rp.resultCode, false);
                this.executor.setRowError();
            }
            return true;
        }

        @Override
        protected void parseResult(RecordParser rp) {
        }
    }

    public static class Delete
    extends AsyncBaseCommand {
        private final BatchAttr attr;
        final BatchRecord record;

        public Delete(AsyncBatchExecutor executor, Cluster cluster, BatchPolicy policy, BatchAttr attr, BatchRecord record, Node node) {
            super(executor, cluster, policy, record.key, node, true);
            this.attr = attr;
            this.record = record;
        }

        @Override
        protected void writeBuffer() {
            this.setDelete(this.policy, this.record.key, this.attr);
        }

        @Override
        protected void parseResult(RecordParser rp) {
            if (rp.resultCode == 0) {
                this.record.setRecord(new Record(null, rp.generation, rp.expiration));
            } else {
                this.record.setError(rp.resultCode, Command.batchInDoubt(true, this.commandSentCounter));
                this.executor.setRowError();
            }
        }

        @Override
        public void setInDoubt() {
            if (this.record.resultCode == -15) {
                this.record.inDoubt = true;
            }
        }
    }

    public static final class DeleteSequence
    extends Delete {
        private final BatchRecordSequenceListener listener;
        private final int index;

        public DeleteSequence(AsyncBatchExecutor executor, Cluster cluster, BatchPolicy policy, BatchAttr attr, BatchRecord record, Node node, BatchRecordSequenceListener listener, int index2) {
            super(executor, cluster, policy, attr, record, node);
            this.listener = listener;
            this.index = index2;
        }

        @Override
        protected void parseResult(RecordParser rp) {
            super.parseResult(rp);
            AsyncBatch.onRecord(this.listener, this.record, this.index);
        }
    }

    public static final class DeleteSequenceSent
    extends AsyncBaseCommand {
        private final AsyncBatchExecutor.BatchRecordSequence parent;
        private final BatchRecordSequenceListener listener;
        private final BatchAttr attr;
        private final int index;

        public DeleteSequenceSent(AsyncBatchExecutor.BatchRecordSequence executor, Cluster cluster, BatchPolicy policy, Key key, BatchAttr attr, Node node, BatchRecordSequenceListener listener, int index2) {
            super(executor, cluster, policy, key, node, true);
            this.parent = executor;
            this.listener = listener;
            this.attr = attr;
            this.index = index2;
        }

        @Override
        protected void writeBuffer() {
            this.setDelete(this.policy, this.key, this.attr);
        }

        @Override
        protected void parseResult(RecordParser rp) {
            BatchRecord record;
            if (rp.resultCode == 0) {
                record = new BatchRecord(this.key, new Record(null, rp.generation, rp.expiration), true);
            } else {
                record = new BatchRecord(this.key, null, rp.resultCode, Command.batchInDoubt(true, this.commandSentCounter), true);
                this.executor.setRowError();
            }
            this.parent.setSent(this.index);
            AsyncBatch.onRecord(this.listener, record, this.index);
        }

        @Override
        public void setInDoubt() {
            if (!this.parent.exchangeSent(this.index)) {
                BatchRecord record = new BatchRecord(this.key, null, -15, true, true);
                AsyncBatch.onRecord(this.listener, record, this.index);
            }
        }
    }

    public static class UDFCommand
    extends AsyncBaseCommand {
        private final BatchAttr attr;
        private final BatchRecord record;
        private final String packageName;
        private final String functionName;
        private final byte[] argBytes;

        public UDFCommand(AsyncBatchExecutor executor, Cluster cluster, BatchPolicy policy, BatchAttr attr, BatchRecord record, String packageName, String functionName, byte[] argBytes, Node node) {
            super(executor, cluster, policy, record.key, node, true);
            this.attr = attr;
            this.record = record;
            this.packageName = packageName;
            this.functionName = functionName;
            this.argBytes = argBytes;
        }

        @Override
        protected void writeBuffer() {
            this.setUdf(this.policy, this.attr, this.key, this.packageName, this.functionName, this.argBytes);
        }

        @Override
        protected void parseResult(RecordParser rp) {
            if (rp.resultCode == 0) {
                this.record.setRecord(rp.parseRecord(false));
            } else if (rp.resultCode == 100) {
                Record r = rp.parseRecord(false);
                String m = r.getString("FAILURE");
                if (m != null) {
                    this.record.record = r;
                }
                this.record.resultCode = rp.resultCode;
                this.record.inDoubt = Command.batchInDoubt(true, this.commandSentCounter);
                this.executor.setRowError();
            } else {
                this.record.setError(rp.resultCode, Command.batchInDoubt(true, this.commandSentCounter));
                this.executor.setRowError();
            }
        }

        @Override
        public void setInDoubt() {
            if (this.record.resultCode == -15) {
                this.record.inDoubt = true;
            }
        }
    }

    public static final class UDFSequenceCommand
    extends AsyncBaseCommand {
        private final AsyncBatchExecutor.BatchRecordSequence parent;
        private final BatchRecordSequenceListener listener;
        private final BatchAttr attr;
        private final String packageName;
        private final String functionName;
        private final byte[] argBytes;
        private final int index;

        public UDFSequenceCommand(AsyncBatchExecutor.BatchRecordSequence executor, Cluster cluster, BatchPolicy policy, Key key, BatchAttr attr, String packageName, String functionName, byte[] argBytes, Node node, BatchRecordSequenceListener listener, int index2) {
            super(executor, cluster, policy, key, node, true);
            this.parent = executor;
            this.listener = listener;
            this.attr = attr;
            this.packageName = packageName;
            this.functionName = functionName;
            this.argBytes = argBytes;
            this.index = index2;
        }

        @Override
        protected void writeBuffer() {
            this.setUdf(this.policy, this.attr, this.key, this.packageName, this.functionName, this.argBytes);
        }

        @Override
        protected void parseResult(RecordParser rp) {
            BatchRecord record;
            if (rp.resultCode == 0) {
                record = new BatchRecord(this.key, rp.parseRecord(true), this.attr.hasWrite);
            } else if (rp.resultCode == 100) {
                Record r = rp.parseRecord(false);
                String m = r.getString("FAILURE");
                record = m != null ? new BatchRecord(this.key, r, rp.resultCode, Command.batchInDoubt(true, this.commandSentCounter), true) : new BatchRecord(this.key, null, rp.resultCode, Command.batchInDoubt(true, this.commandSentCounter), true);
                this.executor.setRowError();
            } else {
                record = new BatchRecord(this.key, null, rp.resultCode, Command.batchInDoubt(true, this.commandSentCounter), true);
                this.executor.setRowError();
            }
            this.parent.setSent(this.index);
            AsyncBatch.onRecord(this.listener, record, this.index);
        }

        @Override
        public void setInDoubt() {
            if (!this.parent.exchangeSent(this.index)) {
                BatchRecord record = new BatchRecord(this.key, null, -15, true, true);
                AsyncBatch.onRecord(this.listener, record, this.index);
            }
        }
    }

    public static class UDF
    extends AsyncBaseCommand {
        private final BatchAttr attr;
        final BatchUDF record;

        public UDF(AsyncBatchExecutor executor, Cluster cluster, BatchPolicy policy, BatchAttr attr, BatchUDF record, Node node) {
            super(executor, cluster, policy, record.key, node, true);
            this.attr = attr;
            this.record = record;
        }

        @Override
        protected void writeBuffer() {
            this.setUdf(this.policy, this.attr, this.record.key, this.record.packageName, this.record.functionName, this.record.functionArgs);
        }

        @Override
        protected void parseResult(RecordParser rp) {
            if (rp.resultCode == 0) {
                this.record.setRecord(rp.parseRecord(false));
            } else if (rp.resultCode == 100) {
                Record r = rp.parseRecord(false);
                String m = r.getString("FAILURE");
                if (m != null) {
                    this.record.record = r;
                }
                this.record.resultCode = rp.resultCode;
                this.record.inDoubt = Command.batchInDoubt(true, this.commandSentCounter);
                this.executor.setRowError();
            } else {
                this.record.setError(rp.resultCode, Command.batchInDoubt(true, this.commandSentCounter));
                this.executor.setRowError();
            }
        }

        @Override
        public void setInDoubt() {
            if (this.record.resultCode == -15) {
                this.record.inDoubt = true;
            }
        }
    }

    public static final class UDFSequence
    extends UDF {
        private final BatchRecordSequenceListener listener;
        private final int index;

        public UDFSequence(AsyncBatchExecutor executor, Cluster cluster, BatchPolicy policy, BatchAttr attr, BatchUDF record, Node node, BatchRecordSequenceListener listener, int index2) {
            super(executor, cluster, policy, attr, record, node);
            this.listener = listener;
            this.index = index2;
        }

        @Override
        protected void parseResult(RecordParser rp) {
            super.parseResult(rp);
            AsyncBatch.onRecord(this.listener, this.record, this.index);
        }
    }

    public static class Write
    extends AsyncBaseCommand {
        private final BatchAttr attr;
        final BatchWrite record;

        public Write(AsyncBatchExecutor executor, Cluster cluster, BatchPolicy policy, BatchAttr attr, BatchWrite record, Node node) {
            super(executor, cluster, policy, record.key, node, true);
            this.attr = attr;
            this.record = record;
        }

        @Override
        protected void writeBuffer() {
            this.setOperate(this.policy, this.attr, this.record.key, this.record.ops);
        }

        @Override
        protected void parseResult(RecordParser rp) {
            if (rp.resultCode == 0) {
                this.record.setRecord(rp.parseRecord(true));
            } else {
                this.record.setError(rp.resultCode, Command.batchInDoubt(true, this.commandSentCounter));
                this.executor.setRowError();
            }
        }

        @Override
        public void setInDoubt() {
            if (this.record.resultCode == -15) {
                this.record.inDoubt = true;
            }
        }
    }

    public static final class WriteSequence
    extends Write {
        private final BatchRecordSequenceListener listener;
        private final int index;

        public WriteSequence(AsyncBatchExecutor executor, Cluster cluster, BatchPolicy policy, BatchAttr attr, BatchWrite record, Node node, BatchRecordSequenceListener listener, int index2) {
            super(executor, cluster, policy, attr, record, node);
            this.listener = listener;
            this.index = index2;
        }

        @Override
        protected void parseResult(RecordParser rp) {
            super.parseResult(rp);
            AsyncBatch.onRecord(this.listener, this.record, this.index);
        }
    }

    public static final class Operate
    extends AsyncBaseCommand {
        private final BatchAttr attr;
        private final BatchRecord record;
        private final Operation[] ops;

        public Operate(AsyncBatchExecutor executor, Cluster cluster, BatchPolicy policy, BatchAttr attr, BatchRecord record, Operation[] ops, Node node) {
            super(executor, cluster, policy, record.key, node, attr.hasWrite);
            this.attr = attr;
            this.record = record;
            this.ops = ops;
        }

        @Override
        protected void writeBuffer() {
            this.setOperate(this.policy, this.attr, this.record.key, this.ops);
        }

        @Override
        protected void parseResult(RecordParser rp) {
            if (rp.resultCode == 0) {
                this.record.setRecord(rp.parseRecord(true));
            } else {
                this.record.setError(rp.resultCode, Command.batchInDoubt(this.attr.hasWrite, this.commandSentCounter));
                this.executor.setRowError();
            }
        }

        @Override
        public void setInDoubt() {
            if (this.record.resultCode == -15) {
                this.record.inDoubt = true;
            }
        }
    }

    public static final class OperateSequence
    extends AsyncBaseCommand {
        private final AsyncBatchExecutor.BatchRecordSequence parent;
        private final BatchRecordSequenceListener listener;
        private final BatchAttr attr;
        private final Operation[] ops;
        private final int index;

        public OperateSequence(AsyncBatchExecutor.BatchRecordSequence executor, Cluster cluster, BatchPolicy policy, Key key, BatchAttr attr, Operation[] ops, Node node, BatchRecordSequenceListener listener, int index2) {
            super(executor, cluster, policy, key, node, attr.hasWrite);
            this.parent = executor;
            this.listener = listener;
            this.attr = attr;
            this.ops = ops;
            this.index = index2;
        }

        @Override
        protected void writeBuffer() {
            this.setOperate(this.policy, this.attr, this.key, this.ops);
        }

        @Override
        protected void parseResult(RecordParser rp) {
            BatchRecord record;
            if (rp.resultCode == 0) {
                record = new BatchRecord(this.key, rp.parseRecord(true), this.attr.hasWrite);
            } else {
                record = new BatchRecord(this.key, null, rp.resultCode, Command.batchInDoubt(this.attr.hasWrite, this.commandSentCounter), this.attr.hasWrite);
                this.executor.setRowError();
            }
            this.parent.setSent(this.index);
            AsyncBatch.onRecord(this.listener, record, this.index);
        }

        @Override
        public void setInDoubt() {
            if (!this.parent.exchangeSent(this.index)) {
                BatchRecord record = new BatchRecord(this.key, null, -15, true, this.attr.hasWrite);
                AsyncBatch.onRecord(this.listener, record, this.index);
            }
        }
    }

    public static final class Exists
    extends AsyncBaseCommand {
        private final boolean[] existsArray;
        private final int index;

        public Exists(AsyncBatchExecutor executor, Cluster cluster, BatchPolicy policy, Key key, Node node, boolean[] existsArray, int index2) {
            super(executor, cluster, policy, key, node, false);
            this.existsArray = existsArray;
            this.index = index2;
        }

        @Override
        protected void writeBuffer() {
            this.setExists(this.policy, this.key);
        }

        @Override
        protected void parseResult(RecordParser rp) {
            this.existsArray[this.index] = rp.resultCode == 0;
        }
    }

    public static final class ExistsSequence
    extends AsyncBaseCommand {
        private final ExistsSequenceListener listener;

        public ExistsSequence(AsyncBatchExecutor executor, Cluster cluster, BatchPolicy policy, Key key, Node node, ExistsSequenceListener listener) {
            super(executor, cluster, policy, key, node, false);
            this.listener = listener;
        }

        @Override
        protected void writeBuffer() {
            this.setExists(this.policy, this.key);
        }

        @Override
        protected void parseResult(RecordParser rp) {
            try {
                this.listener.onExists(this.key, rp.resultCode == 0);
            }
            catch (Throwable e) {
                Log.error("Unexpected exception from onExists(): " + Util.getErrorMessage(e));
            }
        }
    }

    public static class ReadHeader
    extends AsyncBaseCommand {
        private final Record[] records;
        private final int index;

        public ReadHeader(AsyncBatchExecutor executor, Cluster cluster, BatchPolicy policy, Key key, Record[] records, Node node, int index2) {
            super(executor, cluster, policy, key, node, false);
            this.records = records;
            this.index = index2;
        }

        @Override
        protected void writeBuffer() {
            this.setReadHeader(this.policy, this.key);
        }

        @Override
        protected void parseResult(RecordParser rp) {
            if (rp.resultCode == 0) {
                this.records[this.index] = rp.parseRecord(false);
            }
        }
    }

    public static class ReadHeaderSequence
    extends AsyncBaseCommand {
        private final RecordSequenceListener listener;

        public ReadHeaderSequence(AsyncBatchExecutor executor, Cluster cluster, BatchPolicy policy, Key key, Node node, RecordSequenceListener listener) {
            super(executor, cluster, policy, key, node, false);
            this.listener = listener;
        }

        @Override
        protected void writeBuffer() {
            this.setReadHeader(this.policy, this.key);
        }

        @Override
        protected void parseResult(RecordParser rp) {
            Record record = null;
            if (rp.resultCode == 0) {
                record = rp.parseRecord(false);
            }
            AsyncBatch.onRecord(this.listener, this.key, record);
        }
    }

    public static class GetSequence
    extends AsyncBaseCommand {
        private final RecordSequenceListener listener;
        private final String[] binNames;
        private final boolean isOperation;

        public GetSequence(AsyncBatchExecutor executor, Cluster cluster, BatchPolicy policy, RecordSequenceListener listener, Key key, String[] binNames, Node node, boolean isOperation) {
            super(executor, cluster, policy, key, node, false);
            this.listener = listener;
            this.binNames = binNames;
            this.isOperation = isOperation;
        }

        @Override
        protected void writeBuffer() {
            this.setRead(this.policy, this.key, this.binNames);
        }

        @Override
        protected void parseResult(RecordParser rp) {
            Record record = null;
            if (rp.resultCode == 0) {
                record = rp.parseRecord(this.isOperation);
            }
            AsyncBatch.onRecord(this.listener, this.key, record);
        }
    }

    public static final class OperateGetSequence
    extends GetSequence {
        private final Operation[] ops;

        public OperateGetSequence(AsyncBatchExecutor executor, Cluster cluster, BatchPolicy policy, RecordSequenceListener listener, Key key, Operation[] ops, Node node) {
            super(executor, cluster, policy, listener, key, null, node, true);
            this.ops = ops;
        }

        @Override
        protected void writeBuffer() {
            this.setRead(this.policy, this.key, this.ops);
        }
    }

    public static class Get
    extends AsyncBaseCommand {
        private final String[] binNames;
        private final Record[] records;
        private final int index;
        private final boolean isOperation;

        public Get(AsyncBatchExecutor executor, Cluster cluster, BatchPolicy policy, Key key, String[] binNames, Record[] records, Node node, int index2, boolean isOperation) {
            super(executor, cluster, policy, key, node, false);
            this.binNames = binNames;
            this.records = records;
            this.index = index2;
            this.isOperation = isOperation;
        }

        @Override
        protected void writeBuffer() {
            this.setRead(this.policy, this.key, this.binNames);
        }

        @Override
        protected void parseResult(RecordParser rp) {
            if (rp.resultCode == 0) {
                this.records[this.index] = rp.parseRecord(this.isOperation);
            }
        }
    }

    public static final class OperateGet
    extends Get {
        private final Operation[] ops;

        public OperateGet(AsyncBatchExecutor executor, Cluster cluster, BatchPolicy policy, Key key, Operation[] ops, Record[] records, Node node, int index2) {
            super(executor, cluster, policy, key, null, records, node, index2, true);
            this.ops = ops;
        }

        @Override
        protected void writeBuffer() {
            this.setRead(this.policy, this.key, this.ops);
        }
    }

    public static class Read
    extends AsyncBaseCommand {
        final BatchRead record;

        public Read(AsyncBatchExecutor executor, Cluster cluster, BatchPolicy policy, BatchRead record, Node node) {
            super(executor, cluster, policy, record.key, node, false);
            this.record = record;
        }

        @Override
        protected void writeBuffer() {
            this.setRead(this.policy, this.record);
        }

        @Override
        protected void parseResult(RecordParser rp) {
            if (rp.resultCode == 0) {
                this.record.setRecord(rp.parseRecord(this.record.ops != null));
            } else {
                this.record.setError(rp.resultCode, false);
                this.executor.setRowError();
            }
        }
    }

    public static final class ReadSequence
    extends Read {
        private final BatchRecordSequenceListener listener;
        private final int index;

        public ReadSequence(AsyncBatchExecutor executor, Cluster cluster, BatchPolicy policy, BatchRead record, Node node, BatchRecordSequenceListener listener, int index2) {
            super(executor, cluster, policy, record, node);
            this.listener = listener;
            this.index = index2;
        }

        @Override
        protected void parseResult(RecordParser rp) {
            super.parseResult(rp);
            AsyncBatch.onRecord(this.listener, this.record, this.index);
        }
    }

    public static final class ReadGetSequence
    extends Read {
        private final BatchSequenceListener listener;

        public ReadGetSequence(AsyncBatchExecutor executor, Cluster cluster, BatchPolicy policy, BatchRead record, Node node, BatchSequenceListener listener) {
            super(executor, cluster, policy, record, node);
            this.listener = listener;
        }

        @Override
        protected void parseResult(RecordParser rp) {
            super.parseResult(rp);
            try {
                this.listener.onRecord(this.record);
            }
            catch (Throwable e) {
                Log.error("Unexpected exception from onRecord(): " + Util.getErrorMessage(e));
            }
        }
    }
}

