/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.async.AsyncReadBase;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.command.RecordParser;
import com.aerospike.client.listener.RecordListener;
import com.aerospike.client.policy.Policy;

public final class AsyncReadHeader
extends AsyncReadBase {
    private final RecordListener listener;
    private Record record;

    public AsyncReadHeader(Cluster cluster, RecordListener listener, Policy policy, Key key) {
        super(cluster, policy, key);
        this.listener = listener;
    }

    @Override
    protected void writeBuffer() {
        this.setReadHeader(this.policy, this.key);
    }

    @Override
    protected boolean parseResult() {
        RecordParser rp = new RecordParser(this.dataBuffer, this.dataOffset, this.receiveSize);
        rp.parseFields(this.policy.txn, this.key, false);
        if (rp.resultCode == 0) {
            this.record = new Record(null, rp.generation, rp.expiration);
            return true;
        }
        if (rp.resultCode == 2) {
            return true;
        }
        if (rp.resultCode == 27) {
            if (this.policy.failOnFilteredOut) {
                throw new AerospikeException(rp.resultCode);
            }
            return true;
        }
        throw new AerospikeException(rp.resultCode);
    }

    @Override
    protected void onSuccess() {
        if (this.listener != null) {
            this.listener.onSuccess(this.key, this.record);
        }
    }

    @Override
    protected void onFailure(AerospikeException e) {
        if (this.listener != null) {
            this.listener.onFailure(e);
        }
    }
}

