/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AbortStatus;
import com.aerospike.client.AerospikeException;
import com.aerospike.client.BatchRecord;
import com.aerospike.client.CommitError;
import com.aerospike.client.CommitStatus;
import com.aerospike.client.Key;
import com.aerospike.client.Log;
import com.aerospike.client.Txn;
import com.aerospike.client.async.AsyncBatch;
import com.aerospike.client.async.AsyncBatchExecutor;
import com.aerospike.client.async.AsyncBatchSingle;
import com.aerospike.client.async.AsyncCommand;
import com.aerospike.client.async.AsyncTxnClose;
import com.aerospike.client.async.AsyncTxnMarkRollForward;
import com.aerospike.client.async.EventLoop;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.command.BatchAttr;
import com.aerospike.client.command.BatchNode;
import com.aerospike.client.command.BatchNodeList;
import com.aerospike.client.command.TxnMonitor;
import com.aerospike.client.listener.AbortListener;
import com.aerospike.client.listener.BatchRecordArrayListener;
import com.aerospike.client.listener.CommitListener;
import com.aerospike.client.listener.DeleteListener;
import com.aerospike.client.listener.WriteListener;
import com.aerospike.client.policy.BatchPolicy;
import com.aerospike.client.policy.WritePolicy;
import com.aerospike.client.util.Util;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class AsyncTxnRoll {
    private final Cluster cluster;
    private final EventLoop eventLoop;
    private final BatchPolicy verifyPolicy;
    private final BatchPolicy rollPolicy;
    private final WritePolicy writePolicy;
    private final Txn txn;
    private final Key tranKey;
    private CommitListener commitListener;
    private AbortListener abortListener;
    private BatchRecord[] verifyRecords;
    private BatchRecord[] rollRecords;
    private AerospikeException verifyException;

    public AsyncTxnRoll(Cluster cluster, EventLoop eventLoop, BatchPolicy verifyPolicy, BatchPolicy rollPolicy, Txn txn) {
        this.cluster = cluster;
        this.eventLoop = eventLoop;
        this.verifyPolicy = verifyPolicy;
        this.rollPolicy = rollPolicy;
        this.writePolicy = new WritePolicy(rollPolicy);
        this.txn = txn;
        this.tranKey = TxnMonitor.getTxnMonitorKey(txn);
    }

    public void verify(CommitListener listener) {
        this.commitListener = listener;
        BatchRecordArrayListener verifyListener = new BatchRecordArrayListener(){

            @Override
            public void onSuccess(BatchRecord[] records, boolean status) {
                AsyncTxnRoll.this.verifyRecords = records;
                if (status) {
                    AsyncTxnRoll.this.txn.setState(Txn.State.VERIFIED);
                    AsyncTxnRoll.this.commit();
                } else {
                    AsyncTxnRoll.this.txn.setState(Txn.State.ABORTED);
                    AsyncTxnRoll.this.rollBack();
                }
            }

            @Override
            public void onFailure(BatchRecord[] records, AerospikeException ae) {
                AsyncTxnRoll.this.verifyRecords = records;
                AsyncTxnRoll.this.verifyException = ae;
                AsyncTxnRoll.this.txn.setState(Txn.State.ABORTED);
                AsyncTxnRoll.this.rollBack();
            }
        };
        this.verify(verifyListener);
    }

    public void commit(CommitListener listener) {
        this.commitListener = listener;
        this.commit();
    }

    private void commit() {
        if (this.txn.monitorExists()) {
            this.markRollForward();
        } else {
            this.txn.setState(Txn.State.COMMITTED);
            this.closeOnCommit(true);
        }
    }

    public void abort(AbortListener listener) {
        this.abortListener = listener;
        this.txn.setState(Txn.State.ABORTED);
        BatchRecordArrayListener rollListener = new BatchRecordArrayListener(){

            @Override
            public void onSuccess(BatchRecord[] records, boolean status) {
                AsyncTxnRoll.this.rollRecords = records;
                if (status) {
                    AsyncTxnRoll.this.closeOnAbort();
                } else {
                    AsyncTxnRoll.this.notifyAbortSuccess(AbortStatus.ROLL_BACK_ABANDONED);
                }
            }

            @Override
            public void onFailure(BatchRecord[] records, AerospikeException ae) {
                AsyncTxnRoll.this.rollRecords = records;
                AsyncTxnRoll.this.notifyAbortSuccess(AbortStatus.ROLL_BACK_ABANDONED);
            }
        };
        this.roll(rollListener, 4);
    }

    private void verify(BatchRecordArrayListener verifyListener) {
        Set<Map.Entry<Key, Long>> reads = this.txn.getReads();
        int max = reads.size();
        if (max == 0) {
            verifyListener.onSuccess(new BatchRecord[0], true);
            return;
        }
        BatchRecord[] records = new BatchRecord[max];
        Key[] keys = new Key[max];
        Long[] versions = new Long[max];
        int count = 0;
        for (Map.Entry<Key, Long> entry : reads) {
            Key key;
            keys[count] = key = entry.getKey();
            records[count] = new BatchRecord(key, false);
            versions[count] = entry.getValue();
            ++count;
        }
        AsyncBatchExecutor.BatchRecordArray executor = new AsyncBatchExecutor.BatchRecordArray(this.eventLoop, this.cluster, verifyListener, records);
        List<BatchNode> bns = BatchNodeList.generate(this.cluster, this.verifyPolicy, keys, records, false, executor);
        AsyncCommand[] commands = new AsyncCommand[bns.size()];
        count = 0;
        for (BatchNode bn : bns) {
            if (bn.offsetsSize == 1) {
                int i = bn.offsets[0];
                commands[count++] = new AsyncBatchSingle.TxnVerify((AsyncBatchExecutor)executor, this.cluster, this.verifyPolicy, versions[i], records[i], bn.node);
                continue;
            }
            commands[count++] = new AsyncBatch.TxnVerify(executor, bn, this.verifyPolicy, keys, versions, records);
        }
        executor.execute(commands);
    }

    private void markRollForward() {
        try {
            WriteListener writeListener = new WriteListener(){

                @Override
                public void onSuccess(Key key) {
                    AsyncTxnRoll.this.txn.setState(Txn.State.COMMITTED);
                    AsyncTxnRoll.this.txn.setInDoubt(false);
                    AsyncTxnRoll.this.rollForward();
                }

                @Override
                public void onFailure(AerospikeException ae) {
                    AsyncTxnRoll.this.notifyMarkRollForwardFailure(CommitError.MARK_ROLL_FORWARD_ABANDONED, ae);
                }
            };
            AsyncTxnMarkRollForward command = new AsyncTxnMarkRollForward(this.cluster, writeListener, this.writePolicy, this.tranKey);
            this.eventLoop.execute(this.cluster, command);
        }
        catch (Throwable t) {
            this.notifyMarkRollForwardFailure(CommitError.MARK_ROLL_FORWARD_ABANDONED, t);
        }
    }

    private void rollForward() {
        try {
            BatchRecordArrayListener rollListener = new BatchRecordArrayListener(){

                @Override
                public void onSuccess(BatchRecord[] records, boolean status) {
                    AsyncTxnRoll.this.rollRecords = records;
                    if (status) {
                        AsyncTxnRoll.this.closeOnCommit(true);
                    } else {
                        AsyncTxnRoll.this.notifyCommitSuccess(CommitStatus.ROLL_FORWARD_ABANDONED);
                    }
                }

                @Override
                public void onFailure(BatchRecord[] records, AerospikeException ae) {
                    AsyncTxnRoll.this.rollRecords = records;
                    AsyncTxnRoll.this.notifyCommitSuccess(CommitStatus.ROLL_FORWARD_ABANDONED);
                }
            };
            this.roll(rollListener, 2);
        }
        catch (Throwable t) {
            this.notifyCommitSuccess(CommitStatus.ROLL_FORWARD_ABANDONED);
        }
    }

    private void rollBack() {
        try {
            BatchRecordArrayListener rollListener = new BatchRecordArrayListener(){

                @Override
                public void onSuccess(BatchRecord[] records, boolean status) {
                    AsyncTxnRoll.this.rollRecords = records;
                    if (status) {
                        AsyncTxnRoll.this.closeOnCommit(false);
                    } else {
                        AsyncTxnRoll.this.notifyCommitFailure(CommitError.VERIFY_FAIL_ABORT_ABANDONED, null);
                    }
                }

                @Override
                public void onFailure(BatchRecord[] records, AerospikeException ae) {
                    AsyncTxnRoll.this.rollRecords = records;
                    AsyncTxnRoll.this.notifyCommitFailure(CommitError.VERIFY_FAIL_ABORT_ABANDONED, ae);
                }
            };
            this.roll(rollListener, 4);
        }
        catch (Throwable t) {
            this.notifyCommitFailure(CommitError.VERIFY_FAIL_ABORT_ABANDONED, t);
        }
    }

    private void roll(BatchRecordArrayListener rollListener, int txnAttr) {
        Set<Key> keySet = this.txn.getWrites();
        if (keySet.isEmpty()) {
            rollListener.onSuccess(new BatchRecord[0], true);
            return;
        }
        Key[] keys = keySet.toArray(new Key[keySet.size()]);
        BatchRecord[] records = new BatchRecord[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            records[i] = new BatchRecord(keys[i], true);
        }
        BatchAttr attr = new BatchAttr();
        attr.setTxn(txnAttr);
        AsyncBatchExecutor.BatchRecordArray executor = new AsyncBatchExecutor.BatchRecordArray(this.eventLoop, this.cluster, rollListener, records);
        List<BatchNode> bns = BatchNodeList.generate(this.cluster, this.rollPolicy, keys, records, true, executor);
        AsyncCommand[] commands = new AsyncCommand[bns.size()];
        int count = 0;
        for (BatchNode bn : bns) {
            if (bn.offsetsSize == 1) {
                int i = bn.offsets[0];
                commands[count++] = new AsyncBatchSingle.TxnRoll(executor, this.cluster, this.rollPolicy, this.txn, records[i], bn.node, txnAttr);
                continue;
            }
            commands[count++] = new AsyncBatch.TxnRoll(executor, bn, this.rollPolicy, this.txn, keys, records, attr);
        }
        executor.execute(commands);
    }

    private void closeOnCommit(final boolean verified) {
        if (!this.txn.closeMonitor()) {
            if (verified) {
                this.notifyCommitSuccess(CommitStatus.OK);
            } else {
                this.notifyCommitFailure(CommitError.VERIFY_FAIL, null);
            }
            return;
        }
        try {
            DeleteListener deleteListener = new DeleteListener(){

                @Override
                public void onSuccess(Key key, boolean existed) {
                    if (verified) {
                        AsyncTxnRoll.this.notifyCommitSuccess(CommitStatus.OK);
                    } else {
                        AsyncTxnRoll.this.notifyCommitFailure(CommitError.VERIFY_FAIL, null);
                    }
                }

                @Override
                public void onFailure(AerospikeException ae) {
                    if (verified) {
                        AsyncTxnRoll.this.notifyCommitSuccess(CommitStatus.CLOSE_ABANDONED);
                    } else {
                        AsyncTxnRoll.this.notifyCommitFailure(CommitError.VERIFY_FAIL_CLOSE_ABANDONED, ae);
                    }
                }
            };
            AsyncTxnClose command = new AsyncTxnClose(this.cluster, this.txn, deleteListener, this.writePolicy, this.tranKey);
            this.eventLoop.execute(this.cluster, command);
        }
        catch (Throwable t) {
            if (verified) {
                this.notifyCommitSuccess(CommitStatus.CLOSE_ABANDONED);
            }
            this.notifyCommitFailure(CommitError.VERIFY_FAIL_CLOSE_ABANDONED, t);
        }
    }

    private void closeOnAbort() {
        if (!this.txn.closeMonitor()) {
            this.notifyAbortSuccess(AbortStatus.OK);
            return;
        }
        try {
            DeleteListener deleteListener = new DeleteListener(){

                @Override
                public void onSuccess(Key key, boolean existed) {
                    AsyncTxnRoll.this.notifyAbortSuccess(AbortStatus.OK);
                }

                @Override
                public void onFailure(AerospikeException ae) {
                    AsyncTxnRoll.this.notifyAbortSuccess(AbortStatus.CLOSE_ABANDONED);
                }
            };
            AsyncTxnClose command = new AsyncTxnClose(this.cluster, this.txn, deleteListener, this.writePolicy, this.tranKey);
            this.eventLoop.execute(this.cluster, command);
        }
        catch (Throwable t) {
            this.notifyAbortSuccess(AbortStatus.CLOSE_ABANDONED);
        }
    }

    private void notifyCommitSuccess(CommitStatus status) {
        this.txn.clear();
        try {
            this.commitListener.onSuccess(status);
        }
        catch (Throwable t) {
            Log.error("CommitListener onSuccess() failed: " + Util.getStackTrace(t));
        }
    }

    private void notifyCommitFailure(CommitError error, Throwable cause) {
        AerospikeException.Commit aec = this.createCommitException(error, cause);
        if (this.verifyException != null) {
            aec.addSuppressed(this.verifyException);
        }
        this.notifyCommitFailure(aec);
    }

    private void notifyMarkRollForwardFailure(CommitError error, Throwable cause) {
        AerospikeException.Commit aec = this.createCommitException(error, cause);
        if (cause instanceof AerospikeException) {
            AerospikeException ae = (AerospikeException)cause;
            if (ae.getResultCode() == 125) {
                aec.setInDoubt(false);
                this.txn.setInDoubt(false);
                this.txn.setState(Txn.State.ABORTED);
            } else if (this.txn.getInDoubt()) {
                aec.setInDoubt(true);
            } else if (ae.getInDoubt()) {
                aec.setInDoubt(true);
                this.txn.setInDoubt(true);
            }
        } else if (this.txn.getInDoubt()) {
            aec.setInDoubt(true);
        }
        this.notifyCommitFailure(aec);
    }

    private AerospikeException.Commit createCommitException(CommitError error, Throwable cause) {
        if (cause != null) {
            AerospikeException.Commit aec = new AerospikeException.Commit(error, this.verifyRecords, this.rollRecords, cause);
            if (cause instanceof AerospikeException) {
                AerospikeException src = (AerospikeException)cause;
                aec.setNode(src.getNode());
                aec.setPolicy(src.getPolicy());
                aec.setIteration(src.getIteration());
                aec.setInDoubt(src.getInDoubt());
            }
            return aec;
        }
        return new AerospikeException.Commit(error, this.verifyRecords, this.rollRecords);
    }

    private void notifyCommitFailure(AerospikeException.Commit aec) {
        try {
            this.commitListener.onFailure(aec);
        }
        catch (Throwable t) {
            Log.error("CommitListener onFailure() failed: " + Util.getStackTrace(t));
        }
    }

    private void notifyAbortSuccess(AbortStatus status) {
        this.txn.clear();
        try {
            this.abortListener.onSuccess(status);
        }
        catch (Throwable t) {
            Log.error("AbortListener onSuccess() failed: " + Util.getStackTrace(t));
        }
    }
}

