/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.cluster;

import com.aerospike.client.AerospikeClient;
import com.aerospike.client.AerospikeException;
import com.aerospike.client.Host;
import com.aerospike.client.Log;
import com.aerospike.client.admin.AdminCommand;
import com.aerospike.client.async.EventLoop;
import com.aerospike.client.async.EventLoopStats;
import com.aerospike.client.async.EventLoops;
import com.aerospike.client.async.EventState;
import com.aerospike.client.async.Monitor;
import com.aerospike.client.async.NettyTlsContext;
import com.aerospike.client.async.NioEventLoops;
import com.aerospike.client.cluster.ClusterStats;
import com.aerospike.client.cluster.ConnectionRecover;
import com.aerospike.client.cluster.ConnectionStats;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.cluster.NodeStats;
import com.aerospike.client.cluster.NodeValidator;
import com.aerospike.client.cluster.Partitions;
import com.aerospike.client.cluster.Peers;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.configuration.ConfigurationProvider;
import com.aerospike.client.configuration.YamlConfigProvider;
import com.aerospike.client.configuration.serializers.Configuration;
import com.aerospike.client.configuration.serializers.StaticConfiguration;
import com.aerospike.client.configuration.serializers.staticconfig.StaticClientConfig;
import com.aerospike.client.listener.ClusterStatsListener;
import com.aerospike.client.metrics.MetricsListener;
import com.aerospike.client.metrics.MetricsPolicy;
import com.aerospike.client.metrics.MetricsWriter;
import com.aerospike.client.policy.AuthMode;
import com.aerospike.client.policy.ClientPolicy;
import com.aerospike.client.policy.TCPKeepAlive;
import com.aerospike.client.policy.TlsPolicy;
import com.aerospike.client.util.ThreadLocalData;
import com.aerospike.client.util.Util;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class Cluster
implements Runnable,
Closeable {
    private static final long MAX_SOCKET_IDLE_TRIM_DEFAULT_SECS = 55L;
    private static final int DEFAULT_CONFIG_INTERVAL_MS = 60000;
    private static final int TEND_INTERVAL_MIN_MS = 250;
    public final AerospikeClient client;
    private Configuration config;
    protected final String clusterName;
    private volatile Host[] seeds;
    protected final HashMap<String, Node> nodesMap;
    private volatile Node[] nodes;
    public volatile HashMap<String, Partitions> partitionMap;
    protected final Map<String, String> ipMap;
    public final TlsPolicy tlsPolicy;
    public final NettyTlsContext nettyTlsContext;
    public final AuthMode authMode;
    protected final byte[] user;
    private byte[] password;
    private byte[] passwordHash;
    private final AtomicInteger nodeIndex;
    final AtomicInteger replicaIndex;
    private final AtomicInteger recoverCount;
    private final ConcurrentLinkedDeque<ConnectionRecover> recoverQueue;
    public final ThreadFactory threadFactory;
    public final TCPKeepAlive keepAlive;
    public final EventLoops eventLoops;
    public final EventState[] eventState;
    private long maxSocketIdleNanosTran;
    private long maxSocketIdleNanosTrim;
    protected int minConnsPerNode;
    protected int maxConnsPerNode;
    protected final int asyncMinConnsPerNode;
    protected final int asyncMaxConnsPerNode;
    protected final int connPoolsPerNode;
    int maxErrorRate;
    int errorRateWindow;
    public int connectTimeout;
    public int loginTimeout;
    public final int closeTimeout;
    public int[] rackIds;
    private volatile int invalidNodeCount;
    private int tendInterval;
    private int tendCount;
    public final int configInterval;
    private final String configPath;
    private AtomicBoolean closed;
    private Thread tendThread;
    protected volatile boolean tendValid;
    protected boolean useServicesAlternate;
    boolean rackAware;
    public final boolean validateClusterName;
    public final boolean authEnabled;
    public boolean hasPartitionQuery;
    private boolean asyncComplete;
    public boolean metricsEnabled;
    MetricsPolicy metricsPolicy;
    private volatile MetricsListener metricsListener;
    private final Object metricsLock = new Object();
    private final AtomicLong retryCount = new AtomicLong();
    private final AtomicLong commandCount = new AtomicLong();
    private final AtomicLong delayQueueTimeoutCount = new AtomicLong();

    public Cluster(AerospikeClient client, ClientPolicy policy, String configPath, Host[] hosts) {
        this.client = client;
        this.configPath = configPath;
        this.clusterName = policy.clusterName;
        this.validateClusterName = policy.validateClusterName;
        this.tlsPolicy = policy.tlsPolicy;
        this.authMode = policy.authMode;
        if (this.tlsPolicy != null) {
            boolean useClusterName = this.clusterName != null && this.clusterName.length() > 0;
            for (int i = 0; i < hosts.length; ++i) {
                Host host = hosts[i];
                if (host.tlsName != null) continue;
                String tlsName = useClusterName ? this.clusterName : host.name;
                hosts[i] = new Host(host.name, tlsName, host.port);
            }
        } else if (this.authMode == AuthMode.EXTERNAL || this.authMode == AuthMode.PKI) {
            throw new AerospikeException("TLS is required for authentication mode: " + String.valueOf((Object)this.authMode));
        }
        this.seeds = hosts;
        if (policy.authMode == AuthMode.PKI) {
            if (policy.password != null) {
                throw new AerospikeException("Password authentication is disabled for PKI-only users");
            }
            this.authEnabled = true;
            this.user = null;
        } else if (policy.user != null && policy.user.length() > 0) {
            String pass;
            this.authEnabled = true;
            this.user = Buffer.stringToUtf8(policy.user);
            if (this.authMode != AuthMode.INTERNAL) {
                this.password = Buffer.stringToUtf8(policy.password);
            }
            if ((pass = policy.password) == null) {
                pass = "";
            }
            pass = AdminCommand.hashPassword(pass);
            this.passwordHash = Buffer.stringToUtf8(pass);
        } else {
            this.authEnabled = false;
            this.user = null;
        }
        this.minConnsPerNode = policy.minConnsPerNode;
        this.maxConnsPerNode = policy.maxConnsPerNode;
        if (this.minConnsPerNode > this.maxConnsPerNode) {
            throw new AerospikeException("Invalid connection range: " + this.minConnsPerNode + " - " + this.maxConnsPerNode);
        }
        this.asyncMinConnsPerNode = policy.asyncMinConnsPerNode;
        int n = this.asyncMaxConnsPerNode = policy.asyncMaxConnsPerNode >= 0 ? policy.asyncMaxConnsPerNode : policy.maxConnsPerNode;
        if (this.asyncMinConnsPerNode > this.asyncMaxConnsPerNode) {
            throw new AerospikeException("Invalid async connection range: " + this.asyncMinConnsPerNode + " - " + this.asyncMaxConnsPerNode);
        }
        this.connPoolsPerNode = policy.connPoolsPerNode;
        int configIntervalDuration = 60000;
        if (client.getConfigProvider() != null) {
            StaticClientConfig staCC;
            StaticConfiguration sConfig;
            this.config = client.getConfigProvider().fetchConfiguration();
            if (this.config != null && (sConfig = this.config.getStaticConfiguration()) != null && (staCC = sConfig.getStaticClientConfig()) != null && staCC.configInterval != null) {
                configIntervalDuration = staCC.configInterval.value;
            }
        }
        this.configInterval = configIntervalDuration;
        this.applyCommonClientPolicyParameters(policy, true);
        this.closeTimeout = policy.closeTimeout;
        this.ipMap = policy.ipMap;
        this.keepAlive = policy.keepAlive;
        this.threadFactory = Thread.ofVirtual().name("Aerospike-", 0L).factory();
        this.nodesMap = new HashMap();
        this.nodes = new Node[0];
        this.partitionMap = new HashMap();
        this.nodeIndex = new AtomicInteger();
        this.replicaIndex = new AtomicInteger();
        this.recoverCount = new AtomicInteger();
        this.recoverQueue = new ConcurrentLinkedDeque();
        this.closed = new AtomicBoolean();
        this.eventLoops = policy.eventLoops;
        if (this.eventLoops != null) {
            EventLoop[] loops = this.eventLoops.getArray();
            if (this.asyncMaxConnsPerNode < loops.length) {
                throw new AerospikeException("asyncMaxConnsPerNode " + this.asyncMaxConnsPerNode + " must be >= event loop count " + loops.length);
            }
            this.eventState = new EventState[loops.length];
            for (int i = 0; i < loops.length; ++i) {
                this.eventState[i] = loops[i].createState();
            }
            if (policy.tlsPolicy != null) {
                if (this.eventLoops instanceof NioEventLoops) {
                    throw new AerospikeException("TLS not supported in direct NIO event loops");
                }
                this.nettyTlsContext = policy.tlsPolicy.nettyContext != null ? policy.tlsPolicy.nettyContext : new NettyTlsContext(policy.tlsPolicy);
            } else {
                this.nettyTlsContext = null;
            }
        } else {
            this.eventState = null;
            this.nettyTlsContext = null;
        }
        if (policy.forceSingleNode) {
            try {
                this.forceSingleNode();
            }
            catch (Throwable e) {
                this.close();
                throw e;
            }
        } else {
            this.initTendThread(policy.failIfNotConnected);
        }
    }

    private void applyCommonClientPolicyParameters(ClientPolicy clientPolicy, boolean init) {
        if (clientPolicy.tendInterval < 250) {
            throw new AerospikeException("Invalid tendInterval: " + clientPolicy.tendInterval + ". min: 250");
        }
        if (this.configInterval < clientPolicy.tendInterval) {
            throw new AerospikeException("Dynamic config interval " + this.configInterval + " must be greater or equal to the tend interval " + clientPolicy.tendInterval);
        }
        this.tendInterval = clientPolicy.tendInterval;
        this.connectTimeout = clientPolicy.timeout;
        this.loginTimeout = clientPolicy.loginTimeout;
        if (clientPolicy.maxSocketIdle < 0) {
            throw new AerospikeException("Invalid maxSocketIdle: " + clientPolicy.maxSocketIdle);
        }
        if (clientPolicy.maxSocketIdle == 0) {
            this.maxSocketIdleNanosTran = 0L;
            this.maxSocketIdleNanosTrim = TimeUnit.SECONDS.toNanos(55L);
        } else {
            this.maxSocketIdleNanosTrim = this.maxSocketIdleNanosTran = TimeUnit.SECONDS.toNanos(clientPolicy.maxSocketIdle);
        }
        this.useServicesAlternate = clientPolicy.useServicesAlternate;
        this.rackAware = clientPolicy.rackAware;
        this.errorRateWindow = clientPolicy.errorRateWindow;
        if (this.maxErrorRate != clientPolicy.maxErrorRate) {
            this.maxErrorRate = clientPolicy.maxErrorRate;
            if (!init) {
                for (Node node : this.nodes) {
                    node.maxErrorRate = this.maxErrorRate;
                }
            }
        }
        if (init || !Util.rackIdsEqual(clientPolicy.rackIds, this.rackIds)) {
            int[] rackIdsTemp;
            if (clientPolicy.rackIds != null && !clientPolicy.rackIds.isEmpty()) {
                List<Integer> list = clientPolicy.rackIds;
                int max = list.size();
                rackIdsTemp = new int[max];
                for (int i = 0; i < max; ++i) {
                    rackIdsTemp[i] = list.get(i);
                }
            } else {
                rackIdsTemp = new int[]{clientPolicy.rackId};
            }
            this.rackIds = rackIdsTemp;
            if (!init) {
                for (Node node : this.nodes) {
                    if (this.rackAware && node.racks == null) {
                        node.racks = new HashMap<String, Integer>();
                        continue;
                    }
                    if (this.rackAware || node.racks == null) continue;
                    node.racks = null;
                }
            }
        }
    }

    public void forceSingleNode() {
        this.tendValid = true;
        this.tendThread = new Thread(this);
        Host seed = this.seeds[0];
        NodeValidator nv = new NodeValidator();
        Node node = null;
        try {
            node = nv.seedNode(this, seed, null);
        }
        catch (Throwable e) {
            throw new AerospikeException("Seed " + String.valueOf(seed) + " failed: " + e.getMessage(), e);
        }
        node.createMinConnections();
        HashMap<String, Node> nodesToAdd = new HashMap<String, Node>(1);
        nodesToAdd.put(node.getName(), node);
        this.addNodes(nodesToAdd);
        Peers peers = new Peers(this.nodes.length + 16);
        node.refreshPartitions(peers);
        for (Partitions partitions : this.partitionMap.values()) {
            for (AtomicReferenceArray<Node> nodeArray : partitions.replicas) {
                int max = nodeArray.length();
                for (int i = 0; i < max; ++i) {
                    nodeArray.set(i, node);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initTendThread(boolean failIfNotConnected) {
        this.waitTillStabilized(failIfNotConnected);
        if (Log.debugEnabled()) {
            for (Host host : this.seeds) {
                Log.debug("Add seed " + String.valueOf(host));
            }
        }
        ArrayList<Host> seedsToAdd = new ArrayList<Host>(this.nodes.length);
        for (Node node : this.nodes) {
            Host host = node.getHost();
            if (this.findSeed(host)) continue;
            seedsToAdd.add(host);
        }
        if (seedsToAdd.size() > 0) {
            this.addSeeds(seedsToAdd.toArray(new Host[seedsToAdd.size()]));
        }
        if (this.config != null && this.config.hasMetrics() && this.config.dynamicConfiguration.dynamicMetricsConfig.enable != null && this.config.dynamicConfiguration.dynamicMetricsConfig.enable.value) {
            Object object = this.metricsLock;
            synchronized (object) {
                this.enableMetricsInternal(this.metricsPolicy);
            }
        }
        this.tendValid = true;
        this.tendThread = new Thread(this);
        this.tendThread.setName("tend");
        this.tendThread.setDaemon(true);
        this.tendThread.start();
    }

    public final void addSeeds(Host[] hosts) {
        Host[] seedArray = new Host[this.seeds.length + hosts.length];
        int count = 0;
        for (Host seed : this.seeds) {
            seedArray[count++] = seed;
        }
        for (Host host : hosts) {
            if (Log.debugEnabled()) {
                Log.debug("Add seed " + String.valueOf(host));
            }
            seedArray[count++] = host;
        }
        this.seeds = seedArray;
    }

    private final boolean findSeed(Host search) {
        for (Host seed : this.seeds) {
            if (!seed.equals(search)) continue;
            return true;
        }
        return false;
    }

    private final void waitTillStabilized(boolean failIfNotConnected) {
        this.tend(failIfNotConnected, true);
        if (this.nodes.length == 0) {
            String message = "Cluster seed(s) failed";
            if (failIfNotConnected) {
                throw new AerospikeException(message);
            }
            Log.warn(message);
        }
    }

    @Override
    public final void run() {
        while (this.tendValid) {
            block3: {
                try {
                    this.tend(false, false);
                }
                catch (Throwable e) {
                    if (!Log.warnEnabled()) break block3;
                    Log.warn("Cluster tend failed: " + Util.getErrorMessage(e));
                }
            }
            Util.sleep(this.tendInterval);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void tend(boolean failIfNotConnected, boolean isInit) {
        block24: {
            Peers peers = new Peers(this.nodes.length + 16);
            for (Node node : this.nodes) {
                node.referenceCount = 0;
                node.partitionChanged = false;
                node.rebalanceChanged = false;
            }
            if (this.nodes.length == 0) {
                this.seedNode(peers, failIfNotConnected);
                if (isInit && failIfNotConnected && this.nodes.length == 1 && peers.getInvalidCount() > 0) {
                    peers.clusterInitError();
                }
            } else {
                for (Node node : this.nodes) {
                    node.refresh(peers);
                }
                if (peers.genChanged) {
                    peers.refreshCount = 0;
                    for (Node node : this.nodes) {
                        node.refreshPeers(peers);
                    }
                    this.findNodesToRemove(peers);
                    if (peers.removeNodes.size() > 0) {
                        this.removeNodes(peers.removeNodes);
                    }
                }
                if (peers.nodes.size() > 0) {
                    this.addNodes(peers.nodes);
                    this.refreshPeers(peers);
                }
            }
            this.invalidNodeCount += peers.getInvalidCount();
            for (Node node : this.nodes) {
                if (node.partitionChanged) {
                    node.refreshPartitions(peers);
                }
                if (!node.rebalanceChanged) continue;
                node.refreshRacks();
            }
            ++this.tendCount;
            if (this.tendCount % 30 == 0) {
                for (Node node : this.nodes) {
                    node.balanceConnections();
                }
                if (this.eventState != null) {
                    for (EventState eventState : this.eventState) {
                        final EventLoop eventLoop = eventState.eventLoop;
                        eventLoop.execute(new Runnable(){

                            @Override
                            public void run() {
                                block3: {
                                    try {
                                        Node[] nodeArray;
                                        for (Node node : nodeArray = Cluster.this.nodes) {
                                            node.balanceAsyncConnections(eventLoop);
                                        }
                                    }
                                    catch (Throwable e) {
                                        if (!Log.warnEnabled()) break block3;
                                        Log.warn("balanceAsyncConnections failed: " + Util.getErrorMessage(e));
                                    }
                                }
                            }
                        });
                    }
                }
            }
            if (this.tendCount % this.errorRateWindow == 0) {
                for (Node node : this.nodes) {
                    node.resetErrorRate();
                }
            }
            Object object = this.metricsLock;
            synchronized (object) {
                if (this.metricsEnabled && this.tendCount % this.metricsPolicy.interval == 0) {
                    this.metricsListener.onSnapshot(this);
                }
            }
            int n = this.configInterval / this.tendInterval;
            if (this.configPath != null && this.tendCount % n == 0) {
                try {
                    this.loadConfiguration();
                }
                catch (Throwable t) {
                    if (!Log.warnEnabled()) break block24;
                    Log.warn("Dynamic configuration failed: " + String.valueOf(t));
                }
            }
        }
        this.processRecoverQueue();
    }

    private final boolean seedNode(Peers peers, boolean failIfNotConnected) {
        Host[] seedArray = this.seeds;
        Exception[] exceptions = null;
        NodeValidator nv = new NodeValidator();
        for (int i = 0; i < seedArray.length; ++i) {
            Host seed = seedArray[i];
            try {
                Node node = nv.seedNode(this, seed, peers);
                if (node == null) continue;
                this.addSeedAndPeers(node, peers);
                return true;
            }
            catch (Throwable e) {
                peers.fail(seed);
                if (seed.tlsName != null && this.tlsPolicy == null) {
                    throw new AerospikeException.Connection("Seed host tlsName '" + seed.tlsName + "' defined but client tlsPolicy not enabled", e);
                }
                if (failIfNotConnected) {
                    if (exceptions == null) {
                        exceptions = new Exception[seedArray.length];
                    }
                    exceptions[i] = e;
                    continue;
                }
                if (!Log.warnEnabled()) continue;
                Log.warn("Seed " + String.valueOf(seed) + " failed: " + Util.getErrorMessage(e));
            }
        }
        if (nv.fallback != null) {
            peers.refreshCount = 1;
            this.addSeedAndPeers(nv.fallback, peers);
            return true;
        }
        if (failIfNotConnected) {
            StringBuilder sb = new StringBuilder(500);
            sb.append("Failed to connect to [" + seedArray.length + "] host(s): ");
            sb.append(System.lineSeparator());
            for (int i = 0; i < seedArray.length; ++i) {
                Exception ex;
                sb.append(seedArray[i]);
                sb.append(' ');
                Exception exception = ex = exceptions == null ? null : exceptions[i];
                if (ex == null) continue;
                sb.append(ex.getMessage());
                sb.append(System.lineSeparator());
            }
            throw new AerospikeException.Connection(sb.toString());
        }
        return false;
    }

    private void addSeedAndPeers(Node seed, Peers peers) {
        seed.createMinConnections();
        this.nodesMap.clear();
        this.addNodes(seed, peers);
        if (peers.nodes.size() > 0) {
            this.refreshPeers(peers);
        }
    }

    private void refreshPeers(Peers peers) {
        while (true) {
            Node[] nodeArray = new Node[peers.nodes.size()];
            int count = 0;
            for (Node node : peers.nodes.values()) {
                nodeArray[count++] = node;
            }
            peers.nodes.clear();
            for (Node node : nodeArray) {
                node.refreshPeers(peers);
            }
            if (peers.nodes.size() <= 0) break;
            this.addNodes(peers.nodes);
        }
    }

    protected Node createNode(NodeValidator nv) {
        Node node = new Node(this, nv);
        node.createMinConnections();
        return node;
    }

    private final void findNodesToRemove(Peers peers) {
        int refreshCount = peers.refreshCount;
        HashSet<Node> removeNodes = peers.removeNodes;
        for (Node node : this.nodes) {
            if (!node.isActive()) {
                removeNodes.add(node);
                continue;
            }
            if (refreshCount == 0 && node.failures >= 5) {
                removeNodes.add(node);
                continue;
            }
            if (this.nodes.length <= 1 || refreshCount < 1 || node.referenceCount != 0) continue;
            if (node.failures == 0) {
                if (this.findNodeInPartitionMap(node)) continue;
                removeNodes.add(node);
                continue;
            }
            removeNodes.add(node);
        }
    }

    private final boolean findNodeInPartitionMap(Node filter) {
        for (Partitions partitions : this.partitionMap.values()) {
            for (AtomicReferenceArray<Node> nodeArray : partitions.replicas) {
                int max = nodeArray.length();
                for (int i = 0; i < max; ++i) {
                    Node node = nodeArray.get(i);
                    if (node != filter) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void addNodes(Node seed, Peers peers) {
        Node[] nodeArray = new Node[peers.nodes.size() + 1];
        int count = 0;
        nodeArray[count++] = seed;
        this.addNode(seed);
        for (Node peer : peers.nodes.values()) {
            nodeArray[count++] = peer;
            this.addNode(peer);
        }
        this.hasPartitionQuery = Cluster.supportsPartitionQuery(nodeArray);
        this.nodes = nodeArray;
    }

    private final void addNodes(HashMap<String, Node> nodesToAdd) {
        Node[] nodeArray = new Node[this.nodes.length + nodesToAdd.size()];
        int count = 0;
        for (Node node : this.nodes) {
            nodeArray[count++] = node;
        }
        for (Node node : nodesToAdd.values()) {
            nodeArray[count++] = node;
            this.addNode(node);
        }
        this.hasPartitionQuery = Cluster.supportsPartitionQuery(nodeArray);
        this.nodes = nodeArray;
    }

    private final void addNode(Node node) {
        if (Log.infoEnabled()) {
            Log.info("Add node " + String.valueOf(node));
        }
        this.nodesMap.put(node.getName(), node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void removeNodes(HashSet<Node> nodesToRemove) {
        for (Node node : nodesToRemove) {
            this.nodesMap.remove(node.getName());
            Object object = this.metricsLock;
            synchronized (object) {
                if (this.metricsEnabled) {
                    try {
                        this.metricsListener.onNodeClose(node);
                    }
                    catch (Throwable e) {
                        Log.warn("Write metrics failed on " + String.valueOf(node) + ": " + Util.getErrorMessage(e));
                    }
                }
            }
            node.close();
        }
        this.removeNodesCopy(nodesToRemove);
    }

    private final void removeNodesCopy(HashSet<Node> nodesToRemove) {
        Node[] nodeArray = new Node[this.nodes.length - nodesToRemove.size()];
        int count = 0;
        for (Node node : this.nodes) {
            if (nodesToRemove.contains(node)) {
                if (!Log.infoEnabled()) continue;
                Log.info("Remove node " + String.valueOf(node));
                continue;
            }
            nodeArray[count++] = node;
        }
        if (count < nodeArray.length) {
            if (Log.warnEnabled()) {
                Log.warn("Node remove mismatch. Expected " + nodeArray.length + " Received " + count);
            }
            Node[] nodeArray2 = new Node[count];
            System.arraycopy(nodeArray, 0, nodeArray2, 0, count);
            nodeArray = nodeArray2;
        }
        this.hasPartitionQuery = Cluster.supportsPartitionQuery(nodeArray);
        this.nodes = nodeArray;
    }

    public final boolean isConnected() {
        Node[] nodeArray = this.nodes;
        if (nodeArray.length > 0 && this.tendValid) {
            for (Node node : nodeArray) {
                if (!node.active || node.failures >= 5) continue;
                return true;
            }
        }
        return false;
    }

    public final Node getRandomNode() throws AerospikeException.InvalidNode {
        Node[] nodeArray = this.nodes;
        if (nodeArray.length > 0) {
            int index2 = Math.abs(this.nodeIndex.getAndIncrement() % nodeArray.length);
            for (int i = 0; i < nodeArray.length; ++i) {
                Node node = nodeArray[index2];
                if (node.isActive()) {
                    return node;
                }
                ++index2;
                index2 %= nodeArray.length;
            }
        }
        throw new AerospikeException.InvalidNode("Cluster is empty");
    }

    public final Node[] getNodes() {
        Node[] nodeArray = this.nodes;
        return nodeArray;
    }

    public final Node[] validateNodes() {
        Node[] nodeArray = this.nodes;
        if (nodeArray.length == 0) {
            throw new AerospikeException(-8, "Cluster is empty");
        }
        return nodeArray;
    }

    public final Node getNode(String nodeName) throws AerospikeException.InvalidNode {
        Node node = this.findNode(nodeName);
        if (node == null) {
            throw new AerospikeException.InvalidNode("Invalid node name: " + nodeName);
        }
        return node;
    }

    protected final Node findNode(String nodeName) {
        Node[] nodeArray;
        for (Node node : nodeArray = this.nodes) {
            if (!node.getName().equals(nodeName)) continue;
            return node;
        }
        return null;
    }

    public final boolean isConnCurrentTran(long lastUsed) {
        return this.maxSocketIdleNanosTran == 0L || System.nanoTime() - lastUsed <= this.maxSocketIdleNanosTran;
    }

    public final boolean isConnCurrentTrim(long lastUsed) {
        return System.nanoTime() - lastUsed <= this.maxSocketIdleNanosTrim;
    }

    public final void recoverConnection(ConnectionRecover cs) {
        if (cs.isComplete()) {
            return;
        }
        if (this.recoverCount.getAndIncrement() < 10000) {
            this.recoverQueue.offerLast(cs);
        } else {
            this.recoverCount.getAndDecrement();
            cs.abort();
        }
    }

    private void processRecoverQueue() {
        ConnectionRecover cs;
        ConnectionRecover last = this.recoverQueue.peekLast();
        if (last == null) {
            return;
        }
        byte[] buf = ThreadLocalData.getBuffer();
        while ((cs = this.recoverQueue.pollFirst()) != null) {
            if (cs.drain(buf)) {
                this.recoverCount.getAndDecrement();
            } else {
                this.recoverQueue.offerLast(cs);
            }
            if (cs != last) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfiguration() {
        ConfigurationProvider provider = this.client.getConfigProvider();
        if (provider == null) {
            provider = YamlConfigProvider.getConfigProvider(this.configPath);
            if (provider == null) {
                return;
            }
            this.client.setConfigProvider(provider);
        } else if (!provider.loadConfiguration()) {
            return;
        }
        this.config = provider.fetchConfiguration();
        this.client.mergePoliciesWithConfig();
        this.applyCommonClientPolicyParameters(this.client.getClientPolicy(), false);
        Object object = this.metricsLock;
        synchronized (object) {
            this.metricsPolicy = this.mergeMetricsPolicyWithConfig(this.metricsPolicy);
            if (this.metricsEnabled && this.metricsPolicy.isMetricsRestartRequired()) {
                this.disableMetricsInternal();
                this.enableMetricsInternal(this.metricsPolicy);
                this.metricsPolicy.setMetricsRestartRequired(false);
                return;
            }
            if (this.config != null && this.config.hasMetrics() && this.config.dynamicConfiguration.dynamicMetricsConfig.enable != null) {
                if (!this.metricsEnabled && this.config.dynamicConfiguration.dynamicMetricsConfig.enable.value) {
                    this.enableMetricsInternal(this.metricsPolicy);
                } else if (this.metricsEnabled && !this.config.dynamicConfiguration.dynamicMetricsConfig.enable.value) {
                    this.disableMetricsInternal();
                }
            }
        }
    }

    private MetricsPolicy mergeMetricsPolicyWithConfig(MetricsPolicy mp) {
        if (mp == null) {
            mp = new MetricsPolicy();
        }
        return new MetricsPolicy(mp, this.config, this.metricsEnabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void enableMetrics(MetricsPolicy policy) {
        if (this.config != null && this.config.hasMetrics() && this.config.dynamicConfiguration.dynamicMetricsConfig.enable != null && !this.config.dynamicConfiguration.dynamicMetricsConfig.enable.value) {
            Log.warn("When a config exists, metrics can not be enabled via enableMetrics unless they are enabled in the config provider.");
            this.metricsPolicy = this.mergeMetricsPolicyWithConfig(policy);
            return;
        }
        Object object = this.metricsLock;
        synchronized (object) {
            this.enableMetricsInternal(policy);
        }
    }

    private void enableMetricsInternal(MetricsPolicy policy) {
        Node[] nodeArray;
        MetricsPolicy mergedMP = this.mergeMetricsPolicyWithConfig(policy);
        MetricsListener listener = mergedMP.listener;
        if (listener == null) {
            listener = new MetricsWriter(mergedMP.reportDir);
        }
        this.metricsListener = listener;
        this.metricsPolicy = mergedMP;
        if (this.metricsEnabled) {
            this.metricsListener.onDisable(this);
        }
        for (Node node : nodeArray = this.nodes) {
            node.enableMetrics(this.metricsPolicy);
        }
        this.metricsListener.onEnable(this, this.metricsPolicy);
        this.metricsEnabled = true;
        Log.info("Metrics have been enabled.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void disableMetrics() {
        if (this.config != null && this.config.hasMetrics() && this.config.dynamicConfiguration.dynamicMetricsConfig.enable != null && this.config.dynamicConfiguration.dynamicMetricsConfig.enable.value) {
            Log.warn("Metrics can not be disabled via disableMetrics() when they are enabled via config.");
            return;
        }
        Object object = this.metricsLock;
        synchronized (object) {
            this.disableMetricsInternal();
        }
    }

    private void disableMetricsInternal() {
        if (this.metricsEnabled) {
            this.metricsEnabled = false;
            this.metricsListener.onDisable(this);
            Log.info("Metrics have been disabled.");
        }
    }

    public EventLoop[] getEventLoopArray() {
        if (this.eventLoops == null) {
            return null;
        }
        return this.eventLoops.getArray();
    }

    public final ClusterStats getStats() {
        final Node[] nodeArray = this.nodes;
        NodeStats[] nodeStats = new NodeStats[nodeArray.length];
        int count = 0;
        for (Node node : nodeArray) {
            nodeStats[count++] = new NodeStats(node);
        }
        EventLoopStats[] eventLoopStats = null;
        if (this.eventLoops != null) {
            EventLoop[] eventLoopArray;
            for (EventLoop eventLoop : eventLoopArray = this.eventLoops.getArray()) {
                int i;
                if (!eventLoop.inEventLoop()) continue;
                eventLoopStats = new EventLoopStats[eventLoopArray.length];
                for (i = 0; i < eventLoopArray.length; ++i) {
                    eventLoopStats[i] = new EventLoopStats(eventLoopArray[i]);
                }
                for (i = 0; i < nodeArray.length; ++i) {
                    nodeStats[i].async = nodeArray[i].getAsyncConnectionStats();
                }
                return new ClusterStats(this, nodeStats, eventLoopStats);
            }
            final EventLoopStats[] loopStats = new EventLoopStats[eventLoopArray.length];
            final ConnectionStats[][] connStats = new ConnectionStats[nodeArray.length][eventLoopArray.length];
            final AtomicInteger eventLoopCount = new AtomicInteger(eventLoopArray.length);
            final Monitor monitor = new Monitor();
            for (final EventLoop eventLoop : eventLoopArray) {
                eventLoop.execute(new Runnable(){

                    @Override
                    public void run() {
                        int index2 = eventLoop.getIndex();
                        loopStats[index2] = new EventLoopStats(eventLoop);
                        for (int i = 0; i < nodeArray.length; ++i) {
                            Node.AsyncPool pool = nodeArray[i].getAsyncPool(index2);
                            int inPool = pool.queue.size();
                            connStats[i][index2] = new ConnectionStats(pool.total - inPool, inPool, pool.opened, pool.closed);
                        }
                        if (eventLoopCount.decrementAndGet() == 0) {
                            monitor.notifyComplete();
                        }
                    }
                });
            }
            monitor.waitTillComplete();
            eventLoopStats = loopStats;
            for (int i = 0; i < nodeArray.length; ++i) {
                int inUse = 0;
                int inPool = 0;
                int opened = 0;
                int closed = 0;
                for (EventLoop eventLoop : eventLoopArray) {
                    ConnectionStats cs = connStats[i][eventLoop.getIndex()];
                    inUse += cs.inUse;
                    inPool += cs.inPool;
                    opened += cs.opened;
                    closed += cs.closed;
                }
                nodeStats[i].async = new ConnectionStats(inUse, inPool, opened, closed);
            }
        }
        return new ClusterStats(this, nodeStats, eventLoopStats);
    }

    public final void getStats(final ClusterStatsListener listener) {
        try {
            final Node[] nodeArray = this.nodes;
            final NodeStats[] nodeStats = new NodeStats[nodeArray.length];
            int count = 0;
            for (Node node : nodeArray) {
                nodeStats[count++] = new NodeStats(node);
            }
            if (this.eventLoops == null) {
                try {
                    listener.onSuccess(new ClusterStats(this, nodeStats, null));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return;
            }
            final EventLoop[] eventLoopArray = this.eventLoops.getArray();
            final EventLoopStats[] loopStats = new EventLoopStats[eventLoopArray.length];
            final ConnectionStats[][] connStats = new ConnectionStats[nodeArray.length][eventLoopArray.length];
            final AtomicInteger eventLoopCount = new AtomicInteger(eventLoopArray.length);
            final Cluster cluster = this;
            for (final EventLoop eventLoop : eventLoopArray) {
                Runnable fetch = new Runnable(){

                    @Override
                    public void run() {
                        int inPool;
                        int i;
                        int index2 = eventLoop.getIndex();
                        loopStats[index2] = new EventLoopStats(eventLoop);
                        for (i = 0; i < nodeArray.length; ++i) {
                            Node.AsyncPool pool = nodeArray[i].getAsyncPool(index2);
                            inPool = pool.queue.size();
                            connStats[i][index2] = new ConnectionStats(pool.total - inPool, inPool, pool.opened, pool.closed);
                        }
                        if (eventLoopCount.decrementAndGet() == 0) {
                            for (i = 0; i < nodeArray.length; ++i) {
                                int inUse = 0;
                                inPool = 0;
                                int opened = 0;
                                int closed = 0;
                                for (EventLoop eventLoop2 : eventLoopArray) {
                                    ConnectionStats cs = connStats[i][eventLoop2.getIndex()];
                                    inUse += cs.inUse;
                                    inPool += cs.inPool;
                                    opened += cs.opened;
                                    closed += cs.closed;
                                }
                                nodeStats[i].async = new ConnectionStats(inUse, inPool, opened, closed);
                            }
                            try {
                                listener.onSuccess(new ClusterStats(cluster, nodeStats, loopStats));
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }
                };
                if (eventLoop.inEventLoop()) {
                    fetch.run();
                    continue;
                }
                eventLoop.execute(fetch);
            }
        }
        catch (AerospikeException ae) {
            listener.onFailure(ae);
        }
        catch (Throwable e) {
            listener.onFailure(new AerospikeException(e));
        }
    }

    public final void interruptTendSleep() {
        this.tendThread.interrupt();
    }

    public final void printPartitionMap() {
        for (Map.Entry<String, Partitions> entry : this.partitionMap.entrySet()) {
            String namespace = entry.getKey();
            Partitions partitions = entry.getValue();
            AtomicReferenceArray<Node>[] replicas = partitions.replicas;
            for (int i = 0; i < replicas.length; ++i) {
                AtomicReferenceArray<Node> nodeArray = replicas[i];
                int max = nodeArray.length();
                for (int j = 0; j < max; ++j) {
                    Node node = nodeArray.get(j);
                    if (node == null) continue;
                    Log.info(namespace + "," + i + "," + j + "," + String.valueOf(node));
                }
            }
        }
    }

    public void changePassword(byte[] user, byte[] password, byte[] passwordHash) {
        if (this.user != null && Arrays.equals(user, this.user)) {
            this.passwordHash = passwordHash;
            if (this.authMode != AuthMode.INTERNAL) {
                this.password = password;
            }
        }
    }

    public final void setMaxErrorRate(int rate) {
        this.maxErrorRate = rate;
    }

    public final void setErrorRateWindow(int window) {
        this.errorRateWindow = window;
    }

    private static boolean supportsPartitionQuery(Node[] nodes) {
        if (nodes.length == 0) {
            return false;
        }
        for (Node node : nodes) {
            if (node.hasPartitionQuery()) continue;
            return false;
        }
        return true;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public boolean validateClusterName() {
        return this.validateClusterName && this.clusterName != null && this.clusterName.length() > 0;
    }

    public final byte[] getUser() {
        return this.user;
    }

    public final byte[] getPassword() {
        return this.password;
    }

    public final byte[] getPasswordHash() {
        return this.passwordHash;
    }

    public final boolean isActive() {
        return this.tendValid;
    }

    public final void addCommandCount() {
        if (this.metricsEnabled) {
            this.commandCount.getAndIncrement();
        }
    }

    public final long getCommandCount() {
        return this.commandCount.get();
    }

    public final long getTranCount() {
        return this.commandCount.get();
    }

    public final void addRetry() {
        this.retryCount.getAndIncrement();
    }

    public final void addRetries(int count) {
        this.retryCount.getAndAdd(count);
    }

    public final long getRetryCount() {
        return this.retryCount.get();
    }

    public final void addDelayQueueTimeout() {
        this.delayQueueTimeoutCount.getAndIncrement();
    }

    public final long getDelayQueueTimeoutCount() {
        return this.delayQueueTimeoutCount.get();
    }

    public final int getRecoverQueueSize() {
        return this.recoverCount.get();
    }

    public final int getInvalidNodeCount() {
        return this.invalidNodeCount;
    }

    public MetricsPolicy getMetricsPolicy() {
        return this.metricsPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        this.tendValid = false;
        this.tendThread.interrupt();
        Object object = this.metricsLock;
        synchronized (object) {
            try {
                this.disableMetricsInternal();
            }
            catch (Throwable e) {
                Log.warn("DisableMetrics failed: " + Util.getErrorMessage(e));
            }
        }
        if (this.eventLoops == null) {
            Node[] nodeArray;
            for (Node node : nodeArray = this.nodes) {
                node.closeSyncConnections();
            }
        } else {
            final long deadline = this.closeTimeout > 0 ? System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(this.closeTimeout) : 0L;
            final AtomicInteger eventLoopCount = new AtomicInteger(this.eventState.length);
            final AtomicBoolean closedWithPending = new AtomicBoolean();
            boolean inEventLoop = false;
            for (final EventState state : this.eventState) {
                if (state.eventLoop.inEventLoop()) {
                    inEventLoop = true;
                }
                state.eventLoop.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (state.closed) {
                            return;
                        }
                        if (state.pending > 0) {
                            if (Cluster.this.closeTimeout >= 0 && (Cluster.this.closeTimeout == 0 || deadline - System.nanoTime() > 0L)) {
                                state.eventLoop.schedule(this, 200L, TimeUnit.MILLISECONDS);
                                return;
                            }
                            closedWithPending.set(true);
                        }
                        Cluster.this.closeEventLoop(eventLoopCount, state);
                    }
                });
            }
            if (!inEventLoop) {
                this.waitAsyncComplete();
            }
            if (closedWithPending.get()) {
                Log.warn("Cluster closed with pending async commands");
            }
        }
    }

    private final void closeEventLoop(AtomicInteger eventLoopCount, EventState state) {
        Node[] nodeArray;
        state.closed = true;
        for (Node node : nodeArray = this.nodes) {
            node.closeAsyncConnections(state.index);
        }
        if (eventLoopCount.decrementAndGet() == 0) {
            for (Node node : nodeArray) {
                node.closeSyncConnections();
            }
            this.notifyAsyncComplete();
        }
    }

    private synchronized void waitAsyncComplete() {
        while (!this.asyncComplete) {
            try {
                super.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private synchronized void notifyAsyncComplete() {
        this.asyncComplete = true;
        super.notify();
    }
}

