/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.cluster;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Info;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.Buffer;
import java.util.HashMap;

public final class RackParser
extends Info {
    static final String RebalanceGeneration = "rebalance-generation";
    static final String RackIds = "rack-ids";
    private final HashMap<String, Integer> racks;
    private final int generation;

    public RackParser(Node node, Connection conn) {
        super(node, conn, RebalanceGeneration, RackIds);
        if (this.length == 0) {
            throw new AerospikeException.Parse("rack-ids response is empty");
        }
        this.racks = new HashMap();
        this.generation = this.parseGeneration();
        this.parseRacks();
    }

    public int getGeneration() {
        return this.generation;
    }

    public HashMap<String, Integer> getRacks() {
        return this.racks;
    }

    private int parseGeneration() {
        this.parseName(RebalanceGeneration);
        int gen = this.parseInt();
        this.expect('\n');
        return gen;
    }

    private void parseRacks() {
        this.parseName(RackIds);
        int begin = this.offset;
        while (this.offset < this.length) {
            if (this.buffer[this.offset] == 58) {
                byte b;
                String namespace = Buffer.utf8ToString(this.buffer, begin, this.offset - begin).trim();
                if (namespace.length() <= 0 || namespace.length() >= 32) {
                    String response = this.getTruncatedResponse();
                    throw new AerospikeException.Parse("Invalid racks namespace " + namespace + ". Response=" + response);
                }
                begin = ++this.offset;
                while (this.offset < this.length && (b = this.buffer[this.offset]) != 59 && b != 10) {
                    ++this.offset;
                }
                int rack = Integer.parseInt(new String(this.buffer, begin, this.offset - begin));
                this.racks.put(namespace, rack);
                begin = ++this.offset;
                continue;
            }
            ++this.offset;
        }
    }
}

