/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeClient;
import com.aerospike.client.AerospikeException;
import com.aerospike.client.BatchRead;
import com.aerospike.client.BatchRecord;
import com.aerospike.client.Key;
import com.aerospike.client.Operation;
import com.aerospike.client.Record;
import com.aerospike.client.Txn;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.command.BatchAttr;
import com.aerospike.client.command.BatchNode;
import com.aerospike.client.command.BatchNodeList;
import com.aerospike.client.command.BatchStatus;
import com.aerospike.client.command.Command;
import com.aerospike.client.command.IBatchCommand;
import com.aerospike.client.command.MultiCommand;
import com.aerospike.client.configuration.ConfigurationProvider;
import com.aerospike.client.metrics.LatencyType;
import com.aerospike.client.policy.BatchPolicy;
import com.aerospike.client.policy.ReadModeSC;
import com.aerospike.client.policy.Replica;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class Batch {

    public static abstract class BatchCommand
    extends MultiCommand
    implements IBatchCommand {
        final BatchNode batch;
        final BatchPolicy batchPolicy;
        final BatchStatus status;
        int sequenceAP;
        int sequenceSC;
        boolean splitRetry;

        public BatchCommand(Cluster cluster, BatchNode batch, BatchPolicy batchPolicy, BatchStatus status, boolean isOperation) {
            super(cluster, batchPolicy, batch.node, isOperation);
            this.batch = batch;
            this.batchPolicy = batchPolicy;
            this.status = status;
        }

        @Override
        public void run() {
            try {
                if (!this.splitRetry) {
                    this.execute();
                } else {
                    this.executeCommand();
                }
            }
            catch (AerospikeException ae) {
                if (ae.getInDoubt()) {
                    this.setInDoubt();
                }
                this.status.setException(ae);
            }
            catch (Throwable e) {
                this.setInDoubt();
                this.status.setException(new AerospikeException(e));
            }
        }

        protected final void parseFieldsRead(Key key) {
            if (this.policy.txn != null) {
                Long version = this.parseVersion(this.fieldCount);
                this.policy.txn.onRead(key, version);
            } else {
                this.skipKey(this.fieldCount);
            }
        }

        protected final void parseFields(BatchRecord br) {
            if (this.policy.txn != null) {
                Long version = this.parseVersion(this.fieldCount);
                if (br.hasWrite) {
                    this.policy.txn.onWrite(br.key, version, this.resultCode);
                } else {
                    this.policy.txn.onRead(br.key, version);
                }
            } else {
                this.skipKey(this.fieldCount);
            }
        }

        @Override
        protected void addSubException(AerospikeException ae) {
            this.status.addSubException(ae);
        }

        @Override
        protected LatencyType getLatencyType() {
            return LatencyType.BATCH;
        }

        @Override
        protected boolean prepareRetry(boolean timeout) {
            if (this.batchPolicy.replica != Replica.SEQUENCE && this.batchPolicy.replica != Replica.PREFER_RACK) {
                return true;
            }
            ++this.sequenceAP;
            if (!timeout || this.batchPolicy.readModeSC != ReadModeSC.LINEARIZE) {
                ++this.sequenceSC;
            }
            return false;
        }

        @Override
        protected boolean retryBatch(Cluster cluster, int socketTimeout, int totalTimeout, long deadline, int iteration, int commandSentCounter) {
            List<BatchNode> batchNodes = this.generateBatchNodes();
            if (batchNodes.size() == 1 && batchNodes.get((int)0).node == this.batch.node) {
                return false;
            }
            this.splitRetry = true;
            try (ExecutorService es = Executors.newThreadPerTaskExecutor(cluster.threadFactory);){
                for (BatchNode batchNode : batchNodes) {
                    BatchCommand command = this.createCommand(batchNode);
                    command.sequenceAP = this.sequenceAP;
                    command.sequenceSC = this.sequenceSC;
                    command.socketTimeout = socketTimeout;
                    command.totalTimeout = totalTimeout;
                    command.iteration = iteration;
                    command.commandSentCounter = commandSentCounter;
                    command.deadline = deadline;
                    cluster.addRetry();
                    es.execute(command);
                }
            }
            return true;
        }

        @Override
        public void setInDoubt() {
            if (!this.splitRetry) {
                this.inDoubt();
            }
        }

        protected void inDoubt() {
        }

        abstract BatchCommand createCommand(BatchNode var1);

        abstract List<BatchNode> generateBatchNodes();
    }

    public static final class TxnRoll
    extends BatchCommand {
        private final Txn txn;
        private final Key[] keys;
        private final BatchRecord[] records;
        private final BatchAttr attr;

        public TxnRoll(Cluster cluster, BatchNode batch, BatchPolicy batchPolicy, Txn txn, Key[] keys, BatchRecord[] records, BatchAttr attr, BatchStatus status) {
            super(cluster, batch, batchPolicy, status, false);
            this.txn = txn;
            this.keys = keys;
            this.records = records;
            this.attr = attr;
        }

        @Override
        protected boolean isWrite() {
            return this.attr.hasWrite;
        }

        @Override
        protected void writeBuffer() {
            this.setBatchTxnRoll(this.batchPolicy, this.txn, this.keys, this.batch, this.attr);
        }

        @Override
        protected boolean parseRow() {
            this.skipKey(this.fieldCount);
            BatchRecord record = this.records[this.batchIndex];
            if (this.resultCode == 0) {
                record.resultCode = this.resultCode;
            } else {
                record.setError(this.resultCode, Command.batchInDoubt(this.attr.hasWrite, this.commandSentCounter));
                this.status.setRowError();
            }
            return true;
        }

        @Override
        protected void inDoubt() {
            if (!this.attr.hasWrite) {
                return;
            }
            for (int index2 : this.batch.offsets) {
                BatchRecord record = this.records[index2];
                if (record.resultCode != -15) continue;
                record.inDoubt = true;
            }
        }

        @Override
        protected BatchCommand createCommand(BatchNode batchNode) {
            return new TxnRoll(this.cluster, batchNode, this.batchPolicy, this.txn, this.keys, this.records, this.attr, this.status);
        }

        @Override
        protected List<BatchNode> generateBatchNodes() {
            return BatchNodeList.generate(this.cluster, this.batchPolicy, this.keys, this.records, this.sequenceAP, this.sequenceSC, this.batch, this.attr.hasWrite, (BatchNodeList.IBatchStatus)this.status);
        }
    }

    public static final class TxnVerify
    extends BatchCommand {
        private final Key[] keys;
        private final Long[] versions;
        private final BatchRecord[] records;

        public TxnVerify(Cluster cluster, BatchNode batch, BatchPolicy batchPolicy, Key[] keys, Long[] versions, BatchRecord[] records, BatchStatus status) {
            super(cluster, batch, batchPolicy, status, false);
            this.keys = keys;
            this.versions = versions;
            this.records = records;
        }

        @Override
        protected boolean isWrite() {
            return false;
        }

        @Override
        protected void writeBuffer() {
            this.setBatchTxnVerify(this.batchPolicy, this.keys, this.versions, this.batch);
        }

        @Override
        protected boolean parseRow() {
            this.skipKey(this.fieldCount);
            BatchRecord record = this.records[this.batchIndex];
            if (this.resultCode == 0) {
                record.resultCode = this.resultCode;
            } else {
                record.setError(this.resultCode, false);
                this.status.setRowError();
            }
            return true;
        }

        @Override
        protected BatchCommand createCommand(BatchNode batchNode) {
            return new TxnVerify(this.cluster, batchNode, this.batchPolicy, this.keys, this.versions, this.records, this.status);
        }

        @Override
        protected List<BatchNode> generateBatchNodes() {
            return BatchNodeList.generate(this.cluster, this.batchPolicy, this.keys, this.records, this.sequenceAP, this.sequenceSC, this.batch, false, (BatchNodeList.IBatchStatus)this.status);
        }
    }

    public static final class UDFCommand
    extends BatchCommand {
        private final Key[] keys;
        private final String packageName;
        private final String functionName;
        private final byte[] argBytes;
        private final BatchRecord[] records;
        private final BatchAttr attr;

        public UDFCommand(Cluster cluster, BatchNode batch, BatchPolicy batchPolicy, Key[] keys, String packageName, String functionName, byte[] argBytes, BatchRecord[] records, BatchAttr attr, BatchStatus status) {
            super(cluster, batch, batchPolicy, status, false);
            this.keys = keys;
            this.packageName = packageName;
            this.functionName = functionName;
            this.argBytes = argBytes;
            this.records = records;
            this.attr = attr;
        }

        @Override
        protected boolean isWrite() {
            return this.attr.hasWrite;
        }

        @Override
        protected void writeBuffer() {
            this.setBatchUDF(this.batchPolicy, this.keys, this.batch, this.packageName, this.functionName, this.argBytes, this.attr);
        }

        @Override
        protected boolean parseRow() {
            Record r;
            String m;
            BatchRecord record = this.records[this.batchIndex];
            this.parseFields(record);
            if (this.resultCode == 0) {
                record.setRecord(this.parseRecord());
                return true;
            }
            if (this.resultCode == 100 && (m = (r = this.parseRecord()).getString("FAILURE")) != null) {
                record.record = r;
                record.resultCode = this.resultCode;
                record.inDoubt = Command.batchInDoubt(this.attr.hasWrite, this.commandSentCounter);
                this.status.setRowError();
                return true;
            }
            record.setError(this.resultCode, Command.batchInDoubt(this.attr.hasWrite, this.commandSentCounter));
            this.status.setRowError();
            return true;
        }

        @Override
        protected void inDoubt() {
            if (!this.attr.hasWrite) {
                return;
            }
            for (int index2 : this.batch.offsets) {
                BatchRecord record = this.records[index2];
                if (record.resultCode != -15) continue;
                record.inDoubt = true;
                if (this.policy.txn == null) continue;
                this.policy.txn.onWriteInDoubt(record.key);
            }
        }

        @Override
        protected BatchCommand createCommand(BatchNode batchNode) {
            return new UDFCommand(this.cluster, batchNode, this.batchPolicy, this.keys, this.packageName, this.functionName, this.argBytes, this.records, this.attr, this.status);
        }

        @Override
        protected List<BatchNode> generateBatchNodes() {
            return BatchNodeList.generate(this.cluster, this.batchPolicy, this.keys, this.records, this.sequenceAP, this.sequenceSC, this.batch, this.attr.hasWrite, (BatchNodeList.IBatchStatus)this.status);
        }
    }

    public static final class OperateArrayCommand
    extends BatchCommand {
        private final Key[] keys;
        private final Operation[] ops;
        private final BatchRecord[] records;
        private final BatchAttr attr;

        public OperateArrayCommand(Cluster cluster, BatchNode batch, BatchPolicy batchPolicy, Key[] keys, Operation[] ops, BatchRecord[] records, BatchAttr attr, BatchStatus status) {
            super(cluster, batch, batchPolicy, status, ops != null);
            this.keys = keys;
            this.ops = ops;
            this.records = records;
            this.attr = attr;
        }

        @Override
        protected boolean isWrite() {
            return this.attr.hasWrite;
        }

        @Override
        protected void writeBuffer() {
            this.setBatchOperate(this.batchPolicy, this.keys, this.batch, null, this.ops, this.attr);
        }

        @Override
        protected boolean parseRow() {
            BatchRecord record = this.records[this.batchIndex];
            this.parseFields(record);
            if (this.resultCode == 0) {
                record.setRecord(this.parseRecord());
            } else {
                record.setError(this.resultCode, Command.batchInDoubt(this.attr.hasWrite, this.commandSentCounter));
                this.status.setRowError();
            }
            return true;
        }

        @Override
        protected void inDoubt() {
            if (!this.attr.hasWrite) {
                return;
            }
            for (int index2 : this.batch.offsets) {
                BatchRecord record = this.records[index2];
                if (record.resultCode != -15) continue;
                record.inDoubt = true;
                if (this.policy.txn == null) continue;
                this.policy.txn.onWriteInDoubt(record.key);
            }
        }

        @Override
        protected BatchCommand createCommand(BatchNode batchNode) {
            return new OperateArrayCommand(this.cluster, batchNode, this.batchPolicy, this.keys, this.ops, this.records, this.attr, this.status);
        }

        @Override
        protected List<BatchNode> generateBatchNodes() {
            return BatchNodeList.generate(this.cluster, this.batchPolicy, this.keys, this.records, this.sequenceAP, this.sequenceSC, this.batch, this.attr.hasWrite, (BatchNodeList.IBatchStatus)this.status);
        }
    }

    public static final class OperateListCommand
    extends BatchCommand {
        private final List<BatchRecord> records;
        private final ConfigurationProvider configProvider;

        public OperateListCommand(Cluster cluster, BatchNode batch, BatchPolicy policy, List<BatchRecord> records, BatchStatus status, ConfigurationProvider cp) {
            super(cluster, batch, policy, status, true);
            this.records = records;
            this.configProvider = cp;
        }

        @Override
        protected boolean isWrite() {
            return true;
        }

        @Override
        protected void writeBuffer() {
            AerospikeClient client = this.cluster.client;
            this.setBatchOperate(this.batchPolicy, client.batchWritePolicyDefault, client.batchUDFPolicyDefault, client.batchDeletePolicyDefault, this.records, this.batch, this.configProvider);
        }

        @Override
        protected boolean parseRow() {
            Record r;
            String m;
            BatchRecord record = this.records.get(this.batchIndex);
            this.parseFields(record);
            if (this.resultCode == 0) {
                record.setRecord(this.parseRecord());
                return true;
            }
            if (this.resultCode == 100 && (m = (r = this.parseRecord()).getString("FAILURE")) != null) {
                record.record = r;
                record.resultCode = this.resultCode;
                record.inDoubt = Command.batchInDoubt(record.hasWrite, this.commandSentCounter);
                this.status.setRowError();
                return true;
            }
            record.setError(this.resultCode, Command.batchInDoubt(record.hasWrite, this.commandSentCounter));
            this.status.setRowError();
            return true;
        }

        @Override
        protected void inDoubt() {
            for (int index2 : this.batch.offsets) {
                BatchRecord record = this.records.get(index2);
                if (record.resultCode != -15) continue;
                record.inDoubt = record.hasWrite;
                if (!record.inDoubt || this.policy.txn == null) continue;
                this.policy.txn.onWriteInDoubt(record.key);
            }
        }

        @Override
        protected BatchCommand createCommand(BatchNode batchNode) {
            return new OperateListCommand(this.cluster, batchNode, this.batchPolicy, this.records, this.status, this.configProvider);
        }

        @Override
        protected List<BatchNode> generateBatchNodes() {
            return BatchNodeList.generate(this.cluster, this.batchPolicy, this.records, this.sequenceAP, this.sequenceSC, this.batch, this.status);
        }
    }

    public static final class ExistsArrayCommand
    extends BatchCommand {
        private final Key[] keys;
        private final boolean[] existsArray;

        public ExistsArrayCommand(Cluster cluster, BatchNode batch, BatchPolicy policy, Key[] keys, boolean[] existsArray, BatchStatus status) {
            super(cluster, batch, policy, status, false);
            this.keys = keys;
            this.existsArray = existsArray;
        }

        @Override
        protected void writeBuffer() {
            if (this.batch.node.hasBatchAny()) {
                BatchAttr attr = new BatchAttr(this.policy, 33);
                this.setBatchOperate(this.batchPolicy, this.keys, this.batch, null, null, attr);
            } else {
                this.setBatchRead(this.batchPolicy, this.keys, this.batch, null, null, 33);
            }
        }

        @Override
        protected boolean parseRow() {
            this.parseFieldsRead(this.keys[this.batchIndex]);
            this.existsArray[this.batchIndex] = this.resultCode == 0;
            return true;
        }

        @Override
        protected BatchCommand createCommand(BatchNode batchNode) {
            return new ExistsArrayCommand(this.cluster, batchNode, this.batchPolicy, this.keys, this.existsArray, this.status);
        }

        @Override
        protected List<BatchNode> generateBatchNodes() {
            return BatchNodeList.generate(this.cluster, this.batchPolicy, this.keys, this.sequenceAP, this.sequenceSC, this.batch, false, this.status);
        }
    }

    public static final class GetArrayCommand
    extends BatchCommand {
        private final Key[] keys;
        private final String[] binNames;
        private final Operation[] ops;
        private final Record[] records;
        private final int readAttr;

        public GetArrayCommand(Cluster cluster, BatchNode batch, BatchPolicy policy, Key[] keys, String[] binNames, Operation[] ops, Record[] records, int readAttr, boolean isOperation, BatchStatus status) {
            super(cluster, batch, policy, status, isOperation);
            this.keys = keys;
            this.binNames = binNames;
            this.ops = ops;
            this.records = records;
            this.readAttr = readAttr;
        }

        @Override
        protected void writeBuffer() {
            if (this.batch.node.hasBatchAny()) {
                BatchAttr attr = new BatchAttr(this.policy, this.readAttr, this.ops);
                this.setBatchOperate(this.batchPolicy, this.keys, this.batch, this.binNames, this.ops, attr);
            } else {
                this.setBatchRead(this.batchPolicy, this.keys, this.batch, this.binNames, this.ops, this.readAttr);
            }
        }

        @Override
        protected boolean parseRow() {
            this.parseFieldsRead(this.keys[this.batchIndex]);
            if (this.resultCode == 0) {
                this.records[this.batchIndex] = this.parseRecord();
            }
            return true;
        }

        @Override
        protected BatchCommand createCommand(BatchNode batchNode) {
            return new GetArrayCommand(this.cluster, batchNode, this.batchPolicy, this.keys, this.binNames, this.ops, this.records, this.readAttr, this.isOperation, this.status);
        }

        @Override
        protected List<BatchNode> generateBatchNodes() {
            return BatchNodeList.generate(this.cluster, this.batchPolicy, this.keys, this.sequenceAP, this.sequenceSC, this.batch, false, this.status);
        }
    }

    public static final class ReadListCommand
    extends BatchCommand {
        private final List<BatchRead> records;

        public ReadListCommand(Cluster cluster, BatchNode batch, BatchPolicy policy, List<BatchRead> records, BatchStatus status) {
            super(cluster, batch, policy, status, true);
            this.records = records;
        }

        @Override
        protected void writeBuffer() {
            if (this.batch.node.hasBatchAny()) {
                this.setBatchOperate(this.batchPolicy, null, null, null, this.records, this.batch, null);
            } else {
                this.setBatchRead(this.batchPolicy, this.records, this.batch);
            }
        }

        @Override
        protected boolean parseRow() {
            BatchRead record = this.records.get(this.batchIndex);
            this.parseFieldsRead(record.key);
            if (this.resultCode == 0) {
                record.setRecord(this.parseRecord());
            } else {
                record.setError(this.resultCode, false);
                this.status.setRowError();
            }
            return true;
        }

        @Override
        protected BatchCommand createCommand(BatchNode batchNode) {
            return new ReadListCommand(this.cluster, batchNode, this.batchPolicy, this.records, this.status);
        }

        @Override
        protected List<BatchNode> generateBatchNodes() {
            return BatchNodeList.generate(this.cluster, this.batchPolicy, this.records, this.sequenceAP, this.sequenceSC, this.batch, this.status);
        }
    }
}

