/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.BatchRead;
import com.aerospike.client.BatchRecord;
import com.aerospike.client.Key;
import com.aerospike.client.Operation;
import com.aerospike.client.Record;
import com.aerospike.client.Txn;
import com.aerospike.client.Value;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.cluster.Partition;
import com.aerospike.client.command.BatchAttr;
import com.aerospike.client.command.BatchStatus;
import com.aerospike.client.command.Command;
import com.aerospike.client.command.IBatchCommand;
import com.aerospike.client.command.RecordParser;
import com.aerospike.client.command.SyncCommand;
import com.aerospike.client.metrics.LatencyType;
import com.aerospike.client.policy.BatchPolicy;
import com.aerospike.client.policy.Policy;
import java.io.IOException;

public final class BatchSingle {

    public static abstract class BaseCommand
    extends SyncCommand
    implements IBatchCommand {
        BatchStatus status;
        Key key;
        Node node;
        int sequence;
        boolean hasWrite;

        public BaseCommand(Cluster cluster, Policy policy, BatchStatus status, Key key, Node node, boolean hasWrite) {
            super(cluster, policy, key.namespace);
            this.status = status;
            this.key = key;
            this.node = node;
            this.hasWrite = hasWrite;
        }

        @Override
        public void run() {
            try {
                this.execute();
            }
            catch (AerospikeException ae) {
                if (ae.getInDoubt()) {
                    this.setInDoubt();
                }
                this.status.setException(ae);
            }
            catch (Throwable e) {
                this.setInDoubt();
                this.status.setException(new AerospikeException(e));
            }
        }

        @Override
        protected boolean isWrite() {
            return this.hasWrite;
        }

        @Override
        protected Node getNode() {
            return this.node;
        }

        @Override
        protected LatencyType getLatencyType() {
            return LatencyType.BATCH;
        }

        @Override
        protected void addSubException(AerospikeException ae) {
            this.status.addSubException(ae);
        }

        @Override
        protected boolean prepareRetry(boolean timeout) {
            if (this.hasWrite) {
                Partition p = Partition.write(this.cluster, this.policy, this.key);
                p.sequence = this.sequence;
                p.prevNode = this.node;
                p.prepareRetryWrite(timeout);
                this.node = p.getNodeWrite(this.cluster);
                this.sequence = p.sequence;
            } else {
                Partition p = Partition.read(this.cluster, this.policy, this.key);
                p.sequence = this.sequence;
                p.prevNode = this.node;
                p.prepareRetryRead(timeout);
                this.node = p.getNodeRead(this.cluster);
                this.sequence = p.sequence;
            }
            return true;
        }

        @Override
        public void setInDoubt() {
        }
    }

    public static final class TxnRoll
    extends BaseCommand {
        private final Txn txn;
        private final BatchRecord record;
        private final int attr;

        public TxnRoll(Cluster cluster, BatchPolicy policy, Txn txn, BatchRecord record, BatchStatus status, Node node, int attr) {
            super(cluster, policy, status, record.key, node, true);
            this.txn = txn;
            this.record = record;
            this.attr = attr;
        }

        @Override
        protected void writeBuffer() {
            this.setTxnRoll(this.record.key, this.txn, this.attr);
        }

        @Override
        protected void parseResult(Node node, Connection conn) throws IOException {
            RecordParser rp = new RecordParser(conn, this.dataBuffer);
            if (node.areMetricsEnabled()) {
                node.addBytesIn(this.namespace, rp.bytesIn);
            }
            if (rp.resultCode == 0) {
                this.record.resultCode = rp.resultCode;
            } else {
                this.record.setError(rp.resultCode, Command.batchInDoubt(true, this.commandSentCounter));
                this.status.setRowError();
            }
        }

        @Override
        public void setInDoubt() {
            if (this.record.resultCode == -15) {
                this.record.inDoubt = true;
            }
        }
    }

    public static final class TxnVerify
    extends BaseCommand {
        private final long version;
        private final BatchRecord record;

        public TxnVerify(Cluster cluster, BatchPolicy policy, long version, BatchRecord record, BatchStatus status, Node node) {
            super(cluster, policy, status, record.key, node, false);
            this.version = version;
            this.record = record;
        }

        @Override
        protected void writeBuffer() {
            this.setTxnVerify(this.record.key, this.version);
        }

        @Override
        protected void parseResult(Node node, Connection conn) throws IOException {
            RecordParser rp = new RecordParser(conn, this.dataBuffer);
            if (node.areMetricsEnabled()) {
                node.addBytesIn(this.namespace, rp.bytesIn);
            }
            if (rp.resultCode == 0) {
                this.record.resultCode = rp.resultCode;
            } else {
                this.record.setError(rp.resultCode, false);
                this.status.setRowError();
            }
        }
    }

    public static final class UDF
    extends BaseCommand {
        private final String packageName;
        private final String functionName;
        private final Value[] args;
        private final BatchAttr attr;
        private final BatchRecord record;

        public UDF(Cluster cluster, BatchPolicy policy, String packageName, String functionName, Value[] args, BatchAttr attr, BatchRecord record, BatchStatus status, Node node) {
            super(cluster, policy, status, record.key, node, true);
            this.packageName = packageName;
            this.functionName = functionName;
            this.args = args;
            this.attr = attr;
            this.record = record;
        }

        @Override
        protected void writeBuffer() {
            this.setUdf(this.policy, this.attr, this.record.key, this.packageName, this.functionName, this.args);
        }

        @Override
        protected void parseResult(Node node, Connection conn) throws IOException {
            RecordParser rp = new RecordParser(conn, this.dataBuffer);
            rp.parseFields(this.policy.txn, this.key, true);
            if (node.areMetricsEnabled()) {
                node.addBytesIn(this.namespace, rp.bytesIn);
            }
            if (rp.resultCode == 0) {
                this.record.setRecord(rp.parseRecord(false));
            } else if (rp.resultCode == 100) {
                Record r = rp.parseRecord(false);
                String m = r.getString("FAILURE");
                if (m != null) {
                    this.record.record = r;
                    this.record.resultCode = rp.resultCode;
                    this.record.inDoubt = Command.batchInDoubt(true, this.commandSentCounter);
                    this.status.setRowError();
                }
            } else {
                this.record.setError(rp.resultCode, Command.batchInDoubt(true, this.commandSentCounter));
                this.status.setRowError();
            }
        }

        @Override
        public void setInDoubt() {
            if (this.record.resultCode == -15) {
                this.record.inDoubt = true;
            }
        }
    }

    public static final class Delete
    extends BaseCommand {
        private final BatchAttr attr;
        private final BatchRecord record;

        public Delete(Cluster cluster, BatchPolicy policy, BatchAttr attr, BatchRecord record, BatchStatus status, Node node) {
            super(cluster, policy, status, record.key, node, true);
            this.attr = attr;
            this.record = record;
        }

        @Override
        protected void writeBuffer() {
            this.setDelete(this.policy, this.record.key, this.attr);
        }

        @Override
        protected void parseResult(Node node, Connection conn) throws IOException {
            RecordParser rp = new RecordParser(conn, this.dataBuffer);
            rp.parseFields(this.policy.txn, this.key, true);
            if (node.areMetricsEnabled()) {
                node.addBytesIn(this.namespace, rp.bytesIn);
            }
            if (rp.resultCode == 0) {
                this.record.setRecord(new Record(null, rp.generation, rp.expiration));
            } else {
                this.record.setError(rp.resultCode, Command.batchInDoubt(true, this.commandSentCounter));
                this.status.setRowError();
            }
        }

        @Override
        public void setInDoubt() {
            if (this.record.resultCode == -15) {
                this.record.inDoubt = true;
            }
        }
    }

    public static final class OperateBatchRecord
    extends BaseCommand {
        private final Operation[] ops;
        private final BatchAttr attr;
        private final BatchRecord record;

        public OperateBatchRecord(Cluster cluster, BatchPolicy policy, Operation[] ops, BatchAttr attr, BatchRecord record, BatchStatus status, Node node) {
            super(cluster, policy, status, record.key, node, attr.hasWrite);
            this.ops = ops;
            this.attr = attr;
            this.record = record;
        }

        @Override
        protected void writeBuffer() {
            this.setOperate(this.policy, this.attr, this.record.key, this.ops);
        }

        @Override
        protected void parseResult(Node node, Connection conn) throws IOException {
            RecordParser rp = new RecordParser(conn, this.dataBuffer);
            rp.parseFields(this.policy.txn, this.key, this.record.hasWrite);
            if (node.areMetricsEnabled()) {
                node.addBytesIn(this.namespace, rp.bytesIn);
            }
            if (rp.resultCode == 0) {
                this.record.setRecord(rp.parseRecord(true));
            } else {
                this.record.setError(rp.resultCode, Command.batchInDoubt(this.attr.hasWrite, this.commandSentCounter));
                this.status.setRowError();
            }
        }

        @Override
        public void setInDoubt() {
            if (this.record.resultCode == -15) {
                this.record.inDoubt = true;
            }
        }
    }

    public static final class Exists
    extends BaseCommand {
        private final Key key;
        private final boolean[] existsArray;
        private final int index;

        public Exists(Cluster cluster, Policy policy, Key key, boolean[] existsArray, int index2, BatchStatus status, Node node) {
            super(cluster, policy, status, key, node, false);
            this.key = key;
            this.existsArray = existsArray;
            this.index = index2;
        }

        @Override
        protected void writeBuffer() {
            this.setExists(this.policy, this.key);
        }

        @Override
        protected void parseResult(Node node, Connection conn) throws IOException {
            RecordParser rp = new RecordParser(conn, this.dataBuffer);
            rp.parseFields(this.policy.txn, this.key, false);
            if (node.areMetricsEnabled()) {
                node.addBytesIn(this.namespace, rp.bytesIn);
            }
            this.existsArray[this.index] = rp.resultCode == 0;
        }
    }

    public static class ReadRecord
    extends BaseCommand {
        private final BatchRead record;

        public ReadRecord(Cluster cluster, Policy policy, BatchRead record, BatchStatus status, Node node) {
            super(cluster, policy, status, record.key, node, false);
            this.record = record;
        }

        @Override
        protected void writeBuffer() {
            this.setRead(this.policy, this.record);
        }

        @Override
        protected void parseResult(Node node, Connection conn) throws IOException {
            RecordParser rp = new RecordParser(conn, this.dataBuffer);
            rp.parseFields(this.policy.txn, this.key, false);
            if (node.areMetricsEnabled()) {
                node.addBytesIn(this.namespace, rp.bytesIn);
            }
            if (rp.resultCode == 0) {
                this.record.setRecord(rp.parseRecord(true));
            } else {
                this.record.setError(rp.resultCode, false);
                this.status.setRowError();
            }
        }
    }

    public static final class ReadHeader
    extends BaseCommand {
        private final Key key;
        private final Record[] records;
        private final int index;

        public ReadHeader(Cluster cluster, Policy policy, Key key, Record[] records, int index2, BatchStatus status, Node node) {
            super(cluster, policy, status, key, node, false);
            this.key = key;
            this.records = records;
            this.index = index2;
        }

        @Override
        protected void writeBuffer() {
            this.setReadHeader(this.policy, this.key);
        }

        @Override
        protected void parseResult(Node node, Connection conn) throws IOException {
            RecordParser rp = new RecordParser(conn, this.dataBuffer);
            rp.parseFields(this.policy.txn, this.key, false);
            if (rp.resultCode == 0) {
                this.records[this.index] = new Record(null, rp.generation, rp.expiration);
            }
            if (node.areMetricsEnabled()) {
                node.addBytesIn(this.namespace, rp.bytesIn);
            }
        }
    }

    public static class Read
    extends BaseCommand {
        protected final Key key;
        private final String[] binNames;
        private final Record[] records;
        private final int index;
        private final boolean isOperation;

        public Read(Cluster cluster, Policy policy, Key key, String[] binNames, Record[] records, int index2, BatchStatus status, Node node, boolean isOperation) {
            super(cluster, policy, status, key, node, false);
            this.key = key;
            this.binNames = binNames;
            this.records = records;
            this.index = index2;
            this.isOperation = isOperation;
        }

        @Override
        protected void writeBuffer() {
            this.setRead(this.policy, this.key, this.binNames);
        }

        @Override
        protected void parseResult(Node node, Connection conn) throws IOException {
            RecordParser rp = new RecordParser(conn, this.dataBuffer);
            rp.parseFields(this.policy.txn, this.key, false);
            if (rp.resultCode == 0) {
                this.records[this.index] = rp.parseRecord(this.isOperation);
            }
            if (node.areMetricsEnabled()) {
                node.addBytesIn(this.namespace, rp.bytesIn);
            }
        }
    }

    public static final class OperateRead
    extends Read {
        private final Operation[] ops;

        public OperateRead(Cluster cluster, BatchPolicy policy, Key key, Operation[] ops, Record[] records, int index2, BatchStatus status, Node node) {
            super(cluster, policy, key, null, records, index2, status, node, true);
            this.ops = ops;
        }

        @Override
        protected void writeBuffer() {
            this.setRead(this.policy, this.key, this.ops);
        }
    }
}

