/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.Key;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.cluster.Partition;
import com.aerospike.client.command.SyncCommand;
import com.aerospike.client.metrics.LatencyType;
import com.aerospike.client.policy.Policy;

public abstract class SyncReadCommand
extends SyncCommand {
    final Key key;
    final Partition partition;

    public SyncReadCommand(Cluster cluster, Policy policy, Key key) {
        super(cluster, policy, key.namespace);
        this.key = key;
        this.partition = Partition.read(cluster, policy, key);
        cluster.addCommandCount();
    }

    @Override
    protected Node getNode() {
        return this.partition.getNodeRead(this.cluster);
    }

    @Override
    protected LatencyType getLatencyType() {
        return LatencyType.READ;
    }

    @Override
    protected boolean prepareRetry(boolean timeout) {
        this.partition.prepareRetryRead(timeout);
        return true;
    }
}

