/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.SyncWriteCommand;
import com.aerospike.client.policy.WritePolicy;
import java.io.IOException;

public final class TouchCommand
extends SyncWriteCommand {
    private boolean failOnNotFound;
    private boolean touched;

    public TouchCommand(Cluster cluster, WritePolicy writePolicy, Key key, boolean failOnNotFound) {
        super(cluster, writePolicy, key);
        this.failOnNotFound = failOnNotFound;
    }

    @Override
    protected void writeBuffer() {
        this.setTouch(this.writePolicy, this.key);
    }

    @Override
    protected void parseResult(Node node, Connection conn) throws IOException {
        int resultCode = this.parseHeader(node, conn);
        if (resultCode == 0) {
            this.touched = true;
            return;
        }
        if (resultCode == 2) {
            if (this.failOnNotFound) {
                throw new AerospikeException(resultCode);
            }
            this.touched = false;
            return;
        }
        if (resultCode == 27) {
            if (this.writePolicy.failOnFilteredOut) {
                throw new AerospikeException(resultCode);
            }
            this.touched = false;
            return;
        }
        throw new AerospikeException(resultCode);
    }

    public boolean getTouched() {
        return this.touched;
    }
}

