/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.configuration.serializers;

import com.aerospike.client.Log;
import com.aerospike.client.configuration.YamlConfigProvider;
import com.aerospike.client.configuration.primitiveprops.StringProperty;
import com.aerospike.client.configuration.serializers.DynamicConfiguration;
import com.aerospike.client.configuration.serializers.StaticConfiguration;
import java.util.List;

public class Configuration {
    public StringProperty version;
    public StaticConfiguration staticConfiguration;
    public DynamicConfiguration dynamicConfiguration;

    public StringProperty getVersion() {
        return this.version;
    }

    public void setVersion(StringProperty version) {
        List<String> supportedVersions = YamlConfigProvider.getSupportedVersions();
        if (version == null) {
            Log.error("Empty YAML config schema version. This client supports these schema versions: " + String.valueOf(supportedVersions));
        } else if (!supportedVersions.contains(version.value) && Log.warnEnabled()) {
            Log.warn("Invalid YAML config schema version " + version.value + ".  This client supports these schema versions: " + String.valueOf(supportedVersions));
        }
        this.version = version;
    }

    public StaticConfiguration getStaticConfiguration() {
        return this.staticConfiguration;
    }

    public void setStaticConfiguration(StaticConfiguration staticConfiguration) {
        this.staticConfiguration = staticConfiguration;
    }

    public DynamicConfiguration getDynamicConfiguration() {
        return this.dynamicConfiguration;
    }

    public void setDynamicConfiguration(DynamicConfiguration dynamicConfiguration) {
        this.dynamicConfiguration = dynamicConfiguration;
    }

    public boolean hasMetrics() {
        return this.dynamicConfiguration != null && this.dynamicConfiguration.dynamicMetricsConfig != null;
    }

    public boolean hasDBWCsendKey() {
        return this.dynamicConfiguration != null && this.dynamicConfiguration.dynamicBatchWriteConfig != null && this.dynamicConfiguration.dynamicBatchWriteConfig.sendKey != null;
    }

    public boolean hasDBUDFCsendKey() {
        return this.dynamicConfiguration != null && this.dynamicConfiguration.dynamicBatchUDFconfig != null && this.dynamicConfiguration.dynamicBatchUDFconfig.sendKey != null;
    }

    public boolean hasDBDCsendKey() {
        return this.dynamicConfiguration != null && this.dynamicConfiguration.dynamicBatchDeleteConfig != null && this.dynamicConfiguration.dynamicBatchDeleteConfig.sendKey != null;
    }

    public String getAppID() {
        if (this.dynamicConfiguration.dynamicClientConfig.getAppId() != null) {
            return this.dynamicConfiguration.dynamicClientConfig.appId.value;
        }
        return null;
    }

    public String toString() {
        StringBuffer propsString;
        block3: {
            propsString = new StringBuffer("{");
            try {
                if (this.getVersion() != null) {
                    propsString.append("\n\tversion= ").append(this.getVersion().value);
                }
                propsString.append("\n\tstatic= ").append(this.getStaticConfiguration());
                propsString.append("\n\tdynamic= ").append(this.getDynamicConfiguration());
                propsString.append("\n");
            }
            catch (Exception e) {
                if (!Log.warnEnabled()) break block3;
                Log.warn(e.toString());
            }
        }
        return propsString.toString();
    }
}

