/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.metrics;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class Counter {
    private final ConcurrentHashMap<String, AtomicLong> counterMap = new ConcurrentHashMap();
    private static final String noNSLabel = "";

    public void increment(String ns) {
        String namespace = ns == null ? noNSLabel : ns;
        this.counterMap.compute(namespace, (k, v) -> {
            if (v == null) {
                return new AtomicLong(1L);
            }
            v.incrementAndGet();
            return v;
        });
    }

    public void increment(String ns, long count) {
        String namespace = ns == null ? noNSLabel : ns;
        this.counterMap.compute(namespace, (k, v) -> {
            if (v == null) {
                return new AtomicLong(count);
            }
            v.getAndAdd(count);
            return v;
        });
    }

    public long getTotal() {
        AtomicLong total = new AtomicLong();
        this.counterMap.forEach((k, v) -> total.getAndAdd(v.longValue()));
        return total.get();
    }

    public long getCountByNS(String namespace) {
        AtomicLong count = this.counterMap.get(namespace);
        if (count == null) {
            return 0L;
        }
        return this.counterMap.get(namespace).longValue();
    }
}

