/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.metrics;

import com.aerospike.client.metrics.LatencyBuckets;
import com.aerospike.client.metrics.LatencyType;
import java.util.concurrent.ConcurrentHashMap;

public class Histograms {
    private final ConcurrentHashMap<String, LatencyBuckets[]> histoMap = new ConcurrentHashMap();
    private final int histoShift;
    private final int columnCount;
    private static final String noNSLabel = "";
    private final int max;

    public Histograms(int columnCount, int shift) {
        this.histoShift = shift;
        this.columnCount = columnCount;
        this.max = LatencyType.getMax();
    }

    private LatencyBuckets[] createBuckets() {
        LatencyBuckets[] buckets = new LatencyBuckets[this.max];
        for (int i = 0; i < this.max; ++i) {
            buckets[i] = new LatencyBuckets(this.columnCount, this.histoShift);
        }
        return buckets;
    }

    public void addLatency(String namespace, LatencyType type, long elapsed) {
        LatencyBuckets[] buckets;
        if (namespace == null) {
            namespace = noNSLabel;
        }
        if ((buckets = this.getBuckets(namespace)) == null) {
            LatencyBuckets[] finalBuckets = buckets = this.createBuckets();
            this.histoMap.computeIfAbsent(namespace, k -> finalBuckets);
        }
        buckets[type.ordinal()].add(elapsed);
    }

    public LatencyBuckets[] getBuckets(String namespace) {
        return this.histoMap.get(namespace);
    }

    public ConcurrentHashMap<String, LatencyBuckets[]> getMap() {
        return this.histoMap;
    }
}

