/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.metrics;

import com.aerospike.client.Log;
import com.aerospike.client.configuration.serializers.Configuration;
import com.aerospike.client.configuration.serializers.dynamicconfig.DynamicMetricsConfig;
import com.aerospike.client.metrics.MetricsListener;
import java.util.Map;

public final class MetricsPolicy {
    public MetricsListener listener;
    public String reportDir = ".";
    public long reportSizeLimit = 0L;
    public int interval = 30;
    public int latencyColumns = 7;
    public int latencyShift = 1;
    public Map<String, String> labels;
    private boolean metricsRestartRequired = false;

    public MetricsPolicy(MetricsPolicy other, Configuration config, boolean metricsEnabled) {
        this(other);
        boolean logUpdate = false;
        if (config == null) {
            return;
        }
        DynamicMetricsConfig dynMC = config.dynamicConfiguration.dynamicMetricsConfig;
        if (dynMC == null) {
            return;
        }
        if (Log.infoEnabled()) {
            logUpdate = true;
        }
        if (dynMC.labels != null && !dynMC.labels.equals(this.labels)) {
            this.labels = dynMC.labels;
            if (logUpdate) {
                Log.info("Set MetricsPolicy.labels = " + String.valueOf(this.labels));
            }
        }
        if (dynMC.latencyShift != null && dynMC.latencyShift.value != this.latencyShift) {
            this.latencyShift = dynMC.latencyShift.value;
            if (metricsEnabled) {
                this.metricsRestartRequired = true;
            }
            if (logUpdate) {
                Log.info("Set MetricsPolicy.latencyShift = " + this.latencyShift);
            }
        }
        if (dynMC.latencyColumns != null && dynMC.latencyColumns.value != this.latencyColumns) {
            this.latencyColumns = dynMC.latencyColumns.value;
            if (metricsEnabled) {
                this.metricsRestartRequired = true;
            }
            if (logUpdate) {
                Log.info("Set MetricsPolicy.latencyColumns = " + this.latencyColumns);
            }
        }
        if (this.latencyColumns < 1) {
            Log.error("An invalid # of latency columns was provided. Setting latency columns to default (7).");
            this.latencyColumns = 7;
        }
    }

    public MetricsPolicy(MetricsPolicy other) {
        this.listener = other.listener;
        this.reportDir = other.reportDir;
        this.reportSizeLimit = other.reportSizeLimit;
        this.interval = other.interval;
        this.latencyColumns = other.latencyColumns;
        this.latencyShift = other.latencyShift;
        this.labels = other.labels;
        this.metricsRestartRequired = other.metricsRestartRequired;
    }

    public MetricsPolicy() {
    }

    public void setListener(MetricsListener listener) {
        this.listener = listener;
    }

    public void setReportDir(String reportDir) {
        this.reportDir = reportDir;
    }

    public void setReportSizeLimit(long reportSizeLimit) {
        this.reportSizeLimit = reportSizeLimit;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public void setLatencyColumns(int latencyColumns) {
        this.latencyColumns = latencyColumns;
    }

    public void setLatencyShift(int latencyShift) {
        this.latencyShift = latencyShift;
    }

    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
    }

    public boolean isMetricsRestartRequired() {
        return this.metricsRestartRequired;
    }

    public void setMetricsRestartRequired(boolean metricsRestartRequired) {
        this.metricsRestartRequired = metricsRestartRequired;
    }
}

