/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.policy;

import com.aerospike.client.Log;
import com.aerospike.client.configuration.ConfigurationProvider;
import com.aerospike.client.configuration.serializers.Configuration;
import com.aerospike.client.configuration.serializers.DynamicConfiguration;
import com.aerospike.client.configuration.serializers.dynamicconfig.DynamicBatchReadConfig;
import com.aerospike.client.configuration.serializers.dynamicconfig.DynamicBatchWriteConfig;
import com.aerospike.client.policy.Policy;
import java.util.Objects;

public class BatchPolicy
extends Policy {
    @Deprecated
    public int maxConcurrentThreads = 1;
    public boolean allowInline = true;
    public boolean allowInlineSSD = false;
    public boolean respondAllKeys = true;
    @Deprecated
    public boolean sendSetName;

    public BatchPolicy(BatchPolicy other, ConfigurationProvider configProvider) {
        this(other);
        this.updateFromConfig(configProvider, false, "");
    }

    public BatchPolicy(BatchPolicy other, ConfigurationProvider configProvider, boolean isDefaultPolicy, String preText) {
        this(other);
        this.updateFromConfig(configProvider, isDefaultPolicy, preText);
    }

    public BatchPolicy(BatchPolicy other) {
        super(other);
        this.maxConcurrentThreads = other.maxConcurrentThreads;
        this.allowInline = other.allowInline;
        this.allowInlineSSD = other.allowInlineSSD;
        this.respondAllKeys = other.respondAllKeys;
        this.sendSetName = other.sendSetName;
    }

    public BatchPolicy(Policy other) {
        super(other);
    }

    public BatchPolicy() {
    }

    public static BatchPolicy ReadDefault() {
        return new BatchPolicy();
    }

    public static BatchPolicy WriteDefault() {
        BatchPolicy policy = new BatchPolicy();
        policy.maxRetries = 0;
        return policy;
    }

    private void updateFromConfig(ConfigurationProvider configProvider, boolean log2, String preText) {
        boolean logUpdate = false;
        if (configProvider == null) {
            return;
        }
        Configuration config = configProvider.fetchConfiguration();
        if (config == null) {
            return;
        }
        DynamicConfiguration dConfig = config.getDynamicConfiguration();
        if (dConfig == null) {
            return;
        }
        DynamicBatchReadConfig dynBRC = dConfig.getDynamicBatchReadConfig();
        if (dynBRC == null) {
            return;
        }
        if (log2 && Log.infoEnabled()) {
            logUpdate = true;
        }
        if (!Objects.equals(preText, "")) {
            preText = " " + (String)preText;
        }
        if (dynBRC.readModeAP != null && this.readModeAP != dynBRC.readModeAP) {
            this.readModeAP = dynBRC.readModeAP;
            if (logUpdate) {
                Log.info("Set" + (String)preText + " BatchPolicy.readModeAP = " + String.valueOf((Object)this.readModeAP));
            }
        }
        if (dynBRC.readModeSC != null && this.readModeSC != dynBRC.readModeSC) {
            this.readModeSC = dynBRC.readModeSC;
            if (logUpdate) {
                Log.info("Set" + (String)preText + " BatchPolicy.readModeSC = " + String.valueOf((Object)this.readModeSC));
            }
        }
        if (dynBRC.connectTimeout != null && this.connectTimeout != dynBRC.connectTimeout.value) {
            this.connectTimeout = dynBRC.connectTimeout.value;
            if (logUpdate) {
                Log.info("Set" + (String)preText + " BatchPolicy.connectTimeout = " + this.connectTimeout);
            }
        }
        if (dynBRC.replica != null && this.replica != dynBRC.replica) {
            this.replica = dynBRC.replica;
            if (logUpdate) {
                Log.info("Set" + (String)preText + " BatchPolicy.replica = " + String.valueOf((Object)this.replica));
            }
        }
        if (dynBRC.sleepBetweenRetries != null && this.sleepBetweenRetries != dynBRC.sleepBetweenRetries.value) {
            this.sleepBetweenRetries = dynBRC.sleepBetweenRetries.value;
            if (logUpdate) {
                Log.info("Set" + (String)preText + " BatchPolicy.sleepBetweenRetries = " + this.sleepBetweenRetries);
            }
        }
        if (dynBRC.socketTimeout != null && this.socketTimeout != dynBRC.socketTimeout.value) {
            this.socketTimeout = dynBRC.socketTimeout.value;
            if (logUpdate) {
                Log.info("Set" + (String)preText + " BatchPolicy.socketTimeout = " + this.socketTimeout);
            }
        }
        if (dynBRC.timeoutDelay != null && this.timeoutDelay != dynBRC.timeoutDelay.value) {
            this.timeoutDelay = dynBRC.timeoutDelay.value;
            if (logUpdate) {
                Log.info("Set" + (String)preText + " BatchPolicy.timeoutDelay = " + this.timeoutDelay);
            }
        }
        if (dynBRC.totalTimeout != null && this.totalTimeout != dynBRC.totalTimeout.value) {
            this.totalTimeout = dynBRC.totalTimeout.value;
            if (logUpdate) {
                Log.info("Set" + (String)preText + " BatchPolicy.totalTimeout = " + this.totalTimeout);
            }
        }
        if (dynBRC.maxRetries != null && this.maxRetries != dynBRC.maxRetries.value) {
            this.maxRetries = dynBRC.maxRetries.value;
            if (logUpdate) {
                Log.info("Set" + (String)preText + " BatchPolicy.maxRetries = " + this.maxRetries);
            }
        }
        if (dynBRC.maxConcurrentThreads != null && this.maxConcurrentThreads != dynBRC.maxConcurrentThreads.value) {
            this.maxConcurrentThreads = dynBRC.maxConcurrentThreads.value;
            if (logUpdate) {
                Log.info("Set" + (String)preText + " BatchPolicy.maxConcurrentThreads = " + this.maxConcurrentThreads);
            }
        }
        if (dynBRC.allowInline != null && this.allowInline != dynBRC.allowInline.value) {
            this.allowInline = dynBRC.allowInline.value;
            if (logUpdate) {
                Log.info("Set" + (String)preText + " BatchPolicy.allowInline = " + this.allowInline);
            }
        }
        if (dynBRC.allowInlineSSD != null && this.allowInlineSSD != dynBRC.allowInlineSSD.value) {
            this.allowInlineSSD = dynBRC.allowInlineSSD.value;
            if (logUpdate) {
                Log.info("Set" + (String)preText + " BatchPolicy.allowInlineSSD = " + this.allowInlineSSD);
            }
        }
        if (dynBRC.respondAllKeys != null && this.respondAllKeys != dynBRC.respondAllKeys.value) {
            this.respondAllKeys = dynBRC.respondAllKeys.value;
            if (logUpdate) {
                Log.info("Set" + (String)preText + " BatchPolicy.respondAllKeys = " + this.respondAllKeys);
            }
        }
    }

    public void setMaxConcurrentThreads(int maxConcurrentThreads) {
        this.maxConcurrentThreads = maxConcurrentThreads;
    }

    public void setAllowInline(boolean allowInline) {
        this.allowInline = allowInline;
    }

    public void setAllowInlineSSD(boolean allowInlineSSD) {
        this.allowInlineSSD = allowInlineSSD;
    }

    public void setRespondAllKeys(boolean respondAllKeys) {
        this.respondAllKeys = respondAllKeys;
    }

    public void graftBatchWriteConfig(ConfigurationProvider configProvider) {
        Configuration config = configProvider.fetchConfiguration();
        if (config == null) {
            return;
        }
        DynamicConfiguration dConfig = config.getDynamicConfiguration();
        if (dConfig == null) {
            return;
        }
        DynamicBatchWriteConfig dynBWC = dConfig.getDynamicBatchWriteConfig();
        if (dynBWC == null) {
            return;
        }
        if (dynBWC.connectTimeout != null && this.connectTimeout != dynBWC.connectTimeout.value) {
            this.connectTimeout = dynBWC.connectTimeout.value;
        }
        if (dynBWC.replica != null && this.replica != dynBWC.replica) {
            this.replica = dynBWC.replica;
        }
        if (dynBWC.sendKey != null && this.sendKey != dynBWC.sendKey.value) {
            this.sendKey = dynBWC.sendKey.value;
        }
        if (dynBWC.sleepBetweenRetries != null && this.sleepBetweenRetries != dynBWC.sleepBetweenRetries.value) {
            this.sleepBetweenRetries = dynBWC.sleepBetweenRetries.value;
        }
        if (dynBWC.socketTimeout != null && this.socketTimeout != dynBWC.socketTimeout.value) {
            this.socketTimeout = dynBWC.socketTimeout.value;
        }
        if (dynBWC.timeoutDelay != null && this.timeoutDelay != dynBWC.timeoutDelay.value) {
            this.timeoutDelay = dynBWC.timeoutDelay.value;
        }
        if (dynBWC.totalTimeout != null && this.totalTimeout != dynBWC.totalTimeout.value) {
            this.totalTimeout = dynBWC.totalTimeout.value;
        }
        if (dynBWC.maxRetries != null && this.maxRetries != dynBWC.maxRetries.value) {
            this.maxRetries = dynBWC.maxRetries.value;
        }
        if (dynBWC.maxConcurrentThreads != null && this.maxConcurrentThreads != dynBWC.maxConcurrentThreads.value) {
            this.maxConcurrentThreads = dynBWC.maxConcurrentThreads.value;
        }
        if (dynBWC.allowInlineSSD != null && this.allowInlineSSD != dynBWC.allowInlineSSD.value) {
            this.allowInlineSSD = dynBWC.allowInlineSSD.value;
        }
        if (dynBWC.respondAllKeys != null && this.respondAllKeys != dynBWC.respondAllKeys.value) {
            this.respondAllKeys = dynBWC.respondAllKeys.value;
        }
    }
}

