/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.policy;

import com.aerospike.client.Log;
import com.aerospike.client.configuration.ConfigurationProvider;
import com.aerospike.client.configuration.serializers.Configuration;
import com.aerospike.client.configuration.serializers.DynamicConfiguration;
import com.aerospike.client.configuration.serializers.dynamicconfig.DynamicBatchWriteConfig;
import com.aerospike.client.exp.Expression;
import com.aerospike.client.policy.CommitLevel;
import com.aerospike.client.policy.GenerationPolicy;
import com.aerospike.client.policy.RecordExistsAction;

public final class BatchWritePolicy {
    public Expression filterExp;
    public RecordExistsAction recordExistsAction = RecordExistsAction.UPDATE;
    public CommitLevel commitLevel = CommitLevel.COMMIT_ALL;
    public GenerationPolicy generationPolicy = GenerationPolicy.NONE;
    public int generation;
    public int expiration;
    public boolean durableDelete;
    public boolean onLockingOnly;
    public boolean sendKey;

    public BatchWritePolicy(BatchWritePolicy other, ConfigurationProvider configProvider) {
        this(other);
        this.updateFromConfig(configProvider, false);
    }

    public BatchWritePolicy(BatchWritePolicy other, ConfigurationProvider configProvider, boolean isDefaultPolicy) {
        this(other);
        this.updateFromConfig(configProvider, isDefaultPolicy);
    }

    public BatchWritePolicy(BatchWritePolicy other) {
        this.filterExp = other.filterExp;
        this.recordExistsAction = other.recordExistsAction;
        this.commitLevel = other.commitLevel;
        this.generationPolicy = other.generationPolicy;
        this.generation = other.generation;
        this.expiration = other.expiration;
        this.durableDelete = other.durableDelete;
        this.onLockingOnly = other.onLockingOnly;
        this.sendKey = other.sendKey;
    }

    public BatchWritePolicy() {
    }

    private void updateFromConfig(ConfigurationProvider configProvider, boolean log2) {
        boolean logUpdate = false;
        if (configProvider == null) {
            return;
        }
        Configuration config = configProvider.fetchConfiguration();
        if (config == null) {
            return;
        }
        DynamicConfiguration dConfig = config.getDynamicConfiguration();
        if (dConfig == null) {
            return;
        }
        DynamicBatchWriteConfig dynBWC = dConfig.getDynamicBatchWriteConfig();
        if (dynBWC == null) {
            return;
        }
        if (log2 && Log.infoEnabled()) {
            logUpdate = true;
        }
        if (dynBWC.sendKey != null && this.sendKey != dynBWC.sendKey.value) {
            this.sendKey = dynBWC.sendKey.value;
            if (logUpdate) {
                Log.info("Set BatchWritePolicy.sendKey = " + this.sendKey);
            }
        }
        if (dynBWC.durableDelete != null && this.durableDelete != dynBWC.durableDelete.value) {
            this.durableDelete = dynBWC.durableDelete.value;
            if (logUpdate) {
                Log.info("Set BatchWritePolicy.durableDelete = " + this.durableDelete);
            }
        }
    }

    public void setFilterExp(Expression filterExp) {
        this.filterExp = filterExp;
    }

    public void setRecordExistsAction(RecordExistsAction recordExistsAction) {
        this.recordExistsAction = recordExistsAction;
    }

    public void setCommitLevel(CommitLevel commitLevel) {
        this.commitLevel = commitLevel;
    }

    public void setGenerationPolicy(GenerationPolicy generationPolicy) {
        this.generationPolicy = generationPolicy;
    }

    public void setGeneration(int generation) {
        this.generation = generation;
    }

    public void setExpiration(int expiration) {
        this.expiration = expiration;
    }

    public void setDurableDelete(boolean durableDelete) {
        this.durableDelete = durableDelete;
    }

    public void setOnLockingOnly(boolean onLockingOnly) {
        this.onLockingOnly = onLockingOnly;
    }

    public void setSendKey(boolean sendKey) {
        this.sendKey = sendKey;
    }
}

