/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.policy;

import com.aerospike.client.Log;
import com.aerospike.client.Txn;
import com.aerospike.client.configuration.ConfigurationProvider;
import com.aerospike.client.configuration.serializers.Configuration;
import com.aerospike.client.configuration.serializers.DynamicConfiguration;
import com.aerospike.client.configuration.serializers.dynamicconfig.DynamicReadConfig;
import com.aerospike.client.exp.Expression;
import com.aerospike.client.policy.ReadModeAP;
import com.aerospike.client.policy.ReadModeSC;
import com.aerospike.client.policy.Replica;
import java.util.Objects;

public class Policy {
    public Txn txn;
    public ReadModeAP readModeAP = ReadModeAP.ONE;
    public ReadModeSC readModeSC = ReadModeSC.SESSION;
    public Replica replica = Replica.SEQUENCE;
    public Expression filterExp;
    public int connectTimeout;
    public int socketTimeout = 30000;
    public int totalTimeout = 1000;
    public int timeoutDelay;
    public int maxRetries = 2;
    public int sleepBetweenRetries;
    public int readTouchTtlPercent;
    public boolean sendKey;
    public boolean compress;
    public boolean failOnFilteredOut;

    public Policy(Policy other) {
        this.txn = other.txn;
        this.readModeAP = other.readModeAP;
        this.readModeSC = other.readModeSC;
        this.replica = other.replica;
        this.filterExp = other.filterExp;
        this.connectTimeout = other.connectTimeout;
        this.socketTimeout = other.socketTimeout;
        this.totalTimeout = other.totalTimeout;
        this.timeoutDelay = other.timeoutDelay;
        this.maxRetries = other.maxRetries;
        this.sleepBetweenRetries = other.sleepBetweenRetries;
        this.readTouchTtlPercent = other.readTouchTtlPercent;
        this.sendKey = other.sendKey;
        this.compress = other.compress;
        this.failOnFilteredOut = other.failOnFilteredOut;
    }

    public Policy(Policy other, ConfigurationProvider configProvider) {
        this(other);
        this.updateFromConfig(configProvider, false);
    }

    public Policy(Policy other, ConfigurationProvider configProvider, boolean isDefaultPolicy) {
        this(other);
        this.updateFromConfig(configProvider, isDefaultPolicy);
    }

    public Policy() {
    }

    public final void setTimeout(int timeout) {
        this.socketTimeout = timeout;
        this.totalTimeout = timeout;
    }

    public final void setTimeouts(int socketTimeout, int totalTimeout) {
        this.socketTimeout = socketTimeout;
        this.totalTimeout = totalTimeout;
        if (totalTimeout > 0 && (socketTimeout == 0 || socketTimeout > totalTimeout)) {
            this.socketTimeout = totalTimeout;
        }
    }

    public void setTxn(Txn txn) {
        this.txn = txn;
    }

    public void setReadModeAP(ReadModeAP readModeAP) {
        this.readModeAP = readModeAP;
    }

    public void setReadModeSC(ReadModeSC readModeSC) {
        this.readModeSC = readModeSC;
    }

    public void setReplica(Replica replica) {
        this.replica = replica;
    }

    public void setFilterExp(Expression filterExp) {
        this.filterExp = filterExp;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public void setTotalTimeout(int totalTimeout) {
        this.totalTimeout = totalTimeout;
    }

    public void setTimeoutDelay(int timeoutDelay) {
        this.timeoutDelay = timeoutDelay;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public void setSleepBetweenRetries(int sleepBetweenRetries) {
        this.sleepBetweenRetries = sleepBetweenRetries;
    }

    public void setReadTouchTtlPercent(int readTouchTtlPercent) {
        this.readTouchTtlPercent = readTouchTtlPercent;
    }

    public void setSendKey(boolean sendKey) {
        this.sendKey = sendKey;
    }

    public void setCompress(boolean compress) {
        this.compress = compress;
    }

    public void setFailOnFilteredOut(boolean failOnFilteredOut) {
        this.failOnFilteredOut = failOnFilteredOut;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Policy policy = (Policy)o;
        return this.connectTimeout == policy.connectTimeout && this.socketTimeout == policy.socketTimeout && this.totalTimeout == policy.totalTimeout && this.timeoutDelay == policy.timeoutDelay && this.maxRetries == policy.maxRetries && this.sleepBetweenRetries == policy.sleepBetweenRetries && this.readTouchTtlPercent == policy.readTouchTtlPercent && this.sendKey == policy.sendKey && this.compress == policy.compress && this.failOnFilteredOut == policy.failOnFilteredOut && Objects.equals(this.txn, policy.txn) && this.readModeAP == policy.readModeAP && this.readModeSC == policy.readModeSC && this.replica == policy.replica && Objects.equals(this.filterExp, policy.filterExp);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.txn, this.readModeAP, this.readModeSC, this.replica, this.filterExp, this.connectTimeout, this.socketTimeout, this.totalTimeout, this.timeoutDelay, this.maxRetries, this.sleepBetweenRetries, this.readTouchTtlPercent, this.sendKey, this.compress, this.failOnFilteredOut});
    }

    private void updateFromConfig(ConfigurationProvider configProvider, boolean log2) {
        boolean logUpdate = false;
        if (configProvider == null) {
            return;
        }
        Configuration config = configProvider.fetchConfiguration();
        if (config == null) {
            return;
        }
        DynamicConfiguration dConfig = config.getDynamicConfiguration();
        if (dConfig == null) {
            return;
        }
        DynamicReadConfig dynRC = dConfig.getDynamicReadConfig();
        if (dynRC == null) {
            return;
        }
        if (log2 && Log.infoEnabled()) {
            logUpdate = true;
        }
        if (dynRC.readModeAP != null && this.readModeAP != dynRC.readModeAP) {
            this.readModeAP = dynRC.readModeAP;
            if (logUpdate) {
                Log.info("Set Policy.readModeAP = " + String.valueOf((Object)this.readModeAP));
            }
        }
        if (dynRC.readModeSC != null && this.readModeSC != dynRC.readModeSC) {
            this.readModeSC = dynRC.readModeSC;
            if (logUpdate) {
                Log.info("Set Policy.readModeSC = " + String.valueOf((Object)this.readModeSC));
            }
        }
        if (dynRC.connectTimeout != null && this.connectTimeout != dynRC.connectTimeout.value) {
            this.connectTimeout = dynRC.connectTimeout.value;
            if (logUpdate) {
                Log.info("Set Policy.connectTimeout = " + this.connectTimeout);
            }
        }
        if (dynRC.failOnFilteredOut != null && this.failOnFilteredOut != dynRC.failOnFilteredOut.value) {
            this.failOnFilteredOut = dynRC.failOnFilteredOut.value;
            if (logUpdate) {
                Log.info("Set Policy.failOnFilteredOut = " + this.failOnFilteredOut);
            }
        }
        if (dynRC.replica != null && this.replica != dynRC.replica) {
            this.replica = dynRC.replica;
            if (logUpdate) {
                Log.info("Set Policy.replica = " + String.valueOf((Object)this.replica));
            }
        }
        if (dynRC.sleepBetweenRetries != null && this.sleepBetweenRetries != dynRC.sleepBetweenRetries.value) {
            this.sleepBetweenRetries = dynRC.sleepBetweenRetries.value;
            if (logUpdate) {
                Log.info("Set Policy.sleepBetweenRetries = " + this.sleepBetweenRetries);
            }
        }
        if (dynRC.socketTimeout != null && this.socketTimeout != dynRC.socketTimeout.value) {
            this.socketTimeout = dynRC.socketTimeout.value;
            if (logUpdate) {
                Log.info("Set Policy.socketTimeout = " + this.socketTimeout);
            }
        }
        if (dynRC.timeoutDelay != null && this.timeoutDelay != dynRC.timeoutDelay.value) {
            this.timeoutDelay = dynRC.timeoutDelay.value;
            if (logUpdate) {
                Log.info("Set Policy.timeoutDelay = " + this.timeoutDelay);
            }
        }
        if (dynRC.totalTimeout != null && this.totalTimeout != dynRC.totalTimeout.value) {
            this.totalTimeout = dynRC.totalTimeout.value;
            if (logUpdate) {
                Log.info("Set Policy.totalTimeout = " + this.totalTimeout);
            }
        }
        if (dynRC.maxRetries != null && this.maxRetries != dynRC.maxRetries.value) {
            this.maxRetries = dynRC.maxRetries.value;
            if (logUpdate) {
                Log.info("Set Policy.maxRetries = " + this.maxRetries);
            }
        }
    }
}

