/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.policy;

import com.aerospike.client.Log;
import com.aerospike.client.configuration.ConfigurationProvider;
import com.aerospike.client.configuration.serializers.Configuration;
import com.aerospike.client.configuration.serializers.DynamicConfiguration;
import com.aerospike.client.configuration.serializers.dynamicconfig.DynamicScanConfig;
import com.aerospike.client.policy.Policy;

public final class ScanPolicy
extends Policy {
    public long maxRecords;
    public int recordsPerSecond;
    public int maxConcurrentNodes;
    public boolean concurrentNodes = true;
    public boolean includeBinData = true;

    public ScanPolicy(ScanPolicy other, ConfigurationProvider configProvider) {
        this(other);
        this.updateFromConfig(configProvider, false);
    }

    public ScanPolicy(ScanPolicy other, ConfigurationProvider configProvider, boolean isDefaultPolicy) {
        this(other);
        this.updateFromConfig(configProvider, isDefaultPolicy);
    }

    public ScanPolicy(ScanPolicy other) {
        super(other);
        this.maxRecords = other.maxRecords;
        this.recordsPerSecond = other.recordsPerSecond;
        this.maxConcurrentNodes = other.maxConcurrentNodes;
        this.concurrentNodes = other.concurrentNodes;
        this.includeBinData = other.includeBinData;
    }

    public ScanPolicy(Policy other) {
        super(other);
    }

    public ScanPolicy() {
        this.totalTimeout = 0;
        this.maxRetries = 5;
    }

    private void updateFromConfig(ConfigurationProvider configProvider, boolean log2) {
        boolean logUpdate = false;
        if (configProvider == null) {
            return;
        }
        Configuration config = configProvider.fetchConfiguration();
        if (config == null) {
            return;
        }
        DynamicConfiguration dConfig = config.getDynamicConfiguration();
        if (dConfig == null) {
            return;
        }
        DynamicScanConfig dynSC = dConfig.getDynamicScanConfig();
        if (dynSC == null) {
            return;
        }
        if (log2 && Log.infoEnabled()) {
            logUpdate = true;
        }
        if (dynSC.connectTimeout != null && this.connectTimeout != dynSC.connectTimeout.value) {
            this.connectTimeout = dynSC.connectTimeout.value;
            if (logUpdate) {
                Log.info("Set ScanPolicy.connectTimeout = " + this.connectTimeout);
            }
        }
        if (dynSC.replica != null && this.replica != dynSC.replica) {
            this.replica = dynSC.replica;
            if (logUpdate) {
                Log.info("Set ScanPolicy.replica = " + String.valueOf((Object)this.replica));
            }
        }
        if (dynSC.sleepBetweenRetries != null && this.sleepBetweenRetries != dynSC.sleepBetweenRetries.value) {
            this.sleepBetweenRetries = dynSC.sleepBetweenRetries.value;
            if (logUpdate) {
                Log.info("Set ScanPolicy.sleepBetweenRetries = " + this.sleepBetweenRetries);
            }
        }
        if (dynSC.socketTimeout != null && this.timeoutDelay != dynSC.timeoutDelay.value) {
            this.socketTimeout = dynSC.socketTimeout.value;
            if (logUpdate) {
                Log.info("Set ScanPolicy.socketTimeout = " + this.socketTimeout);
            }
        }
        if (dynSC.timeoutDelay != null && this.timeoutDelay != dynSC.timeoutDelay.value) {
            this.timeoutDelay = dynSC.timeoutDelay.value;
            if (logUpdate) {
                Log.info("Set ScanPolicy.timeoutDelay = " + this.timeoutDelay);
            }
        }
        if (dynSC.totalTimeout != null && this.totalTimeout != dynSC.totalTimeout.value) {
            this.totalTimeout = dynSC.totalTimeout.value;
            if (logUpdate) {
                Log.info("Set ScanPolicy.totalTimeout = " + this.totalTimeout);
            }
        }
        if (dynSC.maxRetries != null && this.maxRetries != dynSC.maxRetries.value) {
            this.maxRetries = dynSC.maxRetries.value;
            if (logUpdate) {
                Log.info("Set ScanPolicy.maxRetries = " + this.maxRetries);
            }
        }
        if (dynSC.concurrentNodes != null && this.concurrentNodes != dynSC.concurrentNodes.value) {
            this.concurrentNodes = dynSC.concurrentNodes.value;
            if (logUpdate) {
                Log.info("Set ScanPolicy.concurrentNodes = " + this.concurrentNodes);
            }
        }
        if (dynSC.maxConcurrentNodes != null && this.maxConcurrentNodes != dynSC.maxConcurrentNodes.value) {
            this.maxConcurrentNodes = dynSC.maxConcurrentNodes.value;
            if (logUpdate) {
                Log.info("Set ScanPolicy.maxConcurrentNodes = " + this.maxConcurrentNodes);
            }
        }
    }

    public void setMaxRecords(long maxRecords) {
        this.maxRecords = maxRecords;
    }

    public void setRecordsPerSecond(int recordsPerSecond) {
        this.recordsPerSecond = recordsPerSecond;
    }

    public void setMaxConcurrentNodes(int maxConcurrentNodes) {
        this.maxConcurrentNodes = maxConcurrentNodes;
    }

    public void setConcurrentNodes(boolean concurrentNodes) {
        this.concurrentNodes = concurrentNodes;
    }

    public void setIncludeBinData(boolean includeBinData) {
        this.includeBinData = includeBinData;
    }
}

