/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.policy;

import com.aerospike.client.Log;
import com.aerospike.client.configuration.ConfigurationProvider;
import com.aerospike.client.configuration.serializers.Configuration;
import com.aerospike.client.configuration.serializers.DynamicConfiguration;
import com.aerospike.client.configuration.serializers.dynamicconfig.DynamicWriteConfig;
import com.aerospike.client.policy.CommitLevel;
import com.aerospike.client.policy.GenerationPolicy;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.RecordExistsAction;
import java.util.Objects;

public final class WritePolicy
extends Policy {
    public RecordExistsAction recordExistsAction = RecordExistsAction.UPDATE;
    public GenerationPolicy generationPolicy = GenerationPolicy.NONE;
    public CommitLevel commitLevel = CommitLevel.COMMIT_ALL;
    public int generation;
    public int expiration;
    public boolean respondAllOps;
    public boolean durableDelete;
    public boolean onLockingOnly;
    public boolean xdr;

    public WritePolicy(WritePolicy other, ConfigurationProvider configProvider) {
        this(other);
        this.updateFromConfig(configProvider, false, "");
    }

    public WritePolicy(WritePolicy other, ConfigurationProvider configProvider, boolean isDefaultPolicy, String preText) {
        this(other);
        this.updateFromConfig(configProvider, isDefaultPolicy, preText);
    }

    public WritePolicy(WritePolicy other) {
        super(other);
        this.recordExistsAction = other.recordExistsAction;
        this.generationPolicy = other.generationPolicy;
        this.commitLevel = other.commitLevel;
        this.generation = other.generation;
        this.expiration = other.expiration;
        this.respondAllOps = other.respondAllOps;
        this.durableDelete = other.durableDelete;
        this.onLockingOnly = other.onLockingOnly;
        this.xdr = other.xdr;
    }

    public WritePolicy(Policy other) {
        super(other);
    }

    public WritePolicy() {
        this.maxRetries = 0;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(new Object[]{this.commitLevel, this.durableDelete, this.expiration, this.onLockingOnly, this.generation, this.generationPolicy, this.recordExistsAction, this.respondAllOps, this.xdr});
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WritePolicy other = (WritePolicy)obj;
        return this.commitLevel == other.commitLevel && this.durableDelete == other.durableDelete && this.expiration == other.expiration && this.onLockingOnly == other.onLockingOnly && this.generation == other.generation && this.generationPolicy == other.generationPolicy && this.recordExistsAction == other.recordExistsAction && this.respondAllOps == other.respondAllOps && this.xdr == other.xdr;
    }

    private void updateFromConfig(ConfigurationProvider configProvider, boolean log2, String preText) {
        boolean logUpdate = false;
        if (configProvider == null) {
            return;
        }
        Configuration config = configProvider.fetchConfiguration();
        if (config == null) {
            return;
        }
        DynamicConfiguration dConfig = config.getDynamicConfiguration();
        if (dConfig == null) {
            return;
        }
        DynamicWriteConfig dynWC = dConfig.getDynamicWriteConfig();
        if (dynWC == null) {
            return;
        }
        if (!Objects.equals(preText, "")) {
            preText = " " + (String)preText;
        }
        if (log2 && Log.infoEnabled()) {
            logUpdate = true;
        }
        if (dynWC.connectTimeout != null && this.connectTimeout != dynWC.connectTimeout.value) {
            this.connectTimeout = dynWC.connectTimeout.value;
            if (logUpdate) {
                Log.info("Set" + (String)preText + " WritePolicy.connectTimeout = " + this.connectTimeout);
            }
        }
        if (dynWC.failOnFilteredOut != null && this.failOnFilteredOut != dynWC.failOnFilteredOut.value) {
            this.failOnFilteredOut = dynWC.failOnFilteredOut.value;
            if (logUpdate) {
                Log.info("Set" + (String)preText + " WritePolicy.failOnFilteredOut = " + this.failOnFilteredOut);
            }
        }
        if (dynWC.replica != null && this.replica != dynWC.replica) {
            this.replica = dynWC.replica;
            if (logUpdate) {
                Log.info("Set" + (String)preText + " WritePolicy.replica = " + String.valueOf((Object)this.replica));
            }
        }
        if (dynWC.sendKey != null && this.sendKey != dynWC.sendKey.value) {
            this.sendKey = dynWC.sendKey.value;
            if (logUpdate) {
                Log.info("Set" + (String)preText + " WritePolicy.sendKey = " + this.sendKey);
            }
        }
        if (dynWC.sleepBetweenRetries != null && this.sleepBetweenRetries != dynWC.sleepBetweenRetries.value) {
            this.sleepBetweenRetries = dynWC.sleepBetweenRetries.value;
            if (logUpdate) {
                Log.info("Set" + (String)preText + " WritePolicy.sleepBetweenRetries = " + this.sleepBetweenRetries);
            }
        }
        if (dynWC.socketTimeout != null && this.socketTimeout != dynWC.socketTimeout.value) {
            this.socketTimeout = dynWC.socketTimeout.value;
            if (logUpdate) {
                Log.info("Set" + (String)preText + " WritePolicy.socketTimeout = " + this.socketTimeout);
            }
        }
        if (dynWC.timeoutDelay != null && this.timeoutDelay != dynWC.timeoutDelay.value) {
            this.timeoutDelay = dynWC.timeoutDelay.value;
            if (logUpdate) {
                Log.info("Set" + (String)preText + " WritePolicy.timeoutDelay = " + this.timeoutDelay);
            }
        }
        if (dynWC.totalTimeout != null && this.totalTimeout != dynWC.totalTimeout.value) {
            this.totalTimeout = dynWC.totalTimeout.value;
            if (logUpdate) {
                Log.info("Set" + (String)preText + " WritePolicy.totalTimeout = " + this.totalTimeout);
            }
        }
        if (dynWC.maxRetries != null && this.maxRetries != dynWC.maxRetries.value) {
            this.maxRetries = dynWC.maxRetries.value;
            if (logUpdate) {
                Log.info("Set" + (String)preText + " WritePolicy.maxRetries = " + this.maxRetries);
            }
        }
        if (dynWC.durableDelete != null && this.durableDelete != dynWC.durableDelete.value) {
            this.durableDelete = dynWC.durableDelete.value;
            if (logUpdate) {
                Log.info("Set" + (String)preText + " WritePolicy.durableDelete = " + this.durableDelete);
            }
        }
    }

    public void setRecordExistsAction(RecordExistsAction recordExistsAction) {
        this.recordExistsAction = recordExistsAction;
    }

    public void setGenerationPolicy(GenerationPolicy generationPolicy) {
        this.generationPolicy = generationPolicy;
    }

    public void setCommitLevel(CommitLevel commitLevel) {
        this.commitLevel = commitLevel;
    }

    public void setGeneration(int generation) {
        this.generation = generation;
    }

    public void setExpiration(int expiration) {
        this.expiration = expiration;
    }

    public void setRespondAllOps(boolean respondAllOps) {
        this.respondAllOps = respondAllOps;
    }

    public void setDurableDelete(boolean durableDelete) {
        this.durableDelete = durableDelete;
    }

    public void setOnLockingOnly(boolean onLockingOnly) {
        this.onLockingOnly = onLockingOnly;
    }

    public void setXdr(boolean xdr) {
        this.xdr = xdr;
    }
}

