/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.query;

import com.aerospike.client.Value;
import com.aerospike.client.cdt.CTX;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.exp.Expression;
import com.aerospike.client.query.IndexCollectionType;
import com.aerospike.client.util.Pack;
import java.util.Arrays;

public final class Filter {
    private final String name;
    private final String indexName;
    private final IndexCollectionType colType;
    private final byte[] packedCtx;
    private final int valType;
    private final Value begin;
    private final Value end;
    private final byte[] packedExp;

    public static Filter equal(String name, long value, CTX ... ctx) {
        Value val = Value.get(value);
        return new Filter(name, IndexCollectionType.DEFAULT, val.getType(), val, val, ctx);
    }

    public static Filter equal(Expression exp, long value) {
        Value val = Value.get(value);
        return new Filter(null, exp.getBytes(), IndexCollectionType.DEFAULT, val.getType(), val, val);
    }

    public static Filter equalByIndex(String indexName, long value) {
        Value val = Value.get(value);
        return new Filter(indexName, null, IndexCollectionType.DEFAULT, val.getType(), val, val);
    }

    public static Filter equal(String name, String value, CTX ... ctx) {
        Value val = Value.get(value);
        return new Filter(name, IndexCollectionType.DEFAULT, val.getType(), val, val, ctx);
    }

    public static Filter equal(Expression exp, String value) {
        Value val = Value.get(value);
        return new Filter(null, exp.getBytes(), IndexCollectionType.DEFAULT, val.getType(), val, val);
    }

    public static Filter equalByIndex(String indexName, String value) {
        Value val = Value.get(value);
        return new Filter(indexName, null, IndexCollectionType.DEFAULT, val.getType(), val, val);
    }

    public static Filter equal(String name, byte[] value, CTX ... ctx) {
        Value val = Value.get(value);
        return new Filter(name, IndexCollectionType.DEFAULT, val.getType(), val, val, ctx);
    }

    public static Filter equal(Expression exp, byte[] value) {
        Value val = Value.get(value);
        return new Filter(null, exp.getBytes(), IndexCollectionType.DEFAULT, val.getType(), val, val);
    }

    public static Filter equalByIndex(String indexName, byte[] value) {
        Value val = Value.get(value);
        return new Filter(indexName, null, IndexCollectionType.DEFAULT, val.getType(), val, val);
    }

    public static Filter contains(String name, IndexCollectionType type, long value, CTX ... ctx) {
        Value val = Value.get(value);
        return new Filter(name, type, val.getType(), val, val, ctx);
    }

    public static Filter contains(Expression exp, IndexCollectionType type, long value) {
        Value val = Value.get(value);
        return new Filter(null, exp.getBytes(), type, val.getType(), val, val);
    }

    public static Filter containsByIndex(String indexName, IndexCollectionType type, long value) {
        Value val = Value.get(value);
        return new Filter(indexName, null, type, val.getType(), val, val);
    }

    public static Filter contains(String name, IndexCollectionType type, String value, CTX ... ctx) {
        Value val = Value.get(value);
        return new Filter(name, type, val.getType(), val, val, ctx);
    }

    public static Filter contains(Expression exp, IndexCollectionType type, String value) {
        Value val = Value.get(value);
        return new Filter(null, exp.getBytes(), type, val.getType(), val, val);
    }

    public static Filter containsByIndex(String indexName, IndexCollectionType type, String value) {
        Value val = Value.get(value);
        return new Filter(indexName, null, type, val.getType(), val, val);
    }

    public static Filter contains(String name, IndexCollectionType type, byte[] value, CTX ... ctx) {
        Value val = Value.get(value);
        return new Filter(name, type, val.getType(), val, val, ctx);
    }

    public static Filter contains(Expression exp, IndexCollectionType type, byte[] value) {
        Value val = Value.get(value);
        return new Filter(null, exp.getBytes(), type, val.getType(), val, val);
    }

    public static Filter containsByIndex(String indexName, IndexCollectionType type, byte[] value) {
        Value val = Value.get(value);
        return new Filter(indexName, null, type, val.getType(), val, val);
    }

    public static Filter range(String name, long begin, long end, CTX ... ctx) {
        return new Filter(name, IndexCollectionType.DEFAULT, 1, Value.get(begin), Value.get(end), ctx);
    }

    public static Filter range(Expression exp, long begin, long end) {
        return new Filter(null, exp.getBytes(), IndexCollectionType.DEFAULT, 1, Value.get(begin), Value.get(end));
    }

    public static Filter rangeByIndex(String indexName, long begin, long end) {
        return new Filter(indexName, null, IndexCollectionType.DEFAULT, 1, Value.get(begin), Value.get(end));
    }

    public static Filter range(String name, IndexCollectionType type, long begin, long end, CTX ... ctx) {
        return new Filter(name, type, 1, Value.get(begin), Value.get(end), ctx);
    }

    public static Filter range(Expression exp, IndexCollectionType type, long begin, long end) {
        return new Filter(null, exp.getBytes(), type, 1, Value.get(begin), Value.get(end));
    }

    public static Filter rangeByIndex(String indexName, IndexCollectionType type, long begin, long end) {
        return new Filter(indexName, null, type, 1, Value.get(begin), Value.get(end));
    }

    public static Filter geoWithinRegion(String name, String region, CTX ... ctx) {
        return new Filter(name, IndexCollectionType.DEFAULT, 23, Value.get(region), Value.get(region), ctx);
    }

    public static Filter geoWithinRegion(Expression exp, String region) {
        return new Filter(null, exp.getBytes(), IndexCollectionType.DEFAULT, 23, Value.get(region), Value.get(region));
    }

    public static Filter geoWithinRegionByIndex(String indexName, String region) {
        return new Filter(indexName, null, IndexCollectionType.DEFAULT, 23, Value.get(region), Value.get(region));
    }

    public static Filter geoWithinRegion(String name, IndexCollectionType type, String region, CTX ... ctx) {
        return new Filter(name, type, 23, Value.get(region), Value.get(region), ctx);
    }

    public static Filter geoWithinRegion(Expression exp, IndexCollectionType type, String region) {
        return new Filter(null, exp.getBytes(), type, 23, Value.get(region), Value.get(region));
    }

    public static Filter geoWithinRegionByIndex(String indexName, IndexCollectionType type, String region) {
        return new Filter(indexName, null, type, 23, Value.get(region), Value.get(region));
    }

    public static Filter geoWithinRadius(String name, double lng, double lat, double radius, CTX ... ctx) {
        String rgnstr = String.format("{ \"type\": \"AeroCircle\", \"coordinates\": [[%.8f, %.8f], %f] }", lng, lat, radius);
        return new Filter(name, IndexCollectionType.DEFAULT, 23, Value.get(rgnstr), Value.get(rgnstr), ctx);
    }

    public static Filter geoWithinRadius(Expression exp, double lng, double lat, double radius) {
        String rgnstr = String.format("{ \"type\": \"AeroCircle\", \"coordinates\": [[%.8f, %.8f], %f] }", lng, lat, radius);
        return new Filter(null, exp.getBytes(), IndexCollectionType.DEFAULT, 23, Value.get(rgnstr), Value.get(rgnstr));
    }

    public static Filter geoWithinRadiusByIndex(String indexName, double lng, double lat, double radius) {
        String rgnstr = String.format("{ \"type\": \"AeroCircle\", \"coordinates\": [[%.8f, %.8f], %f] }", lng, lat, radius);
        return new Filter(indexName, null, IndexCollectionType.DEFAULT, 23, Value.get(rgnstr), Value.get(rgnstr));
    }

    public static Filter geoWithinRadius(String name, IndexCollectionType type, double lng, double lat, double radius, CTX ... ctx) {
        String rgnstr = String.format("{ \"type\": \"AeroCircle\", \"coordinates\": [[%.8f, %.8f], %f] }", lng, lat, radius);
        return new Filter(name, type, 23, Value.get(rgnstr), Value.get(rgnstr), ctx);
    }

    public static Filter geoWithinRadius(Expression exp, IndexCollectionType type, double lng, double lat, double radius) {
        String rgnstr = String.format("{ \"type\": \"AeroCircle\", \"coordinates\": [[%.8f, %.8f], %f] }", lng, lat, radius);
        return new Filter(null, exp.getBytes(), type, 23, Value.get(rgnstr), Value.get(rgnstr));
    }

    public static Filter geoWithinRadiusByIndex(String indexName, IndexCollectionType type, double lng, double lat, double radius) {
        String rgnstr = String.format("{ \"type\": \"AeroCircle\", \"coordinates\": [[%.8f, %.8f], %f] }", lng, lat, radius);
        return new Filter(indexName, null, type, 23, Value.get(rgnstr), Value.get(rgnstr));
    }

    public static Filter geoContains(String name, String point, CTX ... ctx) {
        return new Filter(name, IndexCollectionType.DEFAULT, 23, Value.get(point), Value.get(point), ctx);
    }

    public static Filter geoContains(Expression exp, String point) {
        return new Filter(null, exp.getBytes(), IndexCollectionType.DEFAULT, 23, Value.get(point), Value.get(point));
    }

    public static Filter geoContainsByIndex(String indexName, String point) {
        return new Filter(indexName, null, IndexCollectionType.DEFAULT, 23, Value.get(point), Value.get(point));
    }

    public static Filter geoContains(String name, IndexCollectionType type, String point, CTX ... ctx) {
        return new Filter(name, type, 23, Value.get(point), Value.get(point), ctx);
    }

    public static Filter geoContains(Expression exp, IndexCollectionType type, String point) {
        return new Filter(null, exp.getBytes(), type, 23, Value.get(point), Value.get(point));
    }

    public static Filter geoContainsByIndex(String indexName, IndexCollectionType type, String point) {
        return new Filter(indexName, null, type, 23, Value.get(point), Value.get(point));
    }

    private Filter(String name, IndexCollectionType colType, int valType, Value begin, Value end, CTX[] ctx) {
        this(name, null, colType, valType, begin, end, ctx != null && ctx.length > 0 ? Pack.pack(ctx) : null, null);
    }

    private Filter(String indexName, byte[] exp, IndexCollectionType colType, int valType, Value begin, Value end) {
        this(null, indexName, colType, valType, begin, end, null, exp);
    }

    Filter(String name, String indexName, IndexCollectionType colType, int valType, Value begin, Value end, byte[] packedCtx, byte[] packedExp) {
        this.name = name;
        this.indexName = indexName;
        this.colType = colType;
        this.valType = valType;
        this.begin = begin;
        this.end = end;
        this.packedCtx = packedCtx;
        this.packedExp = packedExp;
    }

    public int estimateSize() {
        return Buffer.estimateSizeUtf8(this.name) + this.begin.estimateSize() + this.end.estimateSize() + 10;
    }

    public int write(byte[] buf, int offset) {
        int len = Buffer.stringToUtf8(this.name, buf, offset + 1);
        buf[offset] = (byte)len;
        offset += len + 1;
        buf[offset++] = (byte)this.valType;
        len = this.begin.write(buf, offset + 4);
        Buffer.intToBytes(len, buf, offset);
        offset += len + 4;
        len = this.end.write(buf, offset + 4);
        Buffer.intToBytes(len, buf, offset);
        return offset += len + 4;
    }

    public IndexCollectionType getCollectionType() {
        return this.colType;
    }

    public String getName() {
        return this.name;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public IndexCollectionType getColType() {
        return this.colType;
    }

    public Value getBegin() {
        return this.begin;
    }

    public Value getEnd() {
        return this.end;
    }

    public int getValType() {
        return this.valType;
    }

    public byte[] getPackedCtx() {
        return this.packedCtx;
    }

    public byte[] getPackedExp() {
        return this.packedExp;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Filter other = (Filter)obj;
        if (this.begin == null ? other.begin != null : !this.begin.equals(other.begin)) {
            return false;
        }
        if (this.colType != other.colType) {
            return false;
        }
        if (this.end == null ? other.end != null : !this.end.equals(other.end)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (!Arrays.equals(this.packedCtx, other.packedCtx)) {
            return false;
        }
        return this.valType == other.valType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.begin == null ? 0 : this.begin.hashCode());
        result = 31 * result + (this.colType == null ? 0 : this.colType.hashCode());
        result = 31 * result + (this.end == null ? 0 : this.end.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + Arrays.hashCode(this.packedCtx);
        result = 31 * result + this.valType;
        return result;
    }
}

