/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.query;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.command.MultiCommand;
import com.aerospike.client.command.SyncCommand;
import com.aerospike.client.policy.QueryPolicy;
import com.aerospike.client.query.IQueryExecutor;
import com.aerospike.client.query.PartitionTracker;
import com.aerospike.client.query.QueryPartitionCommand;
import com.aerospike.client.query.RecordSet;
import com.aerospike.client.query.Statement;
import com.aerospike.client.query.TaskGen;
import com.aerospike.client.util.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public final class QueryPartitionExecutor
implements IQueryExecutor,
Runnable {
    private final Cluster cluster;
    private final QueryPolicy policy;
    private final Statement statement;
    private final PartitionTracker tracker;
    private final RecordSet recordSet;
    private final List<QueryThread> threads;
    private final AtomicInteger completedCount;
    private final AtomicBoolean done;
    private volatile Throwable exception;
    private int maxConcurrentThreads;

    public QueryPartitionExecutor(Cluster cluster, QueryPolicy policy, Statement statement, int nodeCapacity, PartitionTracker tracker) {
        this.cluster = cluster;
        this.policy = policy;
        this.statement = statement;
        this.tracker = tracker;
        this.recordSet = new RecordSet(this, policy.recordQueueSize);
        this.threads = new ArrayList<QueryThread>(nodeCapacity);
        this.completedCount = new AtomicInteger();
        this.done = new AtomicBoolean();
        cluster.addCommandCount();
        cluster.threadFactory.newThread(this).start();
    }

    @Override
    public void run() {
        try {
            this.execute();
        }
        catch (Throwable e) {
            this.stopThreads(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute() {
        TaskGen task = new TaskGen(this.statement);
        long taskId = task.getId();
        while (true) {
            List<PartitionTracker.NodePartitions> list = this.tracker.assignPartitionsToNodes(this.cluster, this.statement.namespace);
            this.maxConcurrentThreads = this.policy.maxConcurrentNodes == 0 || this.policy.maxConcurrentNodes >= list.size() ? list.size() : this.policy.maxConcurrentNodes;
            boolean parallel = this.maxConcurrentThreads > 1 && list.size() > 1;
            ExecutorService es = null;
            List<QueryThread> list2 = this.threads;
            synchronized (list2) {
                if (this.done.get()) {
                    break;
                }
                this.threads.clear();
                if (parallel) {
                    es = Executors.newThreadPerTaskExecutor(this.cluster.threadFactory);
                    for (PartitionTracker.NodePartitions nodePartitions : list) {
                        QueryPartitionCommand command = new QueryPartitionCommand(this.cluster, this.policy, this.statement, taskId, this.recordSet, this.tracker, nodePartitions);
                        this.threads.add(new QueryThread(command));
                    }
                    for (int i = 0; i < this.maxConcurrentThreads; ++i) {
                        es.execute(this.threads.get(i));
                    }
                }
            }
            if (parallel) {
                es.close();
            } else {
                for (PartitionTracker.NodePartitions nodePartitions : list) {
                    QueryPartitionCommand command = new QueryPartitionCommand(this.cluster, this.policy, this.statement, taskId, this.recordSet, this.tracker, nodePartitions);
                    ((SyncCommand)command).execute();
                }
            }
            if (this.exception != null) break;
            this.done.set(false);
            if (this.tracker.isComplete(this.cluster, this.policy)) {
                this.recordSet.put(RecordSet.END);
                break;
            }
            if (this.policy.sleepBetweenRetries > 0) {
                Util.sleep(this.policy.sleepBetweenRetries);
            }
            this.completedCount.set(0);
            this.exception = null;
            taskId = task.nextId();
        }
    }

    private final void threadCompleted() {
        int next;
        int finished = this.completedCount.incrementAndGet();
        if (finished < this.threads.size() && (next = finished + this.maxConcurrentThreads - 1) < this.threads.size() && !this.done.get()) {
            this.threads.get(next).run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void stopThreads(Throwable cause) {
        if (this.done.compareAndSet(false, true)) {
            this.exception = cause;
            List<QueryThread> list = this.threads;
            synchronized (list) {
                for (QueryThread thread : this.threads) {
                    thread.stop();
                }
            }
            this.recordSet.abort();
        }
    }

    @Override
    public final void checkForException() {
        if (this.exception != null) {
            AerospikeException ae = this.exception instanceof AerospikeException ? (AerospikeException)this.exception : new AerospikeException(this.exception);
            this.tracker.partitionError();
            ae.setIteration(this.tracker.iteration);
            throw ae;
        }
    }

    public RecordSet getRecordSet() {
        return this.recordSet;
    }

    private final class QueryThread
    implements Runnable {
        private final MultiCommand command;

        public QueryThread(MultiCommand command) {
            this.command = command;
        }

        @Override
        public void run() {
            try {
                if (this.command.isValid()) {
                    this.command.execute();
                }
                QueryPartitionExecutor.this.threadCompleted();
            }
            catch (Throwable e) {
                QueryPartitionExecutor.this.stopThreads(e);
            }
        }

        public void stop() {
            this.command.stop();
        }
    }
}

