/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.util;

import com.aerospike.client.IAerospikeClient;
import com.aerospike.client.Info;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.policy.InfoPolicy;

public final class Version
implements Comparable<Version> {
    public static final Version SERVER_VERSION_8_1 = new Version(8, 1, 0, 0);
    private final int major;
    private final int minor;
    private final int patch;
    private final int build;
    private final String extension;

    public static Version getServerVersion(IAerospikeClient client, InfoPolicy policy) {
        Node node = client.getCluster().getRandomNode();
        return Version.getServerVersion(policy, node);
    }

    public static Version getServerVersion(InfoPolicy policy, Node node) {
        String response = Info.request(policy, node, "build");
        return new Version(response);
    }

    public Version(String version) {
        int begin;
        int i = begin = 0;
        int max = version.length();
        i = this.getNextVersionDigitEndOffset(i, max, version);
        this.major = i > begin ? Integer.parseInt(version.substring(begin, i)) : 0;
        begin = ++i;
        i = this.getNextVersionDigitEndOffset(i, max, version);
        this.minor = i > begin ? Integer.parseInt(version.substring(begin, i)) : 0;
        begin = ++i;
        i = this.getNextVersionDigitEndOffset(i, max, version);
        this.patch = i > begin ? Integer.parseInt(version.substring(begin, i)) : 0;
        begin = ++i;
        i = this.getNextVersionDigitEndOffset(i, max, version);
        this.build = i > begin ? Integer.parseInt(version.substring(begin, i)) : 0;
        begin = i;
        this.extension = begin < max ? version.substring(begin) : "";
    }

    public Version(int major, int minor, int patch, int build) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.build = build;
        this.extension = null;
    }

    private int getNextVersionDigitEndOffset(int i, int max, String version) {
        while (i < max && Character.isDigit(version.charAt(i))) {
            ++i;
        }
        return i;
    }

    @Override
    public int compareTo(Version other) {
        if (this.major != other.major) {
            return Integer.compare(this.major, other.major);
        }
        if (this.minor != other.minor) {
            return Integer.compare(this.minor, other.minor);
        }
        if (this.patch != other.patch) {
            return Integer.compare(this.patch, other.patch);
        }
        return Integer.compare(this.build, other.build);
    }

    public boolean isGreaterOrEqual(Version otherVersion) {
        return this.compareTo(otherVersion) >= 0;
    }

    public boolean isLessThan(Version otherVersion) {
        return this.compareTo(otherVersion) < 0;
    }

    public boolean isGreaterOrEqual(int major, int minor, int patch, int build) {
        return this.compareTo(new Version(major, minor, patch, build)) >= 0;
    }

    public boolean isLessThan(int major, int minor, int patch, int build) {
        return this.compareTo(new Version(major, minor, patch, build)) < 0;
    }

    public String toString() {
        if (this.extension == null) {
            return this.major + "." + this.minor + "." + this.patch + "." + this.build;
        }
        return this.major + "." + this.minor + "." + this.patch + "." + this.build + this.extension;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Version other = (Version)obj;
        return this.major == other.major && this.minor == other.minor && this.patch == other.patch;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.patch;
        return result;
    }
}

