/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.cdt;

import com.aerospike.client.Operation;
import com.aerospike.client.Value;
import com.aerospike.client.cdt.CDT;
import com.aerospike.client.cdt.CTX;
import com.aerospike.client.cdt.MapOrder;
import com.aerospike.client.cdt.MapPolicy;
import com.aerospike.client.util.Pack;
import com.aerospike.client.util.Packer;
import java.util.List;
import java.util.Map;

public class MapOperation {
    private static final int SET_TYPE = 64;
    static final int ADD = 65;
    static final int ADD_ITEMS = 66;
    static final int PUT = 67;
    static final int PUT_ITEMS = 68;
    static final int REPLACE = 69;
    static final int REPLACE_ITEMS = 70;
    private static final int INCREMENT = 73;
    private static final int DECREMENT = 74;
    private static final int CLEAR = 75;
    private static final int REMOVE_BY_KEY = 76;
    private static final int REMOVE_BY_INDEX = 77;
    private static final int REMOVE_BY_RANK = 79;
    private static final int REMOVE_BY_KEY_LIST = 81;
    private static final int REMOVE_BY_VALUE = 82;
    private static final int REMOVE_BY_VALUE_LIST = 83;
    private static final int REMOVE_BY_KEY_INTERVAL = 84;
    private static final int REMOVE_BY_INDEX_RANGE = 85;
    private static final int REMOVE_BY_VALUE_INTERVAL = 86;
    private static final int REMOVE_BY_RANK_RANGE = 87;
    private static final int REMOVE_BY_KEY_REL_INDEX_RANGE = 88;
    private static final int REMOVE_BY_VALUE_REL_RANK_RANGE = 89;
    private static final int SIZE = 96;
    private static final int GET_BY_KEY = 97;
    private static final int GET_BY_INDEX = 98;
    private static final int GET_BY_RANK = 100;
    private static final int GET_BY_VALUE = 102;
    private static final int GET_BY_KEY_INTERVAL = 103;
    private static final int GET_BY_INDEX_RANGE = 104;
    private static final int GET_BY_VALUE_INTERVAL = 105;
    private static final int GET_BY_RANK_RANGE = 106;
    private static final int GET_BY_KEY_LIST = 107;
    private static final int GET_BY_VALUE_LIST = 108;
    private static final int GET_BY_KEY_REL_INDEX_RANGE = 109;
    private static final int GET_BY_VALUE_REL_RANK_RANGE = 110;

    public static Operation create(String binName, MapOrder order, CTX ... ctx) {
        if (ctx == null || ctx.length == 0) {
            byte[] bytes = Pack.pack(64, order.attributes, ctx);
            return new Operation(Operation.Type.MAP_MODIFY, binName, Value.get(bytes));
        }
        Packer packer = new Packer();
        CDT.init(packer, ctx, 64, 1, order.flag);
        packer.packInt(order.attributes);
        return new Operation(Operation.Type.MAP_MODIFY, binName, Value.get(packer.toByteArray()));
    }

    public static Operation create(String binName, MapOrder order, boolean persistIndex, CTX ... ctx) {
        if (ctx == null || ctx.length == 0) {
            int attr = order.attributes;
            if (persistIndex) {
                attr |= 0x10;
            }
            byte[] bytes = Pack.pack(64, attr, ctx);
            return new Operation(Operation.Type.MAP_MODIFY, binName, Value.get(bytes));
        }
        Packer packer = new Packer();
        CDT.init(packer, ctx, 64, 1, order.flag);
        packer.packInt(order.attributes);
        return new Operation(Operation.Type.MAP_MODIFY, binName, Value.get(packer.toByteArray()));
    }

    public static Operation setMapPolicy(MapPolicy policy, String binName, CTX ... ctx) {
        int attr = policy.attributes;
        if (ctx != null && ctx.length != 0 && (attr & 0x10) != 0) {
            attr &= 0xFFFFFFEF;
        }
        byte[] bytes = Pack.pack(64, attr, ctx);
        return new Operation(Operation.Type.MAP_MODIFY, binName, Value.get(bytes));
    }

    public static Operation put(MapPolicy policy, String binName, Value key, Value value, CTX ... ctx) {
        Packer packer = new Packer();
        if (policy.flags != 0) {
            Pack.init(packer, ctx);
            packer.packArrayBegin(5);
            packer.packInt(67);
            key.pack(packer);
            value.pack(packer);
            packer.packInt(policy.attributes);
            packer.packInt(policy.flags);
        } else if (policy.itemCommand == 69) {
            Pack.init(packer, ctx);
            packer.packArrayBegin(3);
            packer.packInt(policy.itemCommand);
            key.pack(packer);
            value.pack(packer);
        } else {
            Pack.init(packer, ctx);
            packer.packArrayBegin(4);
            packer.packInt(policy.itemCommand);
            key.pack(packer);
            value.pack(packer);
            packer.packInt(policy.attributes);
        }
        byte[] bytes = packer.toByteArray();
        return new Operation(Operation.Type.MAP_MODIFY, binName, Value.get(bytes));
    }

    public static Operation putItems(MapPolicy policy, String binName, Map<Value, Value> map, CTX ... ctx) {
        Packer packer = new Packer();
        if (policy.flags != 0) {
            Pack.init(packer, ctx);
            packer.packArrayBegin(4);
            packer.packInt(68);
            packer.packValueMap(map);
            packer.packInt(policy.attributes);
            packer.packInt(policy.flags);
        } else if (policy.itemsCommand == 70) {
            Pack.init(packer, ctx);
            packer.packArrayBegin(2);
            packer.packInt(policy.itemsCommand);
            packer.packValueMap(map);
        } else {
            Pack.init(packer, ctx);
            packer.packArrayBegin(3);
            packer.packInt(policy.itemsCommand);
            packer.packValueMap(map);
            packer.packInt(policy.attributes);
        }
        byte[] bytes = packer.toByteArray();
        return new Operation(Operation.Type.MAP_MODIFY, binName, Value.get(bytes));
    }

    public static Operation increment(MapPolicy policy, String binName, Value key, Value incr, CTX ... ctx) {
        byte[] bytes = Pack.pack(73, key, incr, policy.attributes, ctx);
        return new Operation(Operation.Type.MAP_MODIFY, binName, Value.get(bytes));
    }

    @Deprecated
    public static Operation decrement(MapPolicy policy, String binName, Value key, Value decr, CTX ... ctx) {
        byte[] bytes = Pack.pack(74, key, decr, policy.attributes, ctx);
        return new Operation(Operation.Type.MAP_MODIFY, binName, Value.get(bytes));
    }

    public static Operation clear(String binName, CTX ... ctx) {
        byte[] bytes = Pack.pack(75, ctx);
        return new Operation(Operation.Type.MAP_MODIFY, binName, Value.get(bytes));
    }

    public static Operation removeByKey(String binName, Value key, int returnType, CTX ... ctx) {
        byte[] bytes = Pack.pack(76, returnType, key, ctx);
        return new Operation(Operation.Type.MAP_MODIFY, binName, Value.get(bytes));
    }

    public static Operation removeByKeyList(String binName, List<Value> keys, int returnType, CTX ... ctx) {
        byte[] bytes = Pack.pack(81, returnType, keys, ctx);
        return new Operation(Operation.Type.MAP_MODIFY, binName, Value.get(bytes));
    }

    public static Operation removeByKeyRange(String binName, Value keyBegin, Value keyEnd, int returnType, CTX ... ctx) {
        byte[] bytes = CDT.packRangeOperation(84, returnType, keyBegin, keyEnd, ctx);
        return new Operation(Operation.Type.MAP_MODIFY, binName, Value.get(bytes));
    }

    public static Operation removeByKeyRelativeIndexRange(String binName, Value key, int index2, int returnType, CTX ... ctx) {
        byte[] bytes = Pack.pack(88, returnType, key, index2, ctx);
        return new Operation(Operation.Type.MAP_MODIFY, binName, Value.get(bytes));
    }

    public static Operation removeByKeyRelativeIndexRange(String binName, Value key, int index2, int count, int returnType, CTX ... ctx) {
        byte[] bytes = Pack.pack(88, returnType, key, index2, count, ctx);
        return new Operation(Operation.Type.MAP_MODIFY, binName, Value.get(bytes));
    }

    public static Operation removeByValue(String binName, Value value, int returnType, CTX ... ctx) {
        byte[] bytes = Pack.pack(82, returnType, value, ctx);
        return new Operation(Operation.Type.MAP_MODIFY, binName, Value.get(bytes));
    }

    public static Operation removeByValueList(String binName, List<Value> values, int returnType, CTX ... ctx) {
        byte[] bytes = Pack.pack(83, returnType, values, ctx);
        return new Operation(Operation.Type.MAP_MODIFY, binName, Value.get(bytes));
    }

    public static Operation removeByValueRange(String binName, Value valueBegin, Value valueEnd, int returnType, CTX ... ctx) {
        byte[] bytes = CDT.packRangeOperation(86, returnType, valueBegin, valueEnd, ctx);
        return new Operation(Operation.Type.MAP_MODIFY, binName, Value.get(bytes));
    }

    public static Operation removeByValueRelativeRankRange(String binName, Value value, int rank, int returnType, CTX ... ctx) {
        byte[] bytes = Pack.pack(89, returnType, value, rank, ctx);
        return new Operation(Operation.Type.MAP_MODIFY, binName, Value.get(bytes));
    }

    public static Operation removeByValueRelativeRankRange(String binName, Value value, int rank, int count, int returnType, CTX ... ctx) {
        byte[] bytes = Pack.pack(89, returnType, value, rank, count, ctx);
        return new Operation(Operation.Type.MAP_MODIFY, binName, Value.get(bytes));
    }

    public static Operation removeByIndex(String binName, int index2, int returnType, CTX ... ctx) {
        byte[] bytes = Pack.pack(77, returnType, index2, ctx);
        return new Operation(Operation.Type.MAP_MODIFY, binName, Value.get(bytes));
    }

    public static Operation removeByIndexRange(String binName, int index2, int returnType, CTX ... ctx) {
        byte[] bytes = Pack.pack(85, returnType, index2, ctx);
        return new Operation(Operation.Type.MAP_MODIFY, binName, Value.get(bytes));
    }

    public static Operation removeByIndexRange(String binName, int index2, int count, int returnType, CTX ... ctx) {
        byte[] bytes = Pack.pack(85, returnType, index2, count, ctx);
        return new Operation(Operation.Type.MAP_MODIFY, binName, Value.get(bytes));
    }

    public static Operation removeByRank(String binName, int rank, int returnType, CTX ... ctx) {
        byte[] bytes = Pack.pack(79, returnType, rank, ctx);
        return new Operation(Operation.Type.MAP_MODIFY, binName, Value.get(bytes));
    }

    public static Operation removeByRankRange(String binName, int rank, int returnType, CTX ... ctx) {
        byte[] bytes = Pack.pack(87, returnType, rank, ctx);
        return new Operation(Operation.Type.MAP_MODIFY, binName, Value.get(bytes));
    }

    public static Operation removeByRankRange(String binName, int rank, int count, int returnType, CTX ... ctx) {
        byte[] bytes = Pack.pack(87, returnType, rank, count, ctx);
        return new Operation(Operation.Type.MAP_MODIFY, binName, Value.get(bytes));
    }

    public static Operation size(String binName, CTX ... ctx) {
        byte[] bytes = Pack.pack(96, ctx);
        return new Operation(Operation.Type.MAP_READ, binName, Value.get(bytes));
    }

    public static Operation getByKey(String binName, Value key, int returnType, CTX ... ctx) {
        byte[] bytes = Pack.pack(97, returnType, key, ctx);
        return new Operation(Operation.Type.MAP_READ, binName, Value.get(bytes));
    }

    public static Operation getByKeyRange(String binName, Value keyBegin, Value keyEnd, int returnType, CTX ... ctx) {
        byte[] bytes = CDT.packRangeOperation(103, returnType, keyBegin, keyEnd, ctx);
        return new Operation(Operation.Type.MAP_READ, binName, Value.get(bytes));
    }

    public static Operation getByKeyList(String binName, List<Value> keys, int returnType, CTX ... ctx) {
        byte[] bytes = Pack.pack(107, returnType, keys, ctx);
        return new Operation(Operation.Type.MAP_READ, binName, Value.get(bytes));
    }

    public static Operation getByKeyRelativeIndexRange(String binName, Value key, int index2, int returnType, CTX ... ctx) {
        byte[] bytes = Pack.pack(109, returnType, key, index2, ctx);
        return new Operation(Operation.Type.MAP_READ, binName, Value.get(bytes));
    }

    public static Operation getByKeyRelativeIndexRange(String binName, Value key, int index2, int count, int returnType, CTX ... ctx) {
        byte[] bytes = Pack.pack(109, returnType, key, index2, count, ctx);
        return new Operation(Operation.Type.MAP_READ, binName, Value.get(bytes));
    }

    public static Operation getByValue(String binName, Value value, int returnType, CTX ... ctx) {
        byte[] bytes = Pack.pack(102, returnType, value, ctx);
        return new Operation(Operation.Type.MAP_READ, binName, Value.get(bytes));
    }

    public static Operation getByValueRange(String binName, Value valueBegin, Value valueEnd, int returnType, CTX ... ctx) {
        byte[] bytes = CDT.packRangeOperation(105, returnType, valueBegin, valueEnd, ctx);
        return new Operation(Operation.Type.MAP_READ, binName, Value.get(bytes));
    }

    public static Operation getByValueList(String binName, List<Value> values, int returnType, CTX ... ctx) {
        byte[] bytes = Pack.pack(108, returnType, values, ctx);
        return new Operation(Operation.Type.MAP_READ, binName, Value.get(bytes));
    }

    public static Operation getByValueRelativeRankRange(String binName, Value value, int rank, int returnType, CTX ... ctx) {
        byte[] bytes = Pack.pack(110, returnType, value, rank, ctx);
        return new Operation(Operation.Type.MAP_READ, binName, Value.get(bytes));
    }

    public static Operation getByValueRelativeRankRange(String binName, Value value, int rank, int count, int returnType, CTX ... ctx) {
        byte[] bytes = Pack.pack(110, returnType, value, rank, count, ctx);
        return new Operation(Operation.Type.MAP_READ, binName, Value.get(bytes));
    }

    public static Operation getByIndex(String binName, int index2, int returnType, CTX ... ctx) {
        byte[] bytes = Pack.pack(98, returnType, index2, ctx);
        return new Operation(Operation.Type.MAP_READ, binName, Value.get(bytes));
    }

    public static Operation getByIndexRange(String binName, int index2, int returnType, CTX ... ctx) {
        byte[] bytes = Pack.pack(104, returnType, index2, ctx);
        return new Operation(Operation.Type.MAP_READ, binName, Value.get(bytes));
    }

    public static Operation getByIndexRange(String binName, int index2, int count, int returnType, CTX ... ctx) {
        byte[] bytes = Pack.pack(104, returnType, index2, count, ctx);
        return new Operation(Operation.Type.MAP_READ, binName, Value.get(bytes));
    }

    public static Operation getByRank(String binName, int rank, int returnType, CTX ... ctx) {
        byte[] bytes = Pack.pack(100, returnType, rank, ctx);
        return new Operation(Operation.Type.MAP_READ, binName, Value.get(bytes));
    }

    public static Operation getByRankRange(String binName, int rank, int returnType, CTX ... ctx) {
        byte[] bytes = Pack.pack(106, returnType, rank, ctx);
        return new Operation(Operation.Type.MAP_READ, binName, Value.get(bytes));
    }

    public static Operation getByRankRange(String binName, int rank, int count, int returnType, CTX ... ctx) {
        byte[] bytes = Pack.pack(106, returnType, rank, count, ctx);
        return new Operation(Operation.Type.MAP_READ, binName, Value.get(bytes));
    }
}

