/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.policy;

import com.aerospike.client.async.EventLoops;
import com.aerospike.client.policy.AuthMode;
import com.aerospike.client.policy.BatchDeletePolicy;
import com.aerospike.client.policy.BatchPolicy;
import com.aerospike.client.policy.BatchUDFPolicy;
import com.aerospike.client.policy.BatchWritePolicy;
import com.aerospike.client.policy.InfoPolicy;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.QueryPolicy;
import com.aerospike.client.policy.ScanPolicy;
import com.aerospike.client.policy.TCPKeepAlive;
import com.aerospike.client.policy.TlsPolicy;
import com.aerospike.client.policy.WritePolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public class ClientPolicy {
    public EventLoops eventLoops;
    public String user;
    public String password;
    public String clusterName;
    public AuthMode authMode = AuthMode.INTERNAL;
    public int timeout = 1000;
    public int loginTimeout = 5000;
    public int closeTimeout;
    public int minConnsPerNode;
    public int maxConnsPerNode = 100;
    public int asyncMinConnsPerNode;
    public int asyncMaxConnsPerNode = -1;
    public int connPoolsPerNode = 1;
    public int maxSocketIdle = 0;
    public int maxErrorRate = 100;
    public int errorRateWindow = 1;
    public int tendInterval = 1000;
    public boolean failIfNotConnected = true;
    public boolean validateClusterName = true;
    public Policy readPolicyDefault = new Policy();
    public WritePolicy writePolicyDefault = new WritePolicy();
    public ScanPolicy scanPolicyDefault = new ScanPolicy();
    public QueryPolicy queryPolicyDefault = new QueryPolicy();
    public BatchPolicy batchPolicyDefault = BatchPolicy.ReadDefault();
    public BatchPolicy batchParentPolicyWriteDefault = BatchPolicy.WriteDefault();
    public BatchWritePolicy batchWritePolicyDefault = new BatchWritePolicy();
    public BatchDeletePolicy batchDeletePolicyDefault = new BatchDeletePolicy();
    public BatchUDFPolicy batchUDFPolicyDefault = new BatchUDFPolicy();
    public InfoPolicy infoPolicyDefault = new InfoPolicy();
    public TlsPolicy tlsPolicy;
    public TCPKeepAlive keepAlive;
    public Map<String, String> ipMap;
    public ExecutorService threadPool;
    public boolean sharedThreadPool;
    public boolean useServicesAlternate;
    public boolean forceSingleNode;
    public boolean rackAware;
    public int rackId;
    public List<Integer> rackIds;

    public ClientPolicy(ClientPolicy other) {
        this.eventLoops = other.eventLoops;
        this.user = other.user;
        this.password = other.password;
        this.clusterName = other.clusterName;
        this.authMode = other.authMode;
        this.timeout = other.timeout;
        this.loginTimeout = other.loginTimeout;
        this.closeTimeout = other.closeTimeout;
        this.minConnsPerNode = other.minConnsPerNode;
        this.maxConnsPerNode = other.maxConnsPerNode;
        this.asyncMinConnsPerNode = other.asyncMinConnsPerNode;
        this.asyncMaxConnsPerNode = other.asyncMaxConnsPerNode;
        this.connPoolsPerNode = other.connPoolsPerNode;
        this.maxSocketIdle = other.maxSocketIdle;
        this.maxErrorRate = other.maxErrorRate;
        this.errorRateWindow = other.errorRateWindow;
        this.tendInterval = other.tendInterval;
        this.failIfNotConnected = other.failIfNotConnected;
        this.validateClusterName = other.validateClusterName;
        this.readPolicyDefault = new Policy(other.readPolicyDefault);
        this.writePolicyDefault = new WritePolicy(other.writePolicyDefault);
        this.scanPolicyDefault = new ScanPolicy(other.scanPolicyDefault);
        this.queryPolicyDefault = new QueryPolicy(other.queryPolicyDefault);
        this.batchPolicyDefault = new BatchPolicy(other.batchPolicyDefault);
        this.batchParentPolicyWriteDefault = new BatchPolicy(other.batchParentPolicyWriteDefault);
        this.batchWritePolicyDefault = new BatchWritePolicy(other.batchWritePolicyDefault);
        this.batchDeletePolicyDefault = new BatchDeletePolicy(other.batchDeletePolicyDefault);
        this.batchUDFPolicyDefault = new BatchUDFPolicy(other.batchUDFPolicyDefault);
        this.infoPolicyDefault = new InfoPolicy(other.infoPolicyDefault);
        this.tlsPolicy = other.tlsPolicy != null ? new TlsPolicy(other.tlsPolicy) : null;
        this.keepAlive = other.keepAlive != null ? new TCPKeepAlive(other.keepAlive) : null;
        this.ipMap = other.ipMap;
        this.threadPool = other.threadPool;
        this.sharedThreadPool = other.threadPool != null;
        this.useServicesAlternate = other.useServicesAlternate;
        this.forceSingleNode = other.forceSingleNode;
        this.rackAware = other.rackAware;
        this.rackId = other.rackId;
        this.rackIds = other.rackIds != null ? new ArrayList<Integer>(other.rackIds) : null;
    }

    public ClientPolicy() {
    }

    public void setEventLoops(EventLoops eventLoops) {
        this.eventLoops = eventLoops;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setAuthMode(AuthMode authMode) {
        this.authMode = authMode;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setLoginTimeout(int loginTimeout) {
        this.loginTimeout = loginTimeout;
    }

    public void setCloseTimeout(int closeTimeout) {
        this.closeTimeout = closeTimeout;
    }

    public void setMinConnsPerNode(int minConnsPerNode) {
        this.minConnsPerNode = minConnsPerNode;
    }

    public void setMaxConnsPerNode(int maxConnsPerNode) {
        this.maxConnsPerNode = maxConnsPerNode;
    }

    public void setAsyncMinConnsPerNode(int asyncMinConnsPerNode) {
        this.asyncMinConnsPerNode = asyncMinConnsPerNode;
    }

    public void setAsyncMaxConnsPerNode(int asyncMaxConnsPerNode) {
        this.asyncMaxConnsPerNode = asyncMaxConnsPerNode;
    }

    public void setConnPoolsPerNode(int connPoolsPerNode) {
        this.connPoolsPerNode = connPoolsPerNode;
    }

    public void setMaxSocketIdle(int maxSocketIdle) {
        this.maxSocketIdle = maxSocketIdle;
    }

    public void setMaxErrorRate(int maxErrorRate) {
        this.maxErrorRate = maxErrorRate;
    }

    public void setErrorRateWindow(int errorRateWindow) {
        this.errorRateWindow = errorRateWindow;
    }

    public void setTendInterval(int tendInterval) {
        this.tendInterval = tendInterval;
    }

    public void setFailIfNotConnected(boolean failIfNotConnected) {
        this.failIfNotConnected = failIfNotConnected;
    }

    public void setValidateClusterName(boolean validateClusterName) {
        this.validateClusterName = validateClusterName;
    }

    public void setReadPolicyDefault(Policy readPolicyDefault) {
        this.readPolicyDefault = readPolicyDefault;
    }

    public void setWritePolicyDefault(WritePolicy writePolicyDefault) {
        this.writePolicyDefault = writePolicyDefault;
    }

    public void setScanPolicyDefault(ScanPolicy scanPolicyDefault) {
        this.scanPolicyDefault = scanPolicyDefault;
    }

    public void setQueryPolicyDefault(QueryPolicy queryPolicyDefault) {
        this.queryPolicyDefault = queryPolicyDefault;
    }

    public void setBatchPolicyDefault(BatchPolicy batchPolicyDefault) {
        this.batchPolicyDefault = batchPolicyDefault;
    }

    public void setBatchParentPolicyWriteDefault(BatchPolicy batchParentPolicyWriteDefault) {
        this.batchParentPolicyWriteDefault = batchParentPolicyWriteDefault;
    }

    public void setBatchWritePolicyDefault(BatchWritePolicy batchWritePolicyDefault) {
        this.batchWritePolicyDefault = batchWritePolicyDefault;
    }

    public void setBatchDeletePolicyDefault(BatchDeletePolicy batchDeletePolicyDefault) {
        this.batchDeletePolicyDefault = batchDeletePolicyDefault;
    }

    public void setBatchUDFPolicyDefault(BatchUDFPolicy batchUDFPolicyDefault) {
        this.batchUDFPolicyDefault = batchUDFPolicyDefault;
    }

    public void setInfoPolicyDefault(InfoPolicy infoPolicyDefault) {
        this.infoPolicyDefault = infoPolicyDefault;
    }

    public void setTlsPolicy(TlsPolicy tlsPolicy) {
        this.tlsPolicy = tlsPolicy;
    }

    public void setKeepAlive(TCPKeepAlive keepAlive) {
        this.keepAlive = keepAlive;
    }

    public void setIpMap(Map<String, String> ipMap) {
        this.ipMap = ipMap;
    }

    public void setThreadPool(ExecutorService threadPool) {
        this.threadPool = threadPool;
    }

    public void setSharedThreadPool(boolean sharedThreadPool) {
        this.sharedThreadPool = sharedThreadPool;
    }

    public void setUseServicesAlternate(boolean useServicesAlternate) {
        this.useServicesAlternate = useServicesAlternate;
    }

    public void setForceSingleNode(boolean forceSingleNode) {
        this.forceSingleNode = forceSingleNode;
    }

    public void setRackAware(boolean rackAware) {
        this.rackAware = rackAware;
    }

    public void setRackId(int rackId) {
        this.rackId = rackId;
    }

    public void setRackIds(List<Integer> rackIds) {
        this.rackIds = rackIds;
    }
}

