/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client;

import com.aerospike.client.BatchRecord;
import com.aerospike.client.Key;
import com.aerospike.client.configuration.ConfigurationProvider;
import com.aerospike.client.configuration.serializers.Configuration;
import com.aerospike.client.policy.BatchDeletePolicy;
import com.aerospike.client.policy.Policy;

public final class BatchDelete
extends BatchRecord {
    public final BatchDeletePolicy policy;

    public BatchDelete(Key key) {
        super(key, true);
        this.policy = null;
    }

    public BatchDelete(BatchDeletePolicy policy, Key key) {
        super(key, true);
        this.policy = policy;
    }

    @Override
    public BatchRecord.Type getType() {
        return BatchRecord.Type.BATCH_DELETE;
    }

    @Override
    public boolean equals(BatchRecord obj, ConfigurationProvider configProvider) {
        Configuration config;
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BatchDelete other = (BatchDelete)obj;
        if (this.policy != other.policy) {
            return false;
        }
        boolean sendkey = false;
        if (this.policy != null) {
            sendkey = this.policy.sendKey;
        }
        if (configProvider != null && (config = configProvider.fetchConfiguration()) != null && config.hasDBDCsendKey()) {
            sendkey = config.dynamicConfiguration.dynamicBatchDeleteConfig.sendKey.value;
        }
        return !sendkey;
    }

    @Override
    public int size(Policy parentPolicy, ConfigurationProvider configProvider) {
        int size = 2;
        if (this.policy != null) {
            Configuration config;
            if (this.policy.filterExp != null) {
                size += this.policy.filterExp.size();
            }
            boolean sendkey = this.policy.sendKey;
            if (configProvider != null && (config = configProvider.fetchConfiguration()) != null && config.hasDBDCsendKey()) {
                sendkey = config.dynamicConfiguration.dynamicBatchDeleteConfig.sendKey.value;
            }
            if (sendkey || parentPolicy.sendKey) {
                size += this.key.userKey.estimateSize() + 5 + 1;
            }
        } else if (parentPolicy.sendKey) {
            size += this.key.userKey.estimateSize() + 5 + 1;
        }
        return size;
    }
}

