/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.async.AsyncWriteBase;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.listener.DeleteListener;
import com.aerospike.client.policy.WritePolicy;

public final class AsyncDelete
extends AsyncWriteBase {
    private final DeleteListener listener;
    private boolean existed;

    public AsyncDelete(Cluster cluster, DeleteListener listener, WritePolicy writePolicy, Key key) {
        super(cluster, writePolicy, key);
        this.listener = listener;
    }

    @Override
    protected void writeBuffer() {
        this.setDelete(this.writePolicy, this.key);
    }

    @Override
    protected boolean parseResult() {
        int resultCode = this.parseHeader();
        if (resultCode == 0) {
            this.existed = true;
            return true;
        }
        if (resultCode == 2) {
            this.existed = false;
            return true;
        }
        if (resultCode == 27) {
            if (this.policy.failOnFilteredOut) {
                throw new AerospikeException(resultCode);
            }
            this.existed = true;
            return true;
        }
        throw new AerospikeException(resultCode);
    }

    @Override
    protected void onSuccess() {
        if (this.listener != null) {
            this.listener.onSuccess(this.key, this.existed);
        }
    }

    @Override
    protected void onFailure(AerospikeException e) {
        if (this.listener != null) {
            this.listener.onFailure(e);
        }
    }
}

