/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.Value;
import com.aerospike.client.async.AsyncWriteBase;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.command.RecordParser;
import com.aerospike.client.listener.ExecuteListener;
import com.aerospike.client.policy.WritePolicy;
import java.util.Map;

public final class AsyncExecute
extends AsyncWriteBase {
    private final ExecuteListener executeListener;
    private final String packageName;
    private final String functionName;
    private final Value[] args;
    private Record record;

    public AsyncExecute(Cluster cluster, ExecuteListener listener, WritePolicy writePolicy, Key key, String packageName, String functionName, Value[] args) {
        super(cluster, writePolicy, key);
        this.executeListener = listener;
        this.packageName = packageName;
        this.functionName = functionName;
        this.args = args;
    }

    @Override
    protected void writeBuffer() {
        this.setUdf(this.writePolicy, this.key, this.packageName, this.functionName, this.args);
    }

    @Override
    protected boolean parseResult() {
        RecordParser rp = new RecordParser(this.dataBuffer, this.dataOffset, this.receiveSize);
        rp.parseFields(this.policy.txn, this.key, true);
        if (rp.resultCode == 0) {
            this.record = rp.parseRecord(false);
            return true;
        }
        if (rp.resultCode == 100) {
            this.record = rp.parseRecord(false);
            this.handleUdfError(rp.resultCode);
            return true;
        }
        if (rp.resultCode == 27) {
            if (this.policy.failOnFilteredOut) {
                throw new AerospikeException(rp.resultCode);
            }
            return true;
        }
        throw new AerospikeException(rp.resultCode);
    }

    private void handleUdfError(int resultCode) {
        String message;
        int code;
        String ret = (String)this.record.bins.get("FAILURE");
        if (ret == null) {
            throw new AerospikeException(resultCode);
        }
        try {
            String[] list = ret.split(":");
            code = Integer.parseInt(list[2].trim());
            message = list[0] + ':' + list[1] + ' ' + list[3];
        }
        catch (Throwable e) {
            throw new AerospikeException(resultCode, ret);
        }
        throw new AerospikeException(code, message);
    }

    @Override
    protected void onSuccess() {
        if (this.executeListener != null) {
            Object obj = this.parseEndResult();
            this.executeListener.onSuccess(this.key, obj);
        }
    }

    @Override
    protected void onFailure(AerospikeException e) {
        if (this.executeListener != null) {
            this.executeListener.onFailure(e);
        }
    }

    private Object parseEndResult() {
        if (this.record == null || this.record.bins == null) {
            return null;
        }
        Map<String, Object> map = this.record.bins;
        Object obj = map.get("SUCCESS");
        if (obj != null) {
            return obj;
        }
        if (map.containsKey("SUCCESS")) {
            return null;
        }
        obj = map.get("FAILURE");
        if (obj != null) {
            throw new AerospikeException(obj.toString());
        }
        throw new AerospikeException("Invalid UDF return value");
    }
}

