/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Bin;
import com.aerospike.client.Key;
import com.aerospike.client.Operation;
import com.aerospike.client.async.AsyncWriteBase;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.listener.WriteListener;
import com.aerospike.client.policy.WritePolicy;

public final class AsyncWrite
extends AsyncWriteBase {
    private final WriteListener listener;
    private final Bin[] bins;
    private final Operation.Type operation;

    public AsyncWrite(Cluster cluster, WriteListener listener, WritePolicy writePolicy, Key key, Bin[] bins, Operation.Type operation) {
        super(cluster, writePolicy, key);
        this.listener = listener;
        this.bins = bins;
        this.operation = operation;
    }

    @Override
    protected void writeBuffer() {
        this.setWrite(this.writePolicy, this.operation, this.key, this.bins);
    }

    @Override
    protected boolean parseResult() {
        int resultCode = this.parseHeader();
        if (resultCode == 0) {
            return true;
        }
        if (resultCode == 27) {
            if (this.policy.failOnFilteredOut) {
                throw new AerospikeException(resultCode);
            }
            return true;
        }
        throw new AerospikeException(resultCode);
    }

    @Override
    protected void onSuccess() {
        if (this.listener != null) {
            this.listener.onSuccess(this.key);
        }
    }

    @Override
    protected void onFailure(AerospikeException e) {
        if (this.listener != null) {
            this.listener.onFailure(e);
        }
    }
}

