/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.Key;
import com.aerospike.client.async.AsyncCommand;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.cluster.Partition;
import com.aerospike.client.command.RecordParser;
import com.aerospike.client.metrics.LatencyType;
import com.aerospike.client.policy.WritePolicy;

public abstract class AsyncWriteBase
extends AsyncCommand {
    final WritePolicy writePolicy;
    final Key key;
    final Partition partition;

    public AsyncWriteBase(Cluster cluster, WritePolicy writePolicy, Key key) {
        super(writePolicy, true, key.namespace);
        this.writePolicy = writePolicy;
        this.key = key;
        this.partition = Partition.write(cluster, writePolicy, key);
        cluster.addCommandCount();
    }

    @Override
    boolean isWrite() {
        return true;
    }

    @Override
    Node getNode(Cluster cluster) {
        return this.partition.getNodeWrite(cluster);
    }

    @Override
    protected LatencyType getLatencyType() {
        return LatencyType.WRITE;
    }

    @Override
    boolean prepareRetry(boolean timeout) {
        this.partition.prepareRetryWrite(timeout);
        return true;
    }

    @Override
    void onInDoubt() {
        if (this.writePolicy.txn != null) {
            this.writePolicy.txn.onWriteInDoubt(this.key);
        }
    }

    protected int parseHeader() {
        RecordParser rp = new RecordParser(this.dataBuffer, this.dataOffset, this.receiveSize);
        rp.parseFields(this.policy.txn, this.key, true);
        return rp.resultCode;
    }
}

