/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.cluster;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Host;
import com.aerospike.client.Info;
import com.aerospike.client.Log;
import com.aerospike.client.admin.AdminCommand;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.cluster.Peers;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.policy.ClientPolicy;
import com.aerospike.client.util.Crypto;
import com.aerospike.client.util.Util;
import com.aerospike.client.util.Version;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public final class NodeValidator {
    Node fallback;
    String name;
    Host primaryHost;
    InetSocketAddress primaryAddress;
    Connection primaryConn;
    byte[] sessionToken;
    long sessionExpiration;
    int features;
    Version version;

    public Node seedNode(Cluster cluster, Host host, Peers peers) throws Throwable {
        this.name = null;
        this.primaryHost = null;
        this.primaryAddress = null;
        this.primaryConn = null;
        this.sessionToken = null;
        this.sessionExpiration = 0L;
        this.features = 0;
        InetAddress[] addresses = NodeValidator.getAddresses(host);
        Throwable exception = null;
        for (InetAddress address : addresses) {
            try {
                this.validateAddress(cluster, address, host.tlsName, host.port, true);
                Node node = new Node(cluster, this);
                if (!this.validatePeers(peers, node)) continue;
                return node;
            }
            catch (Throwable e) {
                if (Log.debugEnabled()) {
                    Log.debug("Address " + address + ' ' + host.port + " failed: " + Util.getErrorMessage(e));
                }
                if (exception != null) continue;
                exception = e;
            }
        }
        if (this.fallback != null) {
            return null;
        }
        throw exception;
    }

    private boolean validatePeers(Peers peers, Node node) {
        if (peers == null) {
            return true;
        }
        try {
            peers.refreshCount = 0;
            node.refreshPeers(peers);
        }
        catch (Throwable e) {
            node.close();
            throw e;
        }
        if (node.peersCount == 0) {
            if (this.fallback == null) {
                this.fallback = node;
            } else {
                node.close();
            }
            return false;
        }
        if (this.fallback != null) {
            if (Log.infoEnabled()) {
                Log.info("Skip orphan node: " + this.fallback);
            }
            this.fallback.close();
            this.fallback = null;
        }
        return true;
    }

    public void validateNode(Cluster cluster, Host host) throws Throwable {
        InetAddress[] addresses = NodeValidator.getAddresses(host);
        Throwable exception = null;
        for (InetAddress address : addresses) {
            try {
                this.validateAddress(cluster, address, host.tlsName, host.port, false);
                return;
            }
            catch (Throwable e) {
                if (Log.debugEnabled()) {
                    Log.debug("Address " + address + ' ' + host.port + " failed: " + Util.getErrorMessage(e));
                }
                if (exception != null) continue;
                exception = e;
            }
        }
        throw exception;
    }

    private static InetAddress[] getAddresses(Host host) {
        InetAddress[] addresses;
        try {
            addresses = InetAddress.getAllByName(host.name);
        }
        catch (UnknownHostException uhe) {
            throw new AerospikeException.Connection("Invalid host: " + host);
        }
        if (addresses.length == 0) {
            throw new AerospikeException.Connection("Failed to find addresses for " + host);
        }
        return addresses;
    }

    private String getB64userAgent(Cluster cluster) {
        byte[] userBytes;
        ClientPolicy clientPolicy = cluster.client.getClientPolicy();
        String appIdValue = clientPolicy.appId != null ? clientPolicy.appId : ((userBytes = cluster.getUser()) != null && userBytes.length > 0 ? Buffer.utf8ToString(userBytes, 0, userBytes.length) : "not-set");
        String userAgent = "1,java-" + cluster.client.getVersion() + "," + appIdValue;
        return Crypto.encodeBase64(userAgent.getBytes());
    }

    private void validateAddress(Cluster cluster, InetAddress address, String tlsName, int port, boolean detectLoadBalancer) throws Exception {
        InetSocketAddress socketAddress = new InetSocketAddress(address, port);
        Connection conn = cluster.tlsPolicy != null ? new Connection(cluster.tlsPolicy, tlsName, socketAddress, cluster.connectTimeout) : new Connection(socketAddress, cluster.connectTimeout);
        try {
            if (cluster.authEnabled) {
                AdminCommand.LoginCommand admin = new AdminCommand.LoginCommand(cluster, conn);
                this.sessionToken = admin.sessionToken;
                this.sessionExpiration = admin.sessionExpiration;
                if (cluster.tlsPolicy != null && cluster.tlsPolicy.forLoginOnly) {
                    SwitchClear sc = new SwitchClear(cluster, conn, this.sessionToken);
                    conn.close();
                    address = sc.clearAddress;
                    socketAddress = sc.clearSocketAddress;
                    conn = sc.clearConn;
                    detectLoadBalancer = false;
                }
            }
            ArrayList<String> commands = new ArrayList<String>(6);
            commands.add("node");
            commands.add("partition-generation");
            commands.add("build");
            commands.add("features");
            commands.add("user-agent-set:value=" + this.getB64userAgent(cluster));
            boolean validateCluster = cluster.validateClusterName();
            if (validateCluster) {
                commands.add("cluster-name");
            }
            String addressCommand = null;
            if (detectLoadBalancer) {
                if (address.isLoopbackAddress()) {
                    detectLoadBalancer = false;
                } else {
                    addressCommand = cluster.tlsPolicy != null ? (cluster.useServicesAlternate ? "service-tls-alt" : "service-tls-std") : (cluster.useServicesAlternate ? "service-clear-alt" : "service-clear-std");
                    commands.add(addressCommand);
                }
            }
            HashMap<String, String> map = Info.request(conn, commands);
            this.primaryHost = new Host(address.getHostAddress(), tlsName, port);
            this.primaryAddress = socketAddress;
            this.primaryConn = conn;
            this.validateNode(map);
            this.validatePartitionGeneration(map);
            this.validateServerBuildVersion(map);
            this.setFeatures(map);
            if (validateCluster) {
                this.validateClusterName(cluster, map);
            }
            if (addressCommand != null) {
                this.setAddress(cluster, map, addressCommand, tlsName);
            }
        }
        catch (Throwable e) {
            conn.close();
            throw e;
        }
    }

    private void validateNode(HashMap<String, String> map) {
        this.name = map.get("node");
        if (this.name == null) {
            throw new AerospikeException.InvalidNode("Node name is null");
        }
    }

    private void validatePartitionGeneration(HashMap<String, String> map) {
        int gen;
        String genString = map.get("partition-generation");
        try {
            gen = Integer.parseInt(genString);
        }
        catch (Throwable e) {
            throw new AerospikeException.InvalidNode("Node " + this.name + ' ' + this.primaryHost + " returned invalid partition-generation: " + genString);
        }
        if (gen == -1) {
            throw new AerospikeException.InvalidNode("Node " + this.name + ' ' + this.primaryHost + " is not yet fully initialized");
        }
    }

    private void validateServerBuildVersion(HashMap<String, String> map) {
        String build = map.get("build");
        this.version = new Version(build);
        if (!this.version.toString().equals(build)) {
            throw new AerospikeException("Node " + this.name + " " + this.primaryAddress.toString() + " version is invalid: " + build);
        }
    }

    private void setFeatures(HashMap<String, String> map) {
        try {
            String featuresString = map.get("features");
            int begin = 0;
            int end = 0;
            while (end < featuresString.length()) {
                int len;
                end = featuresString.indexOf(59, begin);
                if (end < 0) {
                    end = featuresString.length();
                }
                if (featuresString.regionMatches(begin, "pscans", 0, len = end - begin)) {
                    this.features |= 1;
                } else if (featuresString.regionMatches(begin, "query-show", 0, len)) {
                    this.features |= 2;
                } else if (featuresString.regionMatches(begin, "batch-any", 0, len)) {
                    this.features |= 4;
                } else if (featuresString.regionMatches(begin, "pquery", 0, len)) {
                    this.features |= 8;
                }
                begin = end + 1;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if ((this.features & 1) == 0) {
            throw new AerospikeException("Node " + this.name + ' ' + this.primaryHost + " version < 4.9. This client requires server version >= 4.9");
        }
    }

    private void validateClusterName(Cluster cluster, HashMap<String, String> map) {
        String id = map.get("cluster-name");
        if (id == null || !cluster.clusterName.equals(id)) {
            throw new AerospikeException.InvalidNode("Node " + this.name + ' ' + this.primaryHost + ' ' + " expected cluster name '" + cluster.clusterName + "' received '" + id + "'");
        }
    }

    private void setAddress(Cluster cluster, HashMap<String, String> map, String addressCommand, String tlsName) {
        String alt;
        Host h;
        String result = map.get(addressCommand);
        if (result == null || result.length() == 0) {
            return;
        }
        List<Host> hosts = Host.parseServiceHosts(result);
        Iterator<Host> iterator = hosts.iterator();
        while (iterator.hasNext()) {
            Host host;
            h = host = iterator.next();
            if (cluster.ipMap != null && (alt = cluster.ipMap.get(h.name)) != null) {
                h = new Host(alt, h.port);
            }
            if (!h.equals(this.primaryHost)) continue;
            return;
        }
        for (Host host : hosts) {
            try {
                InetAddress[] addresses;
                h = host;
                if (cluster.ipMap != null && (alt = cluster.ipMap.get(h.name)) != null) {
                    h = new Host(alt, h.port);
                }
                for (InetAddress address : addresses = InetAddress.getAllByName(h.name)) {
                    try {
                        InetSocketAddress socketAddress = new InetSocketAddress(address, h.port);
                        Connection conn = cluster.tlsPolicy != null ? new Connection(cluster.tlsPolicy, tlsName, socketAddress, cluster.connectTimeout) : new Connection(socketAddress, cluster.connectTimeout);
                        try {
                            if (this.sessionToken != null && !AdminCommand.authenticate(cluster, conn, this.sessionToken)) {
                                throw new AerospikeException("Authentication failed");
                            }
                            this.primaryHost = new Host(address.getHostAddress(), tlsName, h.port);
                            this.primaryAddress = socketAddress;
                            this.primaryConn.close();
                            this.primaryConn = conn;
                            return;
                        }
                        catch (Throwable e) {
                            conn.close();
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            catch (Throwable throwable) {
            }
        }
        if (Log.infoEnabled()) {
            Log.info("Invalid address " + result + ". access-address is probably not configured on server.");
        }
    }

    private static final class SwitchClear {
        private InetAddress clearAddress;
        private InetSocketAddress clearSocketAddress;
        private Connection clearConn;

        private SwitchClear(Cluster cluster, Connection conn, byte[] sessionToken) throws Exception {
            String command = cluster.useServicesAlternate ? "service-clear-alt" : "service-clear-std";
            String result = Info.request(conn, command);
            List<Host> hosts = Host.parseServiceHosts(result);
            for (Host host : hosts) {
                try {
                    InetAddress[] addresses;
                    String alternativeHost;
                    Host clearHost = host;
                    if (cluster.ipMap != null && (alternativeHost = cluster.ipMap.get(clearHost.name)) != null) {
                        clearHost = new Host(alternativeHost, clearHost.port);
                    }
                    for (InetAddress ia : addresses = InetAddress.getAllByName(clearHost.name)) {
                        try {
                            this.clearAddress = ia;
                            this.clearSocketAddress = new InetSocketAddress(this.clearAddress, clearHost.port);
                            this.clearConn = new Connection(this.clearSocketAddress, cluster.connectTimeout);
                            try {
                                if (sessionToken != null && !AdminCommand.authenticate(cluster, this.clearConn, sessionToken)) {
                                    throw new AerospikeException("Authentication failed");
                                }
                                return;
                            }
                            catch (Throwable e) {
                                this.clearConn.close();
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
                catch (Throwable throwable) {
                }
            }
            throw new AerospikeException("Invalid non-TLS address: " + result);
        }
    }
}

