/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.cluster;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.cluster.Partitions;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.Replica;
import com.aerospike.client.query.PartitionStatus;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReferenceArray;

public final class Partition {
    private Partitions partitions;
    private final String namespace;
    private final Replica replica;
    public Node prevNode;
    private int partitionId;
    public int sequence;
    private final boolean linearize;

    public static Partition write(Cluster cluster, Policy policy, Key key) {
        HashMap<String, Partitions> map = cluster.partitionMap;
        Partitions partitions = map.get(key.namespace);
        if (partitions == null) {
            throw new AerospikeException.InvalidNamespace(key.namespace, map.size());
        }
        return new Partition(partitions, key, policy.replica, null, false);
    }

    public static Partition read(Cluster cluster, Policy policy, Key key) {
        boolean linearize;
        Replica replica;
        HashMap<String, Partitions> map = cluster.partitionMap;
        Partitions partitions = map.get(key.namespace);
        if (partitions == null) {
            throw new AerospikeException.InvalidNamespace(key.namespace, map.size());
        }
        if (partitions.scMode) {
            switch (policy.readModeSC) {
                case SESSION: {
                    replica = Replica.MASTER;
                    linearize = false;
                    break;
                }
                case LINEARIZE: {
                    replica = policy.replica == Replica.PREFER_RACK ? Replica.SEQUENCE : policy.replica;
                    linearize = true;
                    break;
                }
                default: {
                    replica = policy.replica;
                    linearize = false;
                    break;
                }
            }
        } else {
            replica = policy.replica;
            linearize = false;
        }
        return new Partition(partitions, key, replica, null, linearize);
    }

    public static Replica getReplicaSC(Policy policy) {
        switch (policy.readModeSC) {
            case SESSION: {
                return Replica.MASTER;
            }
            case LINEARIZE: {
                return policy.replica == Replica.PREFER_RACK ? Replica.SEQUENCE : policy.replica;
            }
        }
        return policy.replica;
    }

    public static Node getNodeBatchWrite(Cluster cluster, Key key, Replica replica, Node prevNode, int sequence) {
        HashMap<String, Partitions> map = cluster.partitionMap;
        Partitions partitions = map.get(key.namespace);
        if (partitions == null) {
            throw new AerospikeException.InvalidNamespace(key.namespace, map.size());
        }
        Partition p = new Partition(partitions, key, replica, prevNode, false);
        p.sequence = sequence;
        return p.getNodeWrite(cluster);
    }

    public static Node getNodeBatchRead(Cluster cluster, Key key, Replica replica, Replica replicaSC, Node prevNode, int sequence, int sequenceSC) {
        HashMap<String, Partitions> map = cluster.partitionMap;
        Partitions partitions = map.get(key.namespace);
        if (partitions == null) {
            throw new AerospikeException.InvalidNamespace(key.namespace, map.size());
        }
        if (partitions.scMode) {
            replica = replicaSC;
            sequence = sequenceSC;
        }
        Partition p = new Partition(partitions, key, replica, prevNode, false);
        p.sequence = sequence;
        return p.getNodeRead(cluster);
    }

    private Partition(Partitions partitions, Key key, Replica replica, Node prevNode, boolean linearize) {
        this.partitions = partitions;
        this.namespace = key.namespace;
        this.replica = replica;
        this.prevNode = prevNode;
        this.linearize = linearize;
        this.partitionId = Partition.getPartitionId(key.digest);
    }

    public Partition(String namespace, Replica replica) {
        this.namespace = namespace;
        this.replica = replica;
        this.linearize = false;
    }

    public static int getPartitionId(byte[] digest) {
        return (Buffer.littleBytesToInt(digest, 0) & 0xFFFF) % 4096;
    }

    public Node getNodeQuery(Cluster cluster, Partitions partitions, PartitionStatus ps) {
        Node node;
        this.partitions = partitions;
        this.partitionId = ps.id;
        this.sequence = ps.sequence;
        this.prevNode = ps.node;
        ps.node = node = this.getNodeRead(cluster);
        ps.sequence = this.sequence;
        ps.retry = false;
        return node;
    }

    public Node getNodeRead(Cluster cluster) {
        switch (this.replica) {
            default: {
                return this.getSequenceNode(cluster);
            }
            case PREFER_RACK: {
                return this.getRackNode(cluster);
            }
            case MASTER: {
                return this.getMasterNode(cluster);
            }
            case MASTER_PROLES: {
                return this.getMasterProlesNode(cluster);
            }
            case RANDOM: 
        }
        return cluster.getRandomNode();
    }

    public Node getNodeWrite(Cluster cluster) {
        switch (this.replica) {
            default: {
                return this.getSequenceNode(cluster);
            }
            case MASTER: 
            case MASTER_PROLES: {
                return this.getMasterNode(cluster);
            }
            case RANDOM: 
        }
        return cluster.getRandomNode();
    }

    public void prepareRetryRead(boolean timeout) {
        if (!timeout || !this.linearize) {
            ++this.sequence;
        }
    }

    public void prepareRetryWrite(boolean timeout) {
        if (!timeout) {
            ++this.sequence;
        }
    }

    private Node getSequenceNode(Cluster cluster) {
        AtomicReferenceArray<Node>[] replicas = this.partitions.replicas;
        int max = replicas.length;
        for (int i = 0; i < max; ++i) {
            int index2 = this.sequence % max;
            Node node = replicas[index2].get(this.partitionId);
            if (node != null && node.isActive()) {
                return node;
            }
            ++this.sequence;
        }
        Node[] nodeArray = cluster.getNodes();
        throw new AerospikeException.InvalidNode(nodeArray.length, this);
    }

    private Node getRackNode(Cluster cluster) {
        int[] rackIds;
        AtomicReferenceArray<Node>[] replicas = this.partitions.replicas;
        int max = replicas.length;
        int seq1 = 0;
        int seq2 = 0;
        Node fallback1 = null;
        Node fallback2 = null;
        for (int rackId : rackIds = cluster.rackIds) {
            int seq = this.sequence;
            for (int i = 0; i < max; ++i) {
                int index2 = seq % max;
                Node node = replicas[index2].get(this.partitionId);
                if (node != null) {
                    if (node != this.prevNode) {
                        if (node.hasRack(this.namespace, rackId)) {
                            if (node.isActive()) {
                                this.prevNode = node;
                                this.sequence = seq;
                                return node;
                            }
                        } else if (fallback1 == null && node.isActive()) {
                            fallback1 = node;
                            seq1 = seq;
                        }
                    } else if (fallback2 == null && node.isActive()) {
                        fallback2 = node;
                        seq2 = seq;
                    }
                }
                ++seq;
            }
        }
        if (fallback1 != null) {
            this.prevNode = fallback1;
            this.sequence = seq1;
            return fallback1;
        }
        if (fallback2 != null) {
            this.prevNode = fallback2;
            this.sequence = seq2;
            return fallback2;
        }
        Node[] nodeArray = cluster.getNodes();
        throw new AerospikeException.InvalidNode(nodeArray.length, this);
    }

    private Node getMasterNode(Cluster cluster) {
        Node node = this.partitions.replicas[0].get(this.partitionId);
        if (node != null && node.isActive()) {
            return node;
        }
        Node[] nodeArray = cluster.getNodes();
        throw new AerospikeException.InvalidNode(nodeArray.length, this);
    }

    private Node getMasterProlesNode(Cluster cluster) {
        AtomicReferenceArray<Node>[] replicas = this.partitions.replicas;
        for (int i = 0; i < replicas.length; ++i) {
            int index2 = Math.abs(cluster.replicaIndex.getAndIncrement() % replicas.length);
            Node node = replicas[index2].get(this.partitionId);
            if (node == null || !node.isActive()) continue;
            return node;
        }
        Node[] nodeArray = cluster.getNodes();
        throw new AerospikeException.InvalidNode(nodeArray.length, this);
    }

    public String toString() {
        return this.namespace + ':' + this.partitionId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 31 + this.namespace.hashCode();
        result = 31 * result + this.partitionId;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Partition other = (Partition)obj;
        return this.namespace.equals(other.namespace) && this.partitionId == other.partitionId;
    }
}

