/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.cluster;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Info;
import com.aerospike.client.Log;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.cluster.Partitions;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.util.Crypto;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReferenceArray;

public final class PartitionParser
extends Info {
    static final String PartitionGeneration = "partition-generation";
    static final String Replicas = "replicas";
    private HashMap<String, Partitions> map;
    private final int partitionCount;
    private final int generation;
    private boolean copied;
    private boolean regimeError;

    public PartitionParser(Connection conn, Node node, HashMap<String, Partitions> map, int partitionCount) {
        super(node, conn, PartitionGeneration, Replicas);
        this.partitionCount = partitionCount;
        this.map = map;
        if (this.length == 0) {
            throw new AerospikeException.Parse("Partition info is empty");
        }
        this.generation = this.parseGeneration();
        this.parseReplicasAll(node, Replicas);
    }

    public int getGeneration() {
        return this.generation;
    }

    public boolean isPartitionMapCopied() {
        return this.copied;
    }

    public HashMap<String, Partitions> getPartitionMap() {
        return this.map;
    }

    private int parseGeneration() {
        this.parseName(PartitionGeneration);
        int gen = this.parseInt();
        this.expect('\n');
        return gen;
    }

    private void parseReplicasAll(Node node, String command) throws AerospikeException {
        this.parseName(command);
        int begin = this.offset;
        int regime = 0;
        while (this.offset < this.length) {
            if (this.buffer[this.offset] == 58) {
                byte b;
                String namespace = Buffer.utf8ToString(this.buffer, begin, this.offset - begin, this.sb).trim();
                if (namespace.length() <= 0 || namespace.length() >= 32) {
                    String response = this.getTruncatedResponse();
                    throw new AerospikeException.Parse("Invalid partition namespace " + namespace + ". Response=" + response);
                }
                begin = ++this.offset;
                if (command == Replicas) {
                    while (this.offset < this.length && (b = this.buffer[this.offset]) != 44) {
                        ++this.offset;
                    }
                    regime = Integer.parseInt(new String(this.buffer, begin, this.offset - begin));
                    begin = ++this.offset;
                }
                while (this.offset < this.length && (b = this.buffer[this.offset]) != 44) {
                    ++this.offset;
                }
                int replicaCount = Integer.parseInt(new String(this.buffer, begin, this.offset - begin));
                Partitions partitions = this.map.get(namespace);
                if (partitions == null) {
                    partitions = new Partitions(this.partitionCount, replicaCount, regime != 0);
                    this.copyPartitionMap();
                    this.map.put(namespace, partitions);
                } else if (partitions.replicas.length != replicaCount) {
                    if (Log.infoEnabled()) {
                        Log.info("Namespace " + namespace + " replication factor changed from " + partitions.replicas.length + " to " + replicaCount);
                    }
                    Partitions tmp = new Partitions(partitions, replicaCount);
                    this.copyPartitionMap();
                    partitions = tmp;
                    this.map.put(namespace, partitions);
                }
                for (int i = 0; i < replicaCount; ++i) {
                    byte b2;
                    begin = ++this.offset;
                    while (this.offset < this.length && (b2 = this.buffer[this.offset]) != 44 && b2 != 59 && b2 != 10) {
                        ++this.offset;
                    }
                    if (this.offset == begin) {
                        String response = this.getTruncatedResponse();
                        throw new AerospikeException.Parse("Empty partition id for namespace " + namespace + ". Response=" + response);
                    }
                    this.decodeBitmap(node, partitions, i, regime, begin);
                }
                begin = ++this.offset;
                continue;
            }
            ++this.offset;
        }
    }

    private void decodeBitmap(Node node, Partitions partitions, int index2, int regime, int begin) {
        AtomicReferenceArray<Node> nodeArray = partitions.replicas[index2];
        int[] regimes = partitions.regimes;
        byte[] restoreBuffer = Crypto.decodeBase64(this.buffer, begin, this.offset - begin);
        for (int i = 0; i < this.partitionCount; ++i) {
            Node nodeOld = nodeArray.get(i);
            if ((restoreBuffer[i >> 3] & 128 >> (i & 7)) == 0) continue;
            int regimeOld = regimes[i];
            if (regime >= regimeOld) {
                if (regime > regimeOld) {
                    regimes[i] = regime;
                }
                if (nodeOld != null && nodeOld != node) {
                    nodeOld.partitionGeneration = -1;
                }
                nodeArray.lazySet(i, node);
                continue;
            }
            if (this.regimeError) continue;
            if (Log.infoEnabled()) {
                Log.info(node.toString() + " regime(" + regime + ") < old regime(" + regimeOld + ")");
            }
            this.regimeError = true;
        }
    }

    private void copyPartitionMap() {
        if (!this.copied) {
            this.map = new HashMap<String, Partitions>(this.map);
            this.copied = true;
        }
    }
}

